# Generated by default/object.tt
package Paws::SecurityHub::AwsEc2VolumeAttachment;
  use Moose;
  has AttachTime => (is => 'ro', isa => 'Str');
  has DeleteOnTermination => (is => 'ro', isa => 'Bool');
  has InstanceId => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEc2VolumeAttachment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEc2VolumeAttachment object:

  $service_obj->Method(Att1 => { AttachTime => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEc2VolumeAttachment object:

  $result = $service_obj->Method(...);
  $result->Att1->AttachTime

=head1 DESCRIPTION

An attachment to an AWS EC2 volume.

=head1 ATTRIBUTES


=head2 AttachTime => Str

The datetime when the attachment initiated.


=head2 DeleteOnTermination => Bool

Whether the EBS volume is deleted when the EC2 instance is terminated.


=head2 InstanceId => Str

The identifier of the EC2 instance.


=head2 Status => Str

The attachment state of the volume.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

