/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_dd_DragZone({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":["Ext.grid.GridDragZone","Ext.tree.TreeDragZone"],"extends":"Ext.dd.DragSource","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='docClass'>Ext.dd.DragDrop</a><div class='subclass '><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='docClass'>Ext.dd.DD</a><div class='subclass '><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='docClass'>Ext.dd.DDProxy</a><div class='subclass '><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='docClass'>Ext.dd.DragSource</a><div class='subclass '><strong>Ext.dd.DragZone</strong></div></div></div></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Ext.grid.GridDragZone' rel='Ext.grid.GridDragZone' class='docClass'>Ext.grid.GridDragZone</a></div><div class='dependency'><a href='#!/api/Ext.tree.TreeDragZone' rel='Ext.tree.TreeDragZone' class='docClass'>Ext.tree.TreeDragZone</a></div><h4>Files</h4><div class='dependency'><a href='source/DragZone.html#Ext-dd-DragZone' target='_blank'>DragZone.js</a></div></pre><div class='doc-contents'><p>This class provides a container DD instance that allows dragging of multiple child source nodes.</p>\n\n\n<p>This class does not move the drag target nodes, but a proxy element which may contain\nany DOM structure you wish. The DOM element to show in the proxy is provided by either a\nprovided implementation of <a href=\"#!/api/Ext.dd.DragZone-method-getDragData\" rel=\"Ext.dd.DragZone-method-getDragData\" class=\"docClass\">getDragData</a>, or by registered draggables registered with <a href=\"#!/api/Ext.dd.Registry\" rel=\"Ext.dd.Registry\" class=\"docClass\">Ext.dd.Registry</a></p>\n\n\n<p>If you wish to provide draggability for an arbitrary number of DOM nodes, each of which represent some\napplication object (For example nodes in a <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>) then use of this class\nis the most efficient way to \"activate\" those nodes.</p>\n\n\n<p>By default, this class requires that draggable child nodes are registered with <a href=\"#!/api/Ext.dd.Registry\" rel=\"Ext.dd.Registry\" class=\"docClass\">Ext.dd.Registry</a>.\nHowever a simpler way to allow a DragZone to manage any number of draggable elements is to configure\nthe DragZone with  an implementation of the <a href=\"#!/api/Ext.dd.DragZone-method-getDragData\" rel=\"Ext.dd.DragZone-method-getDragData\" class=\"docClass\">getDragData</a> method which interrogates the passed\nmouse event to see if it has taken place within an element, or class of elements. This is easily done\nby using the event's <a href=\"#!/api/Ext.EventObject-method-getTarget\" rel=\"Ext.EventObject-method-getTarget\" class=\"docClass\">getTarget</a> method to identify a node based on a\n<a href=\"#!/api/Ext.DomQuery\" rel=\"Ext.DomQuery\" class=\"docClass\">Ext.DomQuery</a> selector. For example, to make the nodes of a DataView draggable, use the following\ntechnique. Knowledge of the use of the DataView is required:</p>\n\n\n<pre><code>myDataView.on('render', function(v) {\n    myDataView.dragZone = new <a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">Ext.dd.DragZone</a>(v.getEl(), {\n\n//      On receipt of a mousedown event, see if it is within a DataView node.\n//      Return a drag data object if so.\n        getDragData: function(e) {\n\n//          Use the DataView's own itemSelector (a mandatory property) to\n//          test if the mousedown is within one of the DataView's nodes.\n            var sourceEl = e.getTarget(v.itemSelector, 10);\n\n//          If the mousedown is within a DataView node, clone the node to produce\n//          a ddel element for use by the drag proxy. Also add application data\n//          to the returned data object.\n            if (sourceEl) {\n                d = sourceEl.cloneNode(true);\n                d.id = <a href=\"#!/api/Ext-method-id\" rel=\"Ext-method-id\" class=\"docClass\">Ext.id</a>();\n                return {\n                    ddel: d,\n                    sourceEl: sourceEl,\n                    repairXY: <a href=\"#!/api/Ext-method-fly\" rel=\"Ext-method-fly\" class=\"docClass\">Ext.fly</a>(sourceEl).getXY(),\n                    sourceStore: v.store,\n                    draggedRecord: v.<a href=\"#!/api/Ext.DataView-method-getRecord\" rel=\"Ext.DataView-method-getRecord\" class=\"docClass\">getRecord</a>(sourceEl)\n                }\n            }\n        },\n\n//      Provide coordinates for the proxy to slide back to on failed drag.\n//      This is the original XY coordinates of the draggable element captured\n//      in the getDragData method.\n        getRepairXY: function() {\n            return this.dragData.repairXY;\n        }\n    });\n});</code></pre>\n\n\n<p>See the <a href=\"#!/api/Ext.dd.DropZone\" rel=\"Ext.dd.DropZone\" class=\"docClass\">DropZone</a> documentation for details about building a DropZone which\ncooperates with this DragZone.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-containerScroll' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.dd.DragZone'>Ext.dd.DragZone</span><br/><a href='source/DragZone.html#Ext-dd-DragZone-cfg-containerScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragZone-cfg-containerScroll' class='name not-expandable'>containerScroll</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True to register this container with the Scrollmanager\nfor auto scrolling during drag operations.</p>\n</div><div class='long'><p>True to register this container with the Scrollmanager\nfor auto scrolling during drag operations.</p>\n</div></div></div><div id='cfg-ddGroup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-cfg-ddGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-cfg-ddGroup' class='name expandable'>ddGroup</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A named drag drop group to which this object belongs. ...</div><div class='long'><p>A named drag drop group to which this object belongs.  If a group is specified, then this object will only\ninteract with other drag drop objects in the same group (defaults to undefined).</p>\n</div></div></div><div id='cfg-dropAllowed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-cfg-dropAllowed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-cfg-dropAllowed' class='name expandable'>dropAllowed</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class returned to the drag source when drop is allowed (defaults to \"x-dd-drop-ok\"). ...</div><div class='long'><p>The CSS class returned to the drag source when drop is allowed (defaults to \"x-dd-drop-ok\").</p>\n<p>Defaults to: <code>&quot;x-dd-drop-ok&quot;</code></p></div></div></div><div id='cfg-dropNotAllowed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-cfg-dropNotAllowed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-cfg-dropNotAllowed' class='name expandable'>dropNotAllowed</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class returned to the drag source when drop is not allowed (defaults to \"x-dd-drop-nodrop\"). ...</div><div class='long'><p>The CSS class returned to the drag source when drop is not allowed (defaults to \"x-dd-drop-nodrop\").</p>\n<p>Defaults to: <code>&quot;x-dd-drop-nodrop&quot;</code></p></div></div></div><div id='cfg-hlColor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.dd.DragZone'>Ext.dd.DragZone</span><br/><a href='source/DragZone.html#Ext-dd-DragZone-cfg-hlColor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragZone-cfg-hlColor' class='name expandable'>hlColor</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The color to use when visually highlighting the drag source in the afterRepair\nmethod after a failed drop (defaults t...</div><div class='long'><p>The color to use when visually highlighting the drag source in the afterRepair\nmethod after a failed drop (defaults to \"c3daf9\" - light blue)</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-__ygDragDrop' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-__ygDragDrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-__ygDragDrop' class='name expandable'>__ygDragDrop</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Internal typeof flag ...</div><div class='long'><p>Internal typeof flag</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-_domRef' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-_domRef' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-_domRef' class='name not-expandable'>_domRef</a><span> : Object</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'><p>Cached reference to the linked element</p>\n</div><div class='long'><p>Cached reference to the linked element</p>\n</div></div></div><div id='property-available' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-available' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-available' class='name expandable'>available</a><span> : boolean</span></div><div class='description'><div class='short'>The available property is false until the linked dom element is accessible. ...</div><div class='long'><p>The available property is false until the linked dom element is accessible.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-centerFrame' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='defined-in docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDCore.html#Ext-dd-DDProxy-property-centerFrame' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-property-centerFrame' class='name expandable'>centerFrame</a><span> : boolean</span></div><div class='description'><div class='short'>By default the frame is positioned exactly where the drag element is, so\nwe use the cursor offset provided by Ext.dd.DD. ...</div><div class='long'><p>By default the frame is positioned exactly where the drag element is, so\nwe use the cursor offset provided by <a href=\"#!/api/Ext.dd.DD\" rel=\"Ext.dd.DD\" class=\"docClass\">Ext.dd.DD</a>.  Another option that works only if\nyou do not have constraints on the obj is to have the drag frame centered\naround the cursor.  Set centerFrame to true for this effect.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-config' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-config' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-config' class='name not-expandable'>config</a><span> : object</span></div><div class='description'><div class='short'><p>Configuration attributes passed into the constructor</p>\n</div><div class='long'><p>Configuration attributes passed into the constructor</p>\n</div></div></div><div id='property-constrainX' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-constrainX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-constrainX' class='name expandable'>constrainX</a><span> : boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Set to true when horizontal contraints are applied ...</div><div class='long'><p>Set to true when horizontal contraints are applied</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-constrainY' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-constrainY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-constrainY' class='name expandable'>constrainY</a><span> : boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Set to true when vertical contraints are applied ...</div><div class='long'><p>Set to true when vertical contraints are applied</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-defaultPadding' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-defaultPadding' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-defaultPadding' class='name expandable'>defaultPadding</a><span> : Object</span></div><div class='description'><div class='short'>Provides default constraint padding to \"constrainTo\" elements (defaults to {left: 0, right:0, top:0, bottom:0}). ...</div><div class='long'><p>Provides default constraint padding to \"constrainTo\" elements (defaults to {left: 0, right:0, top:0, bottom:0}).</p>\n<p>Defaults to: <code>{left: 0, right: 0, top: 0, bottom: 0}</code></p></div></div></div><div id='property-dragData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.dd.DragZone'>Ext.dd.DragZone</span><br/><a href='source/DragZone.html#Ext-dd-DragZone-property-dragData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragZone-property-dragData' class='name expandable'>dragData</a><span> : Object</span></div><div class='description'><div class='short'>This property contains the data representing the dragged object. ...</div><div class='long'><p>This property contains the data representing the dragged object. This data is set up by the implementation\nof the <a href=\"#!/api/Ext.dd.DragZone-method-getDragData\" rel=\"Ext.dd.DragZone-method-getDragData\" class=\"docClass\">getDragData</a> method. It must contain a <tt>ddel</tt> property, but can contain\nany other data according to the application's needs.</p>\n</div></div></div><div id='property-dragElId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-dragElId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-dragElId' class='name expandable'>dragElId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>The id of the element that will be dragged. ...</div><div class='long'><p>The id of the element that will be dragged.  By default this is same\nas the linked element, but could be changed to another element. Ex:\n<a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></p>\n</div></div></div><div id='property-groups' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-groups' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-groups' class='name expandable'>groups</a><span> : object</span></div><div class='description'><div class='short'>The group defines a logical collection of DragDrop objects that are\nrelated. ...</div><div class='long'><p>The group defines a logical collection of DragDrop objects that are\nrelated.  Instances only get events when interacting with other\nDragDrop object in the same group.  This lets us define multiple\ngroups using a single DragDrop subclass if we want. An object in the format {'group1':true, 'group2':true}</p>\n</div></div></div><div id='property-handleElId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-handleElId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-handleElId' class='name expandable'>handleElId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>The ID of the element that initiates the drag operation. ...</div><div class='long'><p>The ID of the element that initiates the drag operation.  By default\nthis is the linked element, but could be changed to be a child of this\nelement.  This lets us do things like only starting the drag when the\nheader element within the linked html element is clicked.</p>\n</div></div></div><div id='property-hasOuterHandles' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-hasOuterHandles' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-hasOuterHandles' class='name expandable'>hasOuterHandles</a><span> : boolean</span></div><div class='description'><div class='short'>By default, drags can only be initiated if the mousedown occurs in the\nregion the linked element is. ...</div><div class='long'><p>By default, drags can only be initiated if the mousedown occurs in the\nregion the linked element is.  This is done in part to work around a\nbug in some browsers that mis-report the mousedown if the previous\nmouseup happened outside of the window.  This property is set to true\nif outer handles are defined. @default false</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-id' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-id' class='name expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The id of the element associated with this object. ...</div><div class='long'><p>The id of the element associated with this object.  This is what we\nrefer to as the \"linked element\" because the size and position of\nthis element is used to determine when the drag and drop objects have\ninteracted.</p>\n</div></div></div><div id='property-ignoreSelf' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-ignoreSelf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-ignoreSelf' class='name expandable'>ignoreSelf</a><span> : Boolean</span></div><div class='description'><div class='short'>Set to false to enable a DragDrop object to fire drag events while dragging\nover its own Element. ...</div><div class='long'><p>Set to false to enable a DragDrop object to fire drag events while dragging\nover its own Element. Defaults to true - DragDrop objects do not by default\nfire drag events to themselves.</p>\n</div></div></div><div id='property-invalidHandleClasses' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-invalidHandleClasses' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-invalidHandleClasses' class='name not-expandable'>invalidHandleClasses</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'><p>An Array of CSS class names for elements to be considered in valid as drag handles.</p>\n</div><div class='long'><p>An Array of CSS class names for elements to be considered in valid as drag handles.</p>\n</div></div></div><div id='property-invalidHandleIds' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-invalidHandleIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-invalidHandleIds' class='name expandable'>invalidHandleIds</a><span> : Object</span></div><div class='description'><div class='short'>An object who's property names identify the IDs of elements to be considered invalid as drag handles. ...</div><div class='long'><p>An object who's property names identify the IDs of elements to be considered invalid as drag handles.\nA non-null property value identifies the ID as invalid. For example, to prevent\ndragging from being initiated on element ID \"foo\", use:</p>\n\n<pre><code>{\n    foo: true\n}</code></pre>\n\n</div></div></div><div id='property-invalidHandleTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-invalidHandleTypes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-invalidHandleTypes' class='name expandable'>invalidHandleTypes</a><span> : Object</span></div><div class='description'><div class='short'>An object who's property names identify HTML tags to be considered invalid as drag handles. ...</div><div class='long'><p>An object who's property names identify HTML tags to be considered invalid as drag handles.\nA non-null property value identifies the tag as invalid. Defaults to the\nfollowing value which prevents drag operations from being initiated by &lt;a> elements:</p>\n\n<pre><code>{\n    A: \"A\"\n}</code></pre>\n\n</div></div></div><div id='property-isTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-isTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-isTarget' class='name expandable'>isTarget</a><span> : boolean</span></div><div class='description'><div class='short'>By default, all instances can be a drop target. ...</div><div class='long'><p>By default, all instances can be a drop target.  This can be disabled by\nsetting isTarget to false.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-locked' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-locked' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-locked' class='name expandable'>locked</a><span> : boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Individual drag/drop instances can be locked. ...</div><div class='long'><p>Individual drag/drop instances can be locked.  This will prevent\nonmousedown start drag.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-maintainOffset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-maintainOffset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-maintainOffset' class='name expandable'>maintainOffset</a><span> : boolean</span></div><div class='description'><div class='short'>Maintain offsets when we resetconstraints. ...</div><div class='long'><p>Maintain offsets when we resetconstraints.  Set to true when you want\nthe position of the element relative to its parent to stay the same\nwhen the page changes</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-maxX' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-maxX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-maxX' class='name expandable'>maxX</a><span> : int</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>The right constraint ...</div><div class='long'><p>The right constraint</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-maxY' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-maxY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-maxY' class='name expandable'>maxY</a><span> : int</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>The down constraint ...</div><div class='long'><p>The down constraint</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-minX' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-minX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-minX' class='name expandable'>minX</a><span> : int</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>The left constraint ...</div><div class='long'><p>The left constraint</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-minY' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-minY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-minY' class='name expandable'>minY</a><span> : int</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>The up constraint ...</div><div class='long'><p>The up constraint</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-moveOnly' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-moveOnly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-moveOnly' class='name expandable'>moveOnly</a><span> : boolean</span></div><div class='description'><div class='short'>When set to true, other DD objects in cooperating DDGroups do not receive\nnotification events when this DD object is ...</div><div class='long'><p>When set to true, other DD objects in cooperating DDGroups do not receive\nnotification events when this DD object is dragged over them. Defaults to false.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-padding' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-padding' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-padding' class='name expandable'>padding</a><span> : int[]</span></div><div class='description'><div class='short'>The padding configured for this drag and drop object for calculating\nthe drop zone intersection with this object. ...</div><div class='long'><p>The padding configured for this drag and drop object for calculating\nthe drop zone intersection with this object. An array containing the 4 padding values: [top, right, bottom, left]</p>\n</div></div></div><div id='property-primaryButtonOnly' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-primaryButtonOnly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-primaryButtonOnly' class='name expandable'>primaryButtonOnly</a><span> : boolean</span></div><div class='description'><div class='short'>By default the drag and drop instance will only respond to the primary\nbutton click (left button for a right-handed m...</div><div class='long'><p>By default the drag and drop instance will only respond to the primary\nbutton click (left button for a right-handed mouse).  Set to true to\nallow drag and drop to start with any mouse click that is propogated\nby the browser</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-resizeFrame' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='defined-in docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDCore.html#Ext-dd-DDProxy-property-resizeFrame' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-property-resizeFrame' class='name expandable'>resizeFrame</a><span> : boolean</span></div><div class='description'><div class='short'>By default we resize the drag frame to be the same size as the element\nwe want to drag (this is to get the frame effe...</div><div class='long'><p>By default we resize the drag frame to be the same size as the element\nwe want to drag (this is to get the frame effect).  We can turn it off\nif we want a different behavior.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-scroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-property-scroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-property-scroll' class='name expandable'>scroll</a><span> : boolean</span></div><div class='description'><div class='short'>When set to true, the utility automatically tries to scroll the browser\nwindow when a drag and drop element is dragge...</div><div class='long'><p>When set to true, the utility automatically tries to scroll the browser\nwindow when a drag and drop element is dragged near the viewport boundary.\nDefaults to true.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-startPageX' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-startPageX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-startPageX' class='name expandable'>startPageX</a><span> : int</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>The linked element's absolute X position at the time the drag was\nstarted ...</div><div class='long'><p>The linked element's absolute X position at the time the drag was\nstarted</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-startPageY' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-startPageY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-startPageY' class='name expandable'>startPageY</a><span> : int</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>The linked element's absolute X position at the time the drag was\nstarted ...</div><div class='long'><p>The linked element's absolute X position at the time the drag was\nstarted</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-xTicks' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-xTicks' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-xTicks' class='name expandable'>xTicks</a><span> : int[]</span></div><div class='description'><div class='short'>Array of pixel locations the element will snap to if we specified a\nhorizontal graduation/interval. ...</div><div class='long'><p>Array of pixel locations the element will snap to if we specified a\nhorizontal graduation/interval.  This array is generated automatically\nwhen you define a tick interval.</p>\n</div></div></div><div id='property-yTicks' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-property-yTicks' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-property-yTicks' class='name expandable'>yTicks</a><span> : int[]</span></div><div class='description'><div class='short'>Array of pixel locations the element will snap to if we specified a\nvertical graduation/interval. ...</div><div class='long'><p>Array of pixel locations the element will snap to if we specified a\nvertical graduation/interval.  This array is generated automatically\nwhen you define a tick interval.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.dd.DragZone'>Ext.dd.DragZone</span><br/><a href='source/DragZone.html#Ext-dd-DragZone-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.dd.DragZone-method-constructor' class='name expandable'>Ext.dd.DragZone</a>( <span class='pre'>el, config</span> ) : <a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">Ext.dd.DragZone</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The container element</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DragZone\" rel=\"Ext.dd.DragZone\" class=\"docClass\">Ext.dd.DragZone</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.dd.DragSource-method-constructor' rel='Ext.dd.DragSource-method-constructor' class='docClass'>Ext.dd.DragSource.constructor</a></p></div></div></div><div id='method-_resizeProxy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='defined-in docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDCore.html#Ext-dd-DDProxy-method-_resizeProxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-method-_resizeProxy' class='name expandable'>_resizeProxy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>The proxy is automatically resized to the dimensions of the linked\nelement when a drag is initiated, unless resizeFra...</div><div class='long'><p>The proxy is automatically resized to the dimensions of the linked\nelement when a drag is initiated, unless resizeFrame is set to false</p>\n</div></div></div><div id='method-addInvalidHandleClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-addInvalidHandleClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-addInvalidHandleClass' class='name expandable'>addInvalidHandleClass</a>( <span class='pre'>cssClass</span> )</div><div class='description'><div class='short'>Lets you specify a css class of elements that will not initiate a drag ...</div><div class='long'><p>Lets you specify a css class of elements that will not initiate a drag</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cssClass</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>the class of the elements you wish to ignore</p>\n</div></li></ul></div></div></div><div id='method-addInvalidHandleId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-addInvalidHandleId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-addInvalidHandleId' class='name expandable'>addInvalidHandleId</a>( <span class='pre'>id</span> )</div><div class='description'><div class='short'>Lets you to specify an element id for a child of a drag handle\nthat should not initiate a drag ...</div><div class='long'><p>Lets you to specify an element id for a child of a drag handle\nthat should not initiate a drag</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>the element id of the element you wish to ignore</p>\n</div></li></ul></div></div></div><div id='method-addInvalidHandleType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-addInvalidHandleType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-addInvalidHandleType' class='name expandable'>addInvalidHandleType</a>( <span class='pre'>tagName</span> )</div><div class='description'><div class='short'>Allows you to specify a tag name that should not start a drag operation\nwhen clicked. ...</div><div class='long'><p>Allows you to specify a tag name that should not start a drag operation\nwhen clicked.  This is designed to facilitate embedding links within a\ndrag handle that do something other than start the drag.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tagName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>the type of element to exclude</p>\n</div></li></ul></div></div></div><div id='method-addToGroup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-addToGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-addToGroup' class='name expandable'>addToGroup</a>( <span class='pre'>sGroup</span> )</div><div class='description'><div class='short'>Add this instance to a group of related drag/drop objects. ...</div><div class='long'><p>Add this instance to a group of related drag/drop objects.  All\ninstances belong to at least one group, and can belong to as many\ngroups as needed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sGroup</span> : Object<div class='sub-desc'><p>{string} the name of the group</p>\n</div></li></ul></div></div></div><div id='method-afterDragDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-afterDragDrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-afterDragDrop' class='name expandable'>afterDragDrop</a>( <span class='pre'>target, e, id</span> )</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action\nafter a valid drag drop has occurr...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action\nafter a valid drag drop has occurred by providing an implementation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>The drop target</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dropped element</p>\n</div></li></ul></div></div></div><div id='method-afterDragEnter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-afterDragEnter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-afterDragEnter' class='name expandable'>afterDragEnter</a>( <span class='pre'>target, e, id</span> )</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action\nwhen the dragged item enters the d...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action\nwhen the dragged item enters the drop target by providing an implementation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>The drop target</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dragged element</p>\n</div></li></ul></div></div></div><div id='method-afterDragOut' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-afterDragOut' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-afterDragOut' class='name expandable'>afterDragOut</a>( <span class='pre'>target, e, id</span> )</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action\nafter the dragged item is dragged ...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action\nafter the dragged item is dragged out of the target without dropping.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>The drop target</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dragged element</p>\n</div></li></ul></div></div></div><div id='method-afterDragOver' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-afterDragOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-afterDragOver' class='name expandable'>afterDragOver</a>( <span class='pre'>target, e, id</span> )</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action\nwhile the dragged item is over the...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action\nwhile the dragged item is over the drop target by providing an implementation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>The drop target</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dragged element</p>\n</div></li></ul></div></div></div><div id='method-afterInvalidDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-afterInvalidDrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-afterInvalidDrop' class='name expandable'>afterInvalidDrop</a>( <span class='pre'>e, id</span> )</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action\nafter an invalid drop has occurred...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action\nafter an invalid drop has occurred by providing an implementation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dropped element</p>\n</div></li></ul></div></div></div><div id='method-afterRepair' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.dd.DragZone'>Ext.dd.DragZone</span><br/><a href='source/DragZone.html#Ext-dd-DragZone-method-afterRepair' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragZone-method-afterRepair' class='name expandable'>afterRepair</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Called after a repair of an invalid drop. ...</div><div class='long'><p>Called after a repair of an invalid drop. By default, highlights this.dragData.ddel</p>\n</div></div></div><div id='method-afterValidDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-afterValidDrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-afterValidDrop' class='name expandable'>afterValidDrop</a>( <span class='pre'>target, e, id</span> )</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action\nafter a valid drop has occurred by...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action\nafter a valid drop has occurred by providing an implementation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : Object<div class='sub-desc'><p>The target DD</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dropped element</p>\n</div></li></ul></div></div></div><div id='method-alignElWithMouse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-alignElWithMouse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-alignElWithMouse' class='name expandable'>alignElWithMouse</a>( <span class='pre'>el, iPageX, iPageY</span> )</div><div class='description'><div class='short'>Sets the element to the location of the mousedown or click event,\nmaintaining the cursor location relative to the loc...</div><div class='long'><p>Sets the element to the location of the mousedown or click event,\nmaintaining the cursor location relative to the location on the element\nthat was clicked.  Override this if you want to place the element in a\nlocation other than where the cursor is.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : HTMLElement<div class='sub-desc'><p>the element to move</p>\n</div></li><li><span class='pre'>iPageX</span> : int<div class='sub-desc'><p>the X coordinate of the mousedown or drag event</p>\n</div></li><li><span class='pre'>iPageY</span> : int<div class='sub-desc'><p>the Y coordinate of the mousedown or drag event</p>\n</div></li></ul></div></div></div><div id='method-applyConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-applyConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-applyConfig' class='name expandable'>applyConfig</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Sets up config options specific to this class. ...</div><div class='long'><p>Sets up config options specific to this class. Overrides\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>, but all versions of this method through the\ninheritance chain are called</p>\n<p>Overrides: <a href='#!/api/Ext.dd.DragDrop-method-applyConfig' rel='Ext.dd.DragDrop-method-applyConfig' class='docClass'>Ext.dd.DragDrop.applyConfig</a></p></div></div></div><div id='method-autoOffset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-autoOffset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-autoOffset' class='name expandable'>autoOffset</a>( <span class='pre'>iPageX, iPageY</span> )</div><div class='description'><div class='short'>Sets the pointer offset to the distance between the linked element's top\nleft corner and the location the element was...</div><div class='long'><p>Sets the pointer offset to the distance between the linked element's top\nleft corner and the location the element was clicked</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iPageX</span> : int<div class='sub-desc'><p>the X coordinate of the click</p>\n</div></li><li><span class='pre'>iPageY</span> : int<div class='sub-desc'><p>the Y coordinate of the click</p>\n</div></li></ul></div></div></div><div id='method-autoScroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-autoScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-autoScroll' class='name expandable'>autoScroll</a>( <span class='pre'>x, y, h, w</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Auto-scroll the window if the dragged object has been moved beyond the\nvisible window boundary. ...</div><div class='long'><p>Auto-scroll the window if the dragged object has been moved beyond the\nvisible window boundary.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : int<div class='sub-desc'><p>the drag element's x position</p>\n</div></li><li><span class='pre'>y</span> : int<div class='sub-desc'><p>the drag element's y position</p>\n</div></li><li><span class='pre'>h</span> : int<div class='sub-desc'><p>the height of the drag element</p>\n</div></li><li><span class='pre'>w</span> : int<div class='sub-desc'><p>the width of the drag element</p>\n</div></li></ul></div></div></div><div id='method-b4Drag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-b4Drag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-b4Drag' class='name expandable'>b4Drag</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>Event that fires prior to the onDrag event. ...</div><div class='long'><p>Event that fires prior to the onDrag event.  Overrides\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.dd.DragDrop-method-b4Drag' rel='Ext.dd.DragDrop-method-b4Drag' class='docClass'>Ext.dd.DragDrop.b4Drag</a></p></div></div></div><div id='method-b4DragDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-b4DragDrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-b4DragDrop' class='name expandable'>b4DragDrop</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Code that executes immediately before the onDragDrop event ...</div><div class='long'><p>Code that executes immediately before the onDragDrop event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-b4DragOut' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-b4DragOut' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-b4DragOut' class='name expandable'>b4DragOut</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Code that executes immediately before the onDragOut event ...</div><div class='long'><p>Code that executes immediately before the onDragOut event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-b4DragOver' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-b4DragOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-b4DragOver' class='name expandable'>b4DragOver</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Code that executes immediately before the onDragOver event ...</div><div class='long'><p>Code that executes immediately before the onDragOver event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-b4EndDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-b4EndDrag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-b4EndDrag' class='name expandable'>b4EndDrag</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Code that executes immediately before the endDrag event ...</div><div class='long'><p>Code that executes immediately before the endDrag event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-b4MouseDown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-b4MouseDown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-b4MouseDown' class='name expandable'>b4MouseDown</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>Event that fires prior to the onMouseDown event. ...</div><div class='long'><p>Event that fires prior to the onMouseDown event.  Overrides\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.dd.DragDrop-method-b4MouseDown' rel='Ext.dd.DragDrop-method-b4MouseDown' class='docClass'>Ext.dd.DragDrop.b4MouseDown</a></p></div></div></div><div id='method-b4StartDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-b4StartDrag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-b4StartDrag' class='name expandable'>b4StartDrag</a>( <span class='pre'>x, y</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Code that executes immediately before the startDrag event ...</div><div class='long'><p>Code that executes immediately before the startDrag event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>y</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-beforeDragDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-beforeDragDrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-beforeDragDrop' class='name expandable'>beforeDragDrop</a>( <span class='pre'>target, e, id</span> ) : Boolean</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action before the dragged\nitem is dropped...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action before the dragged\nitem is dropped onto the target and optionally cancel the onDragDrop.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>The drop target</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dragged element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>isValid True if the drag drop event is valid, else false to cancel</p>\n</div></li></ul></div></div></div><div id='method-beforeDragEnter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-beforeDragEnter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-beforeDragEnter' class='name expandable'>beforeDragEnter</a>( <span class='pre'>target, e, id</span> ) : Boolean</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action\nbefore the dragged item enters the...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action\nbefore the dragged item enters the drop target and optionally cancel the onDragEnter.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>The drop target</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dragged element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>isValid True if the drag event is valid, else false to cancel</p>\n</div></li></ul></div></div></div><div id='method-beforeDragOut' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-beforeDragOut' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-beforeDragOut' class='name expandable'>beforeDragOut</a>( <span class='pre'>target, e, id</span> ) : Boolean</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action before the dragged\nitem is dragged...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action before the dragged\nitem is dragged out of the target without dropping, and optionally cancel the onDragOut.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>The drop target</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dragged element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>isValid True if the drag event is valid, else false to cancel</p>\n</div></li></ul></div></div></div><div id='method-beforeDragOver' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-beforeDragOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-beforeDragOver' class='name expandable'>beforeDragOver</a>( <span class='pre'>target, e, id</span> ) : Boolean</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action\nwhile the dragged item is over the...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action\nwhile the dragged item is over the drop target and optionally cancel the onDragOver.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>The drop target</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dragged element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>isValid True if the drag event is valid, else false to cancel</p>\n</div></li></ul></div></div></div><div id='method-beforeInvalidDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-beforeInvalidDrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-beforeInvalidDrop' class='name expandable'>beforeInvalidDrop</a>( <span class='pre'>target, e, id</span> ) : Boolean</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action after an invalid\ndrop has occurred. ...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action after an invalid\ndrop has occurred.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>The drop target</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id of the dragged element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>isValid True if the invalid drop should proceed, else false to cancel</p>\n</div></li></ul></div></div></div><div id='method-cachePosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-cachePosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-cachePosition' class='name expandable'>cachePosition</a>( <span class='pre'>iPageX, iPageY</span> )</div><div class='description'><div class='short'>Saves the most recent position so that we can reset the constraints and\ntick marks on-demand. ...</div><div class='long'><p>Saves the most recent position so that we can reset the constraints and\ntick marks on-demand.  We need to know this so that we can calculate the\nnumber of pixels the element is offset from its original position.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iPageX</span> : Object<div class='sub-desc'><p>the current x position (optional, this just makes it so we\ndon't have to look it up again)</p>\n</div></li><li><span class='pre'>iPageY</span> : Object<div class='sub-desc'><p>the current y position (optional, this just makes it so we\ndon't have to look it up again)</p>\n</div></li></ul></div></div></div><div id='method-clearConstraints' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-clearConstraints' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-clearConstraints' class='name expandable'>clearConstraints</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Clears any constraints applied to this instance. ...</div><div class='long'><p>Clears any constraints applied to this instance.  Also clears ticks\nsince they can't exist independent of a constraint at this time.</p>\n</div></div></div><div id='method-clearTicks' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-clearTicks' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-clearTicks' class='name expandable'>clearTicks</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Clears any tick interval defined for this instance ...</div><div class='long'><p>Clears any tick interval defined for this instance</p>\n</div></div></div><div id='method-constrainTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-constrainTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-constrainTo' class='name expandable'>constrainTo</a>( <span class='pre'>constrainTo, [pad], [inContent]</span> )</div><div class='description'><div class='short'>Initializes the drag drop object's constraints to restrict movement to a certain element. ...</div><div class='long'><p>Initializes the drag drop object's constraints to restrict movement to a certain element.</p>\n\n<p>Usage:</p>\n\n<pre><code> var dd = new <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a>(\"dragDiv1\", \"proxytest\",\n                { dragElId: \"existingProxyDiv\" });\n dd.startDrag = function(){\n     this.constrainTo(\"parent-id\");\n };\n </code></pre>\n\n\n<p>Or you can initalize it using the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> object:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(\"dragDiv1\").initDDProxy(\"proxytest\", {dragElId: \"existingProxyDiv\"}, {\n     startDrag : function(){\n         this.constrainTo(\"parent-id\");\n     }\n });\n </code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>constrainTo</span> : Mixed<div class='sub-desc'><p>The element to constrain to.</p>\n</div></li><li><span class='pre'>pad</span> : Object/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Pad provides a way to specify \"padding\" of the constraints,\nand can be either a number for symmetrical padding (4 would be equal to {left:4, right:4, top:4, bottom:4}) or\nan object containing the sides to pad. For example: {right:10, bottom:10}</p>\n</div></li><li><span class='pre'>inContent</span> : Boolean (optional)<div class='sub-desc'><p>Constrain the draggable in the content box of the element (inside padding and borders)</p>\n</div></li></ul></div></div></div><div id='method-createFrame' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='defined-in docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDCore.html#Ext-dd-DDProxy-method-createFrame' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-method-createFrame' class='name expandable'>createFrame</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Creates the proxy element if it does not yet exist ...</div><div class='long'><p>Creates the proxy element if it does not yet exist</p>\n</div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.dd.DragZone'>Ext.dd.DragZone</span><br/><a href='source/DragZone.html#Ext-dd-DragZone-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragZone-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-endDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-endDrag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-endDrag' class='name expandable'>endDrag</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>Fired when we are done dragging the object ...</div><div class='long'><p>Fired when we are done dragging the object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mouseup event</p>\n</div></li></ul></div></div></div><div id='method-getDragData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.dd.DragZone'>Ext.dd.DragZone</span><br/><a href='source/DragZone.html#Ext-dd-DragZone-method-getDragData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragZone-method-getDragData' class='name expandable'>getDragData</a>( <span class='pre'>e</span> ) : Object</div><div class='description'><div class='short'>Called when a mousedown occurs in this container. ...</div><div class='long'><p>Called when a mousedown occurs in this container. Looks in <a href=\"#!/api/Ext.dd.Registry\" rel=\"Ext.dd.Registry\" class=\"docClass\">Ext.dd.Registry</a>\nfor a valid target to drag based on the mouse down. Override this method\nto provide your own lookup logic (e.g. finding a child by class name). Make sure your returned\nobject has a \"ddel\" attribute (with an HTML Element) for other functions to work.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : EventObject<div class='sub-desc'><p>The mouse down event</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The dragData</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.dd.DragSource-method-getDragData' rel='Ext.dd.DragSource-method-getDragData' class='docClass'>Ext.dd.DragSource.getDragData</a></p></div></div></div><div id='method-getDragEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-getDragEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-getDragEl' class='name expandable'>getDragEl</a>( <span class='pre'></span> ) : HTMLElement</div><div class='description'><div class='short'>Returns a reference to the actual element to drag. ...</div><div class='long'><p>Returns a reference to the actual element to drag.  By default this is\nthe same as the html element, but it can be assigned to another\nelement. An example of this can be found in <a href=\"#!/api/Ext.dd.DDProxy\" rel=\"Ext.dd.DDProxy\" class=\"docClass\">Ext.dd.DDProxy</a></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>the html element</p>\n</div></li></ul></div></div></div><div id='method-getEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-getEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : HTMLElement</div><div class='description'><div class='short'>Returns a reference to the linked element ...</div><div class='long'><p>Returns a reference to the linked element</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>the html element</p>\n</div></li></ul></div></div></div><div id='method-getProxy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-getProxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-getProxy' class='name expandable'>getProxy</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.dd.StatusProxy\" rel=\"Ext.dd.StatusProxy\" class=\"docClass\">Ext.dd.StatusProxy</a></div><div class='description'><div class='short'>Returns the drag source's underlying Ext.dd.StatusProxy ...</div><div class='long'><p>Returns the drag source's underlying <a href=\"#!/api/Ext.dd.StatusProxy\" rel=\"Ext.dd.StatusProxy\" class=\"docClass\">Ext.dd.StatusProxy</a></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.StatusProxy\" rel=\"Ext.dd.StatusProxy\" class=\"docClass\">Ext.dd.StatusProxy</a></span><div class='sub-desc'><p>proxy The StatusProxy</p>\n</div></li></ul></div></div></div><div id='method-getRepairXY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.dd.DragZone'>Ext.dd.DragZone</span><br/><a href='source/DragZone.html#Ext-dd-DragZone-method-getRepairXY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragZone-method-getRepairXY' class='name expandable'>getRepairXY</a>( <span class='pre'>e</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Called before a repair of an invalid drop to get the XY to animate to. ...</div><div class='long'><p>Called before a repair of an invalid drop to get the XY to animate to. By default returns\nthe XY of this.dragData.ddel</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : EventObject<div class='sub-desc'><p>The mouse up event</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The xy location (e.g. [100, 200])</p>\n</div></li></ul></div></div></div><div id='method-getTargetCoord' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-getTargetCoord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-getTargetCoord' class='name expandable'>getTargetCoord</a>( <span class='pre'>iPageX, iPageY</span> ) : Object<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Finds the location the element should be placed if we want to move\nit to where the mouse location less the click offs...</div><div class='long'><p>Finds the location the element should be placed if we want to move\nit to where the mouse location less the click offset would place us.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iPageX</span> : int<div class='sub-desc'><p>the X coordinate of the click</p>\n</div></li><li><span class='pre'>iPageY</span> : int<div class='sub-desc'><p>the Y coordinate of the click</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>an object that contains the coordinates (Object.x and Object.y)</p>\n</div></li></ul></div></div></div><div id='method-getTick' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-getTick' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-getTick' class='name expandable'>getTick</a>( <span class='pre'>val, tickArray</span> ) : int<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Normally the drag element is moved pixel by pixel, but we can specify\nthat it move a number of pixels at a time. ...</div><div class='long'><p>Normally the drag element is moved pixel by pixel, but we can specify\nthat it move a number of pixels at a time.  This method resolves the\nlocation when we have it set up like this.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>val</span> : int<div class='sub-desc'><p>where we want to place the object</p>\n</div></li><li><span class='pre'>tickArray</span> : int[]<div class='sub-desc'><p>sorted array of valid points</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>int</span><div class='sub-desc'><p>the closest tick</p>\n</div></li></ul></div></div></div><div id='method-handleMouseDown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-handleMouseDown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-handleMouseDown' class='name expandable'>handleMouseDown</a>( <span class='pre'>e, oDD</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Fired when this object is clicked ...</div><div class='long'><p>Fired when this object is clicked</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'>\n</div></li><li><span class='pre'>oDD</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>the clicked dd object (this dd obj)</p>\n</div></li></ul></div></div></div><div id='method-handleOnAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-handleOnAvailable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-handleOnAvailable' class='name expandable'>handleOnAvailable</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Executed when the linked element is available ...</div><div class='long'><p>Executed when the linked element is available</p>\n</div></div></div><div id='method-hideProxy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-hideProxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-hideProxy' class='name expandable'>hideProxy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Hides the drag source's Ext.dd.StatusProxy ...</div><div class='long'><p>Hides the drag source's <a href=\"#!/api/Ext.dd.StatusProxy\" rel=\"Ext.dd.StatusProxy\" class=\"docClass\">Ext.dd.StatusProxy</a></p>\n</div></div></div><div id='method-init' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-init' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-init' class='name expandable'>init</a>( <span class='pre'>id, sGroup, config</span> )</div><div class='description'><div class='short'>Sets up the DragDrop object. ...</div><div class='long'><p>Sets up the DragDrop object.  Must be called in the constructor of any\n<a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a> subclass</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : Object<div class='sub-desc'><p>the id of the linked element</p>\n</div></li><li><span class='pre'>sGroup</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the group of related items</p>\n</div></li><li><span class='pre'>config</span> : object<div class='sub-desc'><p>configuration attributes</p>\n</div></li></ul></div></div></div><div id='method-initFrame' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='defined-in docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDCore.html#Ext-dd-DDProxy-method-initFrame' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-method-initFrame' class='name expandable'>initFrame</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Initialization for the drag frame element. ...</div><div class='long'><p>Initialization for the drag frame element.  Must be called in the\nconstructor of all subclasses</p>\n</div></div></div><div id='method-initTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-initTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-initTarget' class='name expandable'>initTarget</a>( <span class='pre'>id, sGroup, config</span> )</div><div class='description'><div class='short'>Initializes Targeting functionality only... ...</div><div class='long'><p>Initializes Targeting functionality only... the object does not\nget a mousedown handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : Object<div class='sub-desc'><p>the id of the linked element</p>\n</div></li><li><span class='pre'>sGroup</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the group of related items</p>\n</div></li><li><span class='pre'>config</span> : object<div class='sub-desc'><p>configuration attributes</p>\n</div></li></ul></div></div></div><div id='method-isLocked' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-isLocked' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-isLocked' class='name expandable'>isLocked</a>( <span class='pre'></span> ) : boolean</div><div class='description'><div class='short'>Returns true if this instance is locked, or the drag drop mgr is locked\n(meaning that all drag/drop is disabled on th...</div><div class='long'><p>Returns true if this instance is locked, or the drag drop mgr is locked\n(meaning that all drag/drop is disabled on the page.)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>boolean</span><div class='sub-desc'><p>true if this obj or all drag/drop is locked, else\nfalse</p>\n</div></li></ul></div></div></div><div id='method-isValidHandleChild' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-isValidHandleChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-isValidHandleChild' class='name expandable'>isValidHandleChild</a>( <span class='pre'>node</span> ) : boolean</div><div class='description'><div class='short'>Checks the tag exclusion list to see if this click should be ignored ...</div><div class='long'><p>Checks the tag exclusion list to see if this click should be ignored</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'><p>the HTMLElement to evaluate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>boolean</span><div class='sub-desc'><p>true if this is a valid tag type, false if not</p>\n</div></li></ul></div></div></div><div id='method-lock' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-lock' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-lock' class='name expandable'>lock</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Lock this instance ...</div><div class='long'><p>Lock this instance</p>\n</div></div></div><div id='method-onAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-onAvailable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onAvailable' class='name expandable'>onAvailable</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Override the onAvailable method to do what is needed after the initial\nposition was determined. ...</div><div class='long'><p>Override the onAvailable method to do what is needed after the initial\nposition was determined.</p>\n</div></div></div><div id='method-onBeforeDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-onBeforeDrag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-onBeforeDrag' class='name expandable'>onBeforeDrag</a>( <span class='pre'>data, e</span> ) : Boolean</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action before the initial\ndrag event begi...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action before the initial\ndrag event begins and optionally cancel it.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>An object containing arbitrary data to be shared with drop targets</p>\n</div></li><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>The event object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>isValid True if the drag event is valid, else false to cancel</p>\n</div></li></ul></div></div></div><div id='method-onDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-onDrag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDrag' class='name expandable'>onDrag</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>Abstract method called during the onMouseMove event while dragging an\nobject. ...</div><div class='long'><p>Abstract method called during the onMouseMove event while dragging an\nobject.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousemove event</p>\n</div></li></ul></div></div></div><div id='method-onDragDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-onDragDrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDragDrop' class='name expandable'>onDragDrop</a>( <span class='pre'>e, id</span> )</div><div class='description'><div class='short'>Abstract method called when this item is dropped on another DragDrop\nobj ...</div><div class='long'><p>Abstract method called when this item is dropped on another DragDrop\nobj</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mouseup event</p>\n</div></li><li><span class='pre'>id</span> : String|DragDrop[]<div class='sub-desc'><p>In POINT mode, the element\nid this was dropped on.  In INTERSECT mode, an array of dd items this\nwas dropped on.</p>\n</div></li></ul></div></div></div><div id='method-onDragEnter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-onDragEnter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDragEnter' class='name expandable'>onDragEnter</a>( <span class='pre'>e, id</span> )</div><div class='description'><div class='short'>Abstract method called when this element fist begins hovering over\nanother DragDrop obj ...</div><div class='long'><p>Abstract method called when this element fist begins hovering over\nanother DragDrop obj</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousemove event</p>\n</div></li><li><span class='pre'>id</span> : String|DragDrop[]<div class='sub-desc'><p>In POINT mode, the element\nid this is hovering over.  In INTERSECT mode, an array of one or more\ndragdrop items being hovered over.</p>\n</div></li></ul></div></div></div><div id='method-onDragOut' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-onDragOut' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDragOut' class='name expandable'>onDragOut</a>( <span class='pre'>e, id</span> )</div><div class='description'><div class='short'>Abstract method called when we are no longer hovering over an element ...</div><div class='long'><p>Abstract method called when we are no longer hovering over an element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousemove event</p>\n</div></li><li><span class='pre'>id</span> : String|DragDrop[]<div class='sub-desc'><p>In POINT mode, the element\nid this was hovering over.  In INTERSECT mode, an array of dd items\nthat the mouse is no longer over.</p>\n</div></li></ul></div></div></div><div id='method-onDragOver' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-onDragOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onDragOver' class='name expandable'>onDragOver</a>( <span class='pre'>e, id</span> )</div><div class='description'><div class='short'>Abstract method called when this element is hovering over another\nDragDrop obj ...</div><div class='long'><p>Abstract method called when this element is hovering over another\nDragDrop obj</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousemove event</p>\n</div></li><li><span class='pre'>id</span> : String|DragDrop[]<div class='sub-desc'><p>In POINT mode, the element\nid this is hovering over.  In INTERSECT mode, an array of dd items\nbeing hovered over.</p>\n</div></li></ul></div></div></div><div id='method-onInitDrag' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.dd.DragZone'>Ext.dd.DragZone</span><br/><a href='source/DragZone.html#Ext-dd-DragZone-method-onInitDrag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragZone-method-onInitDrag' class='name expandable'>onInitDrag</a>( <span class='pre'>x, y</span> ) : Boolean</div><div class='description'><div class='short'>Called once drag threshold has been reached to initialize the proxy element. ...</div><div class='long'><p>Called once drag threshold has been reached to initialize the proxy element. By default, it clones the\nthis.dragData.ddel</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The x position of the click on the dragged object</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The y position of the click on the dragged object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true to continue the drag, false to cancel</p>\n</div></li></ul></div></div></div><div id='method-onInvalidDrop' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-onInvalidDrop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onInvalidDrop' class='name expandable'>onInvalidDrop</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>Abstract method called when this item is dropped on an area with no\ndrop target ...</div><div class='long'><p>Abstract method called when this item is dropped on an area with no\ndrop target</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mouseup event</p>\n</div></li></ul></div></div></div><div id='method-onMouseDown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-onMouseDown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onMouseDown' class='name expandable'>onMouseDown</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>Event handler that fires when a drag/drop obj gets a mousedown ...</div><div class='long'><p>Event handler that fires when a drag/drop obj gets a mousedown</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mousedown event</p>\n</div></li></ul></div></div></div><div id='method-onMouseUp' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-onMouseUp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-onMouseUp' class='name expandable'>onMouseUp</a>( <span class='pre'>e</span> )</div><div class='description'><div class='short'>Event handler that fires when a drag/drop obj gets a mouseup ...</div><div class='long'><p>Event handler that fires when a drag/drop obj gets a mouseup</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the mouseup event</p>\n</div></li></ul></div></div></div><div id='method-onStartDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragSource' rel='Ext.dd.DragSource' class='defined-in docClass'>Ext.dd.DragSource</a><br/><a href='source/DragSource.html#Ext-dd-DragSource-method-onStartDrag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragSource-method-onStartDrag' class='name expandable'>onStartDrag</a>( <span class='pre'>x, y</span> )</div><div class='description'><div class='short'>An empty function by default, but provided so that you can perform a custom action once the initial\ndrag event has be...</div><div class='long'><p>An empty function by default, but provided so that you can perform a custom action once the initial\ndrag event has begun.  The drag cannot be canceled from this function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The x position of the click on the dragged object</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The y position of the click on the dragged object</p>\n</div></li></ul></div></div></div><div id='method-removeFromGroup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-removeFromGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-removeFromGroup' class='name expandable'>removeFromGroup</a>( <span class='pre'>sGroup</span> )</div><div class='description'><div class='short'>Remove's this instance from the supplied interaction group ...</div><div class='long'><p>Remove's this instance from the supplied interaction group</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sGroup</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>The group to drop</p>\n</div></li></ul></div></div></div><div id='method-removeInvalidHandleClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-removeInvalidHandleClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-removeInvalidHandleClass' class='name expandable'>removeInvalidHandleClass</a>( <span class='pre'>cssClass</span> )</div><div class='description'><div class='short'>Unsets an invalid css class ...</div><div class='long'><p>Unsets an invalid css class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cssClass</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>the class of the element(s) you wish to\nre-enable</p>\n</div></li></ul></div></div></div><div id='method-removeInvalidHandleId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-removeInvalidHandleId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-removeInvalidHandleId' class='name expandable'>removeInvalidHandleId</a>( <span class='pre'>id</span> )</div><div class='description'><div class='short'>Unsets an invalid handle id ...</div><div class='long'><p>Unsets an invalid handle id</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>the id of the element to re-enable</p>\n</div></li></ul></div></div></div><div id='method-removeInvalidHandleType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-removeInvalidHandleType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-removeInvalidHandleType' class='name expandable'>removeInvalidHandleType</a>( <span class='pre'>tagName</span> )</div><div class='description'><div class='short'>Unsets an excluded tag name set by addInvalidHandleType ...</div><div class='long'><p>Unsets an excluded tag name set by addInvalidHandleType</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tagName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>the type of element to unexclude</p>\n</div></li></ul></div></div></div><div id='method-resetConstraints' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-resetConstraints' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-resetConstraints' class='name expandable'>resetConstraints</a>( <span class='pre'>maintainOffset</span> )</div><div class='description'><div class='short'>resetConstraints must be called if you manually reposition a dd element. ...</div><div class='long'><p>resetConstraints must be called if you manually reposition a dd element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maintainOffset</span> : boolean<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setDelta' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-setDelta' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-setDelta' class='name expandable'>setDelta</a>( <span class='pre'>iDeltaX, iDeltaY</span> )</div><div class='description'><div class='short'>Sets the pointer offset. ...</div><div class='long'><p>Sets the pointer offset.  You can call this directly to force the\noffset to be in a particular location (e.g., pass in 0,0 to set it\nto the center of the object)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iDeltaX</span> : int<div class='sub-desc'><p>the distance from the left</p>\n</div></li><li><span class='pre'>iDeltaY</span> : int<div class='sub-desc'><p>the distance from the top</p>\n</div></li></ul></div></div></div><div id='method-setDragElId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setDragElId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setDragElId' class='name expandable'>setDragElId</a>( <span class='pre'>id</span> )</div><div class='description'><div class='short'>Allows you to specify that an element other than the linked element\nwill be moved with the cursor during a drag ...</div><div class='long'><p>Allows you to specify that an element other than the linked element\nwill be moved with the cursor during a drag</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : Object<div class='sub-desc'><p>{string} the id of the element that will be used to initiate the drag</p>\n</div></li></ul></div></div></div><div id='method-setDragElPos' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DD' rel='Ext.dd.DD' class='defined-in docClass'>Ext.dd.DD</a><br/><a href='source/DDCore.html#Ext-dd-DD-method-setDragElPos' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DD-method-setDragElPos' class='name expandable'>setDragElPos</a>( <span class='pre'>iPageX, iPageY</span> )</div><div class='description'><div class='short'>Sets the drag element to the location of the mousedown or click event,\nmaintaining the cursor location relative to th...</div><div class='long'><p>Sets the drag element to the location of the mousedown or click event,\nmaintaining the cursor location relative to the location on the element\nthat was clicked.  Override this if you want to place the element in a\nlocation other than where the cursor is.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iPageX</span> : int<div class='sub-desc'><p>the X coordinate of the mousedown or drag event</p>\n</div></li><li><span class='pre'>iPageY</span> : int<div class='sub-desc'><p>the Y coordinate of the mousedown or drag event</p>\n</div></li></ul></div></div></div><div id='method-setHandleElId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setHandleElId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setHandleElId' class='name expandable'>setHandleElId</a>( <span class='pre'>id</span> )</div><div class='description'><div class='short'>Allows you to specify a child of the linked element that should be\nused to initiate the drag operation. ...</div><div class='long'><p>Allows you to specify a child of the linked element that should be\nused to initiate the drag operation.  An example of this would be if\nyou have a content div with text and links.  Clicking anywhere in the\ncontent area would normally start the drag operation.  Use this method\nto specify that an element inside of the content div is the element\nthat starts the drag operation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : Object<div class='sub-desc'><p>{string} the id of the element that will be used to\ninitiate the drag.</p>\n</div></li></ul></div></div></div><div id='method-setInitPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setInitPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setInitPosition' class='name expandable'>setInitPosition</a>( <span class='pre'>diffX, diffY</span> )</div><div class='description'><div class='short'>Stores the initial placement of the linked element. ...</div><div class='long'><p>Stores the initial placement of the linked element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>diffX</span> : int<div class='sub-desc'><p>the X offset, default 0</p>\n</div></li><li><span class='pre'>diffY</span> : int<div class='sub-desc'><p>the Y offset, default 0</p>\n</div></li></ul></div></div></div><div id='method-setOuterHandleElId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setOuterHandleElId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setOuterHandleElId' class='name expandable'>setOuterHandleElId</a>( <span class='pre'>id</span> )</div><div class='description'><div class='short'>Allows you to set an element outside of the linked element as a drag\nhandle ...</div><div class='long'><p>Allows you to set an element outside of the linked element as a drag\nhandle</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : Object<div class='sub-desc'><p>the id of the element that will be used to initiate the drag</p>\n</div></li></ul></div></div></div><div id='method-setPadding' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setPadding' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setPadding' class='name expandable'>setPadding</a>( <span class='pre'>iTop, iRight, iBot, iLeft</span> )</div><div class='description'><div class='short'>Configures the padding for the target zone in px. ...</div><div class='long'><p>Configures the padding for the target zone in px.  Effectively expands\n(or reduces) the virtual object size for targeting calculations.\nSupports css-style shorthand; if only one parameter is passed, all sides\nwill have that padding, and if only two are passed, the top and bottom\nwill have the first param, the left and right the second.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iTop</span> : int<div class='sub-desc'><p>Top pad</p>\n</div></li><li><span class='pre'>iRight</span> : int<div class='sub-desc'><p>Right pad</p>\n</div></li><li><span class='pre'>iBot</span> : int<div class='sub-desc'><p>Bot pad</p>\n</div></li><li><span class='pre'>iLeft</span> : int<div class='sub-desc'><p>Left pad</p>\n</div></li></ul></div></div></div><div id='method-setStartPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setStartPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setStartPosition' class='name expandable'>setStartPosition</a>( <span class='pre'>pos</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Sets the start position of the element. ...</div><div class='long'><p>Sets the start position of the element.  This is set when the obj\nis initialized, the reset when a drag is started.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pos</span> : Object<div class='sub-desc'><p>current position (from previous lookup)</p>\n</div></li></ul></div></div></div><div id='method-setXConstraint' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setXConstraint' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setXConstraint' class='name expandable'>setXConstraint</a>( <span class='pre'>iLeft, iRight, iTickSize</span> )</div><div class='description'><div class='short'>By default, the element can be dragged any place on the screen. ...</div><div class='long'><p>By default, the element can be dragged any place on the screen.  Use\nthis method to limit the horizontal travel of the element.  Pass in\n0,0 for the parameters if you want to lock the drag to the y axis.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iLeft</span> : int<div class='sub-desc'><p>the number of pixels the element can move to the left</p>\n</div></li><li><span class='pre'>iRight</span> : int<div class='sub-desc'><p>the number of pixels the element can move to the\nright</p>\n</div></li><li><span class='pre'>iTickSize</span> : int<div class='sub-desc'><p>optional parameter for specifying that the\nelement\nshould move iTickSize pixels at a time.</p>\n</div></li></ul></div></div></div><div id='method-setXTicks' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setXTicks' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setXTicks' class='name expandable'>setXTicks</a>( <span class='pre'>iStartX, iTickSize</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Create the array of horizontal tick marks if an interval was specified\nin setXConstraint(). ...</div><div class='long'><p>Create the array of horizontal tick marks if an interval was specified\nin setXConstraint().</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iStartX</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>iTickSize</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setYConstraint' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setYConstraint' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setYConstraint' class='name expandable'>setYConstraint</a>( <span class='pre'>iUp, iDown, iTickSize</span> )</div><div class='description'><div class='short'>By default, the element can be dragged any place on the screen. ...</div><div class='long'><p>By default, the element can be dragged any place on the screen.  Set\nthis to limit the vertical travel of the element.  Pass in 0,0 for the\nparameters if you want to lock the drag to the x axis.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iUp</span> : int<div class='sub-desc'><p>the number of pixels the element can move up</p>\n</div></li><li><span class='pre'>iDown</span> : int<div class='sub-desc'><p>the number of pixels the element can move down</p>\n</div></li><li><span class='pre'>iTickSize</span> : int<div class='sub-desc'><p>optional parameter for specifying that the\nelement should move iTickSize pixels at a time.</p>\n</div></li></ul></div></div></div><div id='method-setYTicks' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-setYTicks' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-setYTicks' class='name expandable'>setYTicks</a>( <span class='pre'>iStartY, iTickSize</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Create the array of vertical tick marks if an interval was specified in\nsetYConstraint(). ...</div><div class='long'><p>Create the array of vertical tick marks if an interval was specified in\nsetYConstraint().</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iStartY</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>iTickSize</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-showFrame' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DDProxy' rel='Ext.dd.DDProxy' class='defined-in docClass'>Ext.dd.DDProxy</a><br/><a href='source/DDCore.html#Ext-dd-DDProxy-method-showFrame' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DDProxy-method-showFrame' class='name expandable'>showFrame</a>( <span class='pre'>iPageX, iPageY</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Resizes the drag frame to the dimensions of the clicked object, positions\nit over the object, and finally displays it ...</div><div class='long'><p>Resizes the drag frame to the dimensions of the clicked object, positions\nit over the object, and finally displays it</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iPageX</span> : int<div class='sub-desc'><p>X click position</p>\n</div></li><li><span class='pre'>iPageY</span> : int<div class='sub-desc'><p>Y click position</p>\n</div></li></ul></div></div></div><div id='method-startDrag' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-startDrag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-startDrag' class='name expandable'>startDrag</a>( <span class='pre'>X, Y</span> )</div><div class='description'><div class='short'>Abstract method called after a drag/drop object is clicked\nand the drag or mousedown time thresholds have beeen met. ...</div><div class='long'><p>Abstract method called after a drag/drop object is clicked\nand the drag or mousedown time thresholds have beeen met.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>X</span> : int<div class='sub-desc'><p>click location</p>\n</div></li><li><span class='pre'>Y</span> : int<div class='sub-desc'><p>click location</p>\n</div></li></ul></div></div></div><div id='method-toString' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-toString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-toString' class='name expandable'>toString</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a></div><div class='description'><div class='short'>toString method ...</div><div class='long'><p>toString method</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a></span><div class='sub-desc'><p>string representation of the dd obj</p>\n</div></li></ul></div></div></div><div id='method-unlock' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-unlock' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-unlock' class='name expandable'>unlock</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Unlock this instace ...</div><div class='long'><p>Unlock this instace</p>\n</div></div></div><div id='method-unreg' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDrop' rel='Ext.dd.DragDrop' class='defined-in docClass'>Ext.dd.DragDrop</a><br/><a href='source/DDCore.html#Ext-dd-DragDrop-method-unreg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.dd.DragDrop-method-unreg' class='name expandable'>unreg</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Remove all drag and drop hooks for this element ...</div><div class='long'><p>Remove all drag and drop hooks for this element</p>\n</div></div></div></div></div></div></div>","superclasses":["Ext.dd.DragDrop","Ext.dd.DD","Ext.dd.DDProxy","Ext.dd.DragSource"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"DragZone.html#Ext-dd-DragZone","filename":"DragZone.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"__ygDragDrop","id":"property-__ygDragDrop"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"_domRef","id":"property-_domRef"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"available","id":"property-available"},{"tagname":"property","owner":"Ext.dd.DDProxy","meta":{},"name":"centerFrame","id":"property-centerFrame"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"config","id":"property-config"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"constrainX","id":"property-constrainX"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"constrainY","id":"property-constrainY"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"defaultPadding","id":"property-defaultPadding"},{"tagname":"property","owner":"Ext.dd.DragZone","meta":{},"name":"dragData","id":"property-dragData"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"dragElId","id":"property-dragElId"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"groups","id":"property-groups"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"handleElId","id":"property-handleElId"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"hasOuterHandles","id":"property-hasOuterHandles"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"id","id":"property-id"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"ignoreSelf","id":"property-ignoreSelf"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"invalidHandleClasses","id":"property-invalidHandleClasses"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"invalidHandleIds","id":"property-invalidHandleIds"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"invalidHandleTypes","id":"property-invalidHandleTypes"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"isTarget","id":"property-isTarget"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"locked","id":"property-locked"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"maintainOffset","id":"property-maintainOffset"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"maxX","id":"property-maxX"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"maxY","id":"property-maxY"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"minX","id":"property-minX"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"minY","id":"property-minY"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"moveOnly","id":"property-moveOnly"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"padding","id":"property-padding"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"primaryButtonOnly","id":"property-primaryButtonOnly"},{"tagname":"property","owner":"Ext.dd.DDProxy","meta":{},"name":"resizeFrame","id":"property-resizeFrame"},{"tagname":"property","owner":"Ext.dd.DD","meta":{},"name":"scroll","id":"property-scroll"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"startPageX","id":"property-startPageX"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"startPageY","id":"property-startPageY"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"xTicks","id":"property-xTicks"},{"tagname":"property","owner":"Ext.dd.DragDrop","meta":{},"name":"yTicks","id":"property-yTicks"}],"cfg":[{"tagname":"cfg","owner":"Ext.dd.DragZone","meta":{},"name":"containerScroll","id":"cfg-containerScroll"},{"tagname":"cfg","owner":"Ext.dd.DragSource","meta":{},"name":"ddGroup","id":"cfg-ddGroup"},{"tagname":"cfg","owner":"Ext.dd.DragSource","meta":{},"name":"dropAllowed","id":"cfg-dropAllowed"},{"tagname":"cfg","owner":"Ext.dd.DragSource","meta":{},"name":"dropNotAllowed","id":"cfg-dropNotAllowed"},{"tagname":"cfg","owner":"Ext.dd.DragZone","meta":{},"name":"hlColor","id":"cfg-hlColor"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.dd.DragZone","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.dd.DDProxy","meta":{"private":true},"name":"_resizeProxy","id":"method-_resizeProxy"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"addInvalidHandleClass","id":"method-addInvalidHandleClass"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"addInvalidHandleId","id":"method-addInvalidHandleId"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"addInvalidHandleType","id":"method-addInvalidHandleType"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"addToGroup","id":"method-addToGroup"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"afterDragDrop","id":"method-afterDragDrop"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"afterDragEnter","id":"method-afterDragEnter"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"afterDragOut","id":"method-afterDragOut"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"afterDragOver","id":"method-afterDragOver"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"afterInvalidDrop","id":"method-afterInvalidDrop"},{"tagname":"method","owner":"Ext.dd.DragZone","meta":{},"name":"afterRepair","id":"method-afterRepair"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"afterValidDrop","id":"method-afterValidDrop"},{"tagname":"method","owner":"Ext.dd.DD","meta":{},"name":"alignElWithMouse","id":"method-alignElWithMouse"},{"tagname":"method","owner":"Ext.dd.DD","meta":{},"name":"applyConfig","id":"method-applyConfig"},{"tagname":"method","owner":"Ext.dd.DD","meta":{},"name":"autoOffset","id":"method-autoOffset"},{"tagname":"method","owner":"Ext.dd.DD","meta":{"private":true},"name":"autoScroll","id":"method-autoScroll"},{"tagname":"method","owner":"Ext.dd.DD","meta":{},"name":"b4Drag","id":"method-b4Drag"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"b4DragDrop","id":"method-b4DragDrop"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"b4DragOut","id":"method-b4DragOut"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"b4DragOver","id":"method-b4DragOver"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"b4EndDrag","id":"method-b4EndDrag"},{"tagname":"method","owner":"Ext.dd.DD","meta":{},"name":"b4MouseDown","id":"method-b4MouseDown"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"b4StartDrag","id":"method-b4StartDrag"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"beforeDragDrop","id":"method-beforeDragDrop"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"beforeDragEnter","id":"method-beforeDragEnter"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"beforeDragOut","id":"method-beforeDragOut"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"beforeDragOver","id":"method-beforeDragOver"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"beforeInvalidDrop","id":"method-beforeInvalidDrop"},{"tagname":"method","owner":"Ext.dd.DD","meta":{},"name":"cachePosition","id":"method-cachePosition"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"clearConstraints","id":"method-clearConstraints"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"clearTicks","id":"method-clearTicks"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"constrainTo","id":"method-constrainTo"},{"tagname":"method","owner":"Ext.dd.DDProxy","meta":{},"name":"createFrame","id":"method-createFrame"},{"tagname":"method","owner":"Ext.dd.DragZone","meta":{"private":true},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"endDrag","id":"method-endDrag"},{"tagname":"method","owner":"Ext.dd.DragZone","meta":{},"name":"getDragData","id":"method-getDragData"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"getDragEl","id":"method-getDragEl"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"getEl","id":"method-getEl"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"getProxy","id":"method-getProxy"},{"tagname":"method","owner":"Ext.dd.DragZone","meta":{},"name":"getRepairXY","id":"method-getRepairXY"},{"tagname":"method","owner":"Ext.dd.DD","meta":{"private":true},"name":"getTargetCoord","id":"method-getTargetCoord"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"getTick","id":"method-getTick"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"handleMouseDown","id":"method-handleMouseDown"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"handleOnAvailable","id":"method-handleOnAvailable"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"hideProxy","id":"method-hideProxy"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"init","id":"method-init"},{"tagname":"method","owner":"Ext.dd.DDProxy","meta":{},"name":"initFrame","id":"method-initFrame"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"initTarget","id":"method-initTarget"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"isLocked","id":"method-isLocked"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"isValidHandleChild","id":"method-isValidHandleChild"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"lock","id":"method-lock"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"onAvailable","id":"method-onAvailable"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"onBeforeDrag","id":"method-onBeforeDrag"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"onDrag","id":"method-onDrag"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"onDragDrop","id":"method-onDragDrop"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"onDragEnter","id":"method-onDragEnter"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"onDragOut","id":"method-onDragOut"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"onDragOver","id":"method-onDragOver"},{"tagname":"method","owner":"Ext.dd.DragZone","meta":{},"name":"onInitDrag","id":"method-onInitDrag"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"onInvalidDrop","id":"method-onInvalidDrop"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"onMouseDown","id":"method-onMouseDown"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"onMouseUp","id":"method-onMouseUp"},{"tagname":"method","owner":"Ext.dd.DragSource","meta":{},"name":"onStartDrag","id":"method-onStartDrag"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"removeFromGroup","id":"method-removeFromGroup"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"removeInvalidHandleClass","id":"method-removeInvalidHandleClass"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"removeInvalidHandleId","id":"method-removeInvalidHandleId"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"removeInvalidHandleType","id":"method-removeInvalidHandleType"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"resetConstraints","id":"method-resetConstraints"},{"tagname":"method","owner":"Ext.dd.DD","meta":{},"name":"setDelta","id":"method-setDelta"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"setDragElId","id":"method-setDragElId"},{"tagname":"method","owner":"Ext.dd.DD","meta":{},"name":"setDragElPos","id":"method-setDragElPos"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"setHandleElId","id":"method-setHandleElId"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"setInitPosition","id":"method-setInitPosition"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"setOuterHandleElId","id":"method-setOuterHandleElId"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"setPadding","id":"method-setPadding"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"setStartPosition","id":"method-setStartPosition"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"setXConstraint","id":"method-setXConstraint"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"setXTicks","id":"method-setXTicks"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"setYConstraint","id":"method-setYConstraint"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{"private":true},"name":"setYTicks","id":"method-setYTicks"},{"tagname":"method","owner":"Ext.dd.DDProxy","meta":{"private":true},"name":"showFrame","id":"method-showFrame"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"startDrag","id":"method-startDrag"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"toString","id":"method-toString"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"unlock","id":"method-unlock"},{"tagname":"method","owner":"Ext.dd.DragDrop","meta":{},"name":"unreg","id":"method-unreg"}],"event":[],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.dd.DragZone","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.dd.DragZone","mixins":[],"mixedInto":[]});