# Generated by default/object.tt
package Paws::GreengrassV2::ComponentPlatform;
  use Moose;
  has Attributes => (is => 'ro', isa => 'Paws::GreengrassV2::PlatformAttributesMap', request_name => 'attributes', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::ComponentPlatform

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::ComponentPlatform object:

  $service_obj->Method(Att1 => { Attributes => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::ComponentPlatform object:

  $result = $service_obj->Method(...);
  $result->Att1->Attributes

=head1 DESCRIPTION

Contains information about a platform that a component supports.

=head1 ATTRIBUTES


=head2 Attributes => L<Paws::GreengrassV2::PlatformAttributesMap>

A dictionary of attributes for the platform. The AWS IoT Greengrass
Core software defines the C<os> and C<platform> by default. You can
specify additional platform attributes for a core device when you
deploy the AWS IoT Greengrass nucleus component. For more information,
see the AWS IoT Greengrass nucleus component
(https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html)
in the I<AWS IoT Greengrass V2 Developer Guide>.


=head2 Name => Str

The friendly name of the platform. This name helps you identify the
platform.

If you omit this parameter, AWS IoT Greengrass creates a friendly name
from the C<os> and C<architecture> of the platform.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

