# Generated by default/object.tt
package Paws::Macie2::FindingAction;
  use Moose;
  has ActionType => (is => 'ro', isa => 'Str', request_name => 'actionType', traits => ['NameInRequest']);
  has ApiCallDetails => (is => 'ro', isa => 'Paws::Macie2::ApiCallDetails', request_name => 'apiCallDetails', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::FindingAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::FindingAction object:

  $service_obj->Method(Att1 => { ActionType => $value, ..., ApiCallDetails => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::FindingAction object:

  $result = $service_obj->Method(...);
  $result->Att1->ActionType

=head1 DESCRIPTION

Provides information about an action that occurred for a resource and
produced a policy finding.

=head1 ATTRIBUTES


=head2 ActionType => Str

The type of action that occurred for the affected resource. This value
is typically AWS_API_CALL, which indicates that an entity invoked an
API operation for the resource.


=head2 ApiCallDetails => L<Paws::Macie2::ApiCallDetails>

The invocation details of the API operation that an entity invoked for
the affected resource, if the value for the actionType property is
AWS_API_CALL.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

