#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
e468cc26 PERL-761 Use killCursors command for MongoDB 3.2+
60c88bd9 PERL-713 PERL-714 Username no longer required for X509
9796032b PERL-763 Makefile.PL fails with no '.' in @INC
278d0e0d PERL-760 Switch to binary type SASL payloads
ecb38e8b PERL-730: CI: test with repo-specific prereq library
808ed3e6 PERL-717 Force localhost to connect via IPv4
9618b03b PERL-730 Update deprecated 'last_error' test
8dd7b713 PERL-730 Fix app_name test for multi-shard topologies
760a4b78 PERL-730 Skip direct connect test if auth needed
a01d2774 PERL-746 Fix GridFS tests on Windows
9cc39b5b PERL-730 CI: Add stable 1.x branch to CI testing

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
