# Generated by default/object.tt
package Paws::Macie2::SearchResourcesSortCriteria;
  use Moose;
  has AttributeName => (is => 'ro', isa => 'Str', request_name => 'attributeName', traits => ['NameInRequest']);
  has OrderBy => (is => 'ro', isa => 'Str', request_name => 'orderBy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::SearchResourcesSortCriteria

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::SearchResourcesSortCriteria object:

  $service_obj->Method(Att1 => { AttributeName => $value, ..., OrderBy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::SearchResourcesSortCriteria object:

  $result = $service_obj->Method(...);
  $result->Att1->AttributeName

=head1 DESCRIPTION

Specifies criteria for sorting the results of a query for information
about Amazon Web Services resources that Amazon Macie monitors and
analyzes.

=head1 ATTRIBUTES


=head2 AttributeName => Str

The property to sort the results by.


=head2 OrderBy => Str

The sort order to apply to the results, based on the value for the
property specified by the attributeName property. Valid values are:
ASC, sort the results in ascending order; and, DESC, sort the results
in descending order.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

