# Generated by default/object.tt
package Paws::GlueDataBrew::ExcelOptions;
  use Moose;
  has HeaderRow => (is => 'ro', isa => 'Bool');
  has SheetIndexes => (is => 'ro', isa => 'ArrayRef[Int]');
  has SheetNames => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::ExcelOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::ExcelOptions object:

  $service_obj->Method(Att1 => { HeaderRow => $value, ..., SheetNames => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::ExcelOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->HeaderRow

=head1 DESCRIPTION

Represents a set of options that define how DataBrew will interpret a
Microsoft Excel file when creating a dataset from that file.

=head1 ATTRIBUTES


=head2 HeaderRow => Bool

A variable that specifies whether the first row in the file is parsed
as the header. If this value is false, column names are auto-generated.


=head2 SheetIndexes => ArrayRef[Int]

One or more sheet numbers in the Excel file that will be included in
the dataset.


=head2 SheetNames => ArrayRef[Str|Undef]

One or more named sheets in the Excel file that will be included in the
dataset.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

