package WebService::Mattermost::V4::API::Resource::Cache;

# ABSTRACT: Wrapped API methods for the cache API endpoints.

use Moo;

extends 'WebService::Mattermost::V4::API::Resource';

################################################################################

sub invalidate {
    my $self = shift;

    return $self->_single_view_post({
        endpoint => 'invalidate',
        view     => 'Status',
    });
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Cache - Wrapped API methods for the cache API endpoints.

=head1 VERSION

version 0.30

=head1 DESCRIPTION

=head2 USAGE

    use WebService::Mattermost;

    my $mm = WebService::Mattermost->new({
        authenticate => 1,
        username     => 'me@somewhere.com',
        password     => 'hunter2',
        base_url     => 'https://my.mattermost.server.com/api/v4/',
    });

    my $resource = $mm->api->cache;

=head2 METHODS

=over 4

=item C<invalidate()>

L<Invalidate all the caches|https://api.mattermost.com/#tag/system%2Fpaths%2F~1caches~1invalidate%2Fpost>

    my $response = $resource->invalidate();

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
