# Generated by default/object.tt
package Paws::Lambda::ImageConfig;
  use Moose;
  has Command => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has EntryPoint => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has WorkingDirectory => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lambda::ImageConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lambda::ImageConfig object:

  $service_obj->Method(Att1 => { Command => $value, ..., WorkingDirectory => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lambda::ImageConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Command

=head1 DESCRIPTION

Configuration values that override the container image Dockerfile
settings. See Container settings
(https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms).

=head1 ATTRIBUTES


=head2 Command => ArrayRef[Str|Undef]

Specifies parameters that you want to pass in with ENTRYPOINT.


=head2 EntryPoint => ArrayRef[Str|Undef]

Specifies the entry point to their application, which is typically the
location of the runtime executable.


=head2 WorkingDirectory => Str

Specifies the working directory.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lambda>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

