# Generated by default/object.tt
package Paws::GreengrassV2::LambdaLinuxProcessParams;
  use Moose;
  has ContainerParams => (is => 'ro', isa => 'Paws::GreengrassV2::LambdaContainerParams', request_name => 'containerParams', traits => ['NameInRequest']);
  has IsolationMode => (is => 'ro', isa => 'Str', request_name => 'isolationMode', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::LambdaLinuxProcessParams

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::LambdaLinuxProcessParams object:

  $service_obj->Method(Att1 => { ContainerParams => $value, ..., IsolationMode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::LambdaLinuxProcessParams object:

  $result = $service_obj->Method(...);
  $result->Att1->ContainerParams

=head1 DESCRIPTION

Contains parameters for a Linux process that contains an AWS Lambda
function.

=head1 ATTRIBUTES


=head2 ContainerParams => L<Paws::GreengrassV2::LambdaContainerParams>

The parameters for the container in which the Lambda function runs.


=head2 IsolationMode => Str

The isolation mode for the process that contains the Lambda function.
The process can run in an isolated runtime environment inside the AWS
IoT Greengrass container, or as a regular process outside any
container.

Default: C<GreengrassContainer>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

