# Generated by default/object.tt
package Paws::Signer::Permission;
  use Moose;
  has Action => (is => 'ro', isa => 'Str', request_name => 'action', traits => ['NameInRequest']);
  has Principal => (is => 'ro', isa => 'Str', request_name => 'principal', traits => ['NameInRequest']);
  has ProfileVersion => (is => 'ro', isa => 'Str', request_name => 'profileVersion', traits => ['NameInRequest']);
  has StatementId => (is => 'ro', isa => 'Str', request_name => 'statementId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Signer::Permission

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Signer::Permission object:

  $service_obj->Method(Att1 => { Action => $value, ..., StatementId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Signer::Permission object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

A cross-account permission for a signing profile.

=head1 ATTRIBUTES


=head2 Action => Str

An AWS Signer action permitted as part of cross-account permissions.


=head2 Principal => Str

The AWS principal that has been granted a cross-account permission.


=head2 ProfileVersion => Str

The signing profile version that a permission applies to.


=head2 StatementId => Str

A unique identifier for a cross-account permission statement.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Signer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

