/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class ConjugateOpImage
extends PointOpImage {
    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        int n = sampleModel.getTransferType();
        boolean bl = false;
        if (n == 0) {
            n = 2;
            bl = true;
        } else if (n == 1) {
            n = 3;
            bl = true;
        }
        if (bl) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n, sampleModel.getWidth(), sampleModel.getHeight(), sampleModel.getNumBands());
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public ConjugateOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, ConjugateOpImage.layoutHelper(imageLayout, renderedImage), map, true);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ConjugateOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            int n9;
            int n10;
            int n11;
            int n12;
            boolean bl = n8 % 2 == 0;
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n13 = nArray2[n8];
            int n14 = nArray[n8];
            if (bl) {
                n12 = 0;
                while (n12 < n2) {
                    n11 = n13;
                    n10 = n14;
                    n9 = 0;
                    while (n9 < n) {
                        sArray3[n10] = sArray4[n11];
                        n11 += n6;
                        n10 += n4;
                        ++n9;
                    }
                    n13 += n7;
                    n14 += n5;
                    ++n12;
                }
            } else {
                n12 = 0;
                while (n12 < n2) {
                    n11 = n13;
                    n10 = n14;
                    n9 = 0;
                    while (n9 < n) {
                        sArray3[n10] = ImageUtil.clampShort(-sArray4[n11]);
                        n11 += n6;
                        n10 += n4;
                        ++n9;
                    }
                    n13 += n7;
                    n14 += n5;
                    ++n12;
                }
            }
            ++n8;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            int n9;
            int n10;
            int n11;
            int n12;
            boolean bl = n8 % 2 == 0;
            int[] nArray5 = nArray[n8];
            int[] nArray6 = nArray3[n8];
            int n13 = nArray4[n8];
            int n14 = nArray2[n8];
            if (bl) {
                n12 = 0;
                while (n12 < n2) {
                    n11 = n13;
                    n10 = n14;
                    n9 = 0;
                    while (n9 < n) {
                        nArray5[n10] = nArray6[n11];
                        n11 += n6;
                        n10 += n4;
                        ++n9;
                    }
                    n13 += n7;
                    n14 += n5;
                    ++n12;
                }
            } else {
                n12 = 0;
                while (n12 < n2) {
                    n11 = n13;
                    n10 = n14;
                    n9 = 0;
                    while (n9 < n) {
                        nArray5[n10] = -nArray6[n11];
                        n11 += n6;
                        n10 += n4;
                        ++n9;
                    }
                    n13 += n7;
                    n14 += n5;
                    ++n12;
                }
            }
            ++n8;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            int n9;
            int n10;
            int n11;
            int n12;
            boolean bl = n8 % 2 == 0;
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n13 = nArray2[n8];
            int n14 = nArray[n8];
            if (bl) {
                n12 = 0;
                while (n12 < n2) {
                    n11 = n13;
                    n10 = n14;
                    n9 = 0;
                    while (n9 < n) {
                        fArray3[n10] = fArray4[n11];
                        n11 += n6;
                        n10 += n4;
                        ++n9;
                    }
                    n13 += n7;
                    n14 += n5;
                    ++n12;
                }
            } else {
                n12 = 0;
                while (n12 < n2) {
                    n11 = n13;
                    n10 = n14;
                    n9 = 0;
                    while (n9 < n) {
                        fArray3[n10] = -fArray4[n11];
                        n11 += n6;
                        n10 += n4;
                        ++n9;
                    }
                    n13 += n7;
                    n14 += n5;
                    ++n12;
                }
            }
            ++n8;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            int n9;
            int n10;
            int n11;
            int n12;
            boolean bl = n8 % 2 == 0;
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n13 = nArray2[n8];
            int n14 = nArray[n8];
            if (bl) {
                n12 = 0;
                while (n12 < n2) {
                    n11 = n13;
                    n10 = n14;
                    n9 = 0;
                    while (n9 < n) {
                        dArray3[n10] = dArray4[n11];
                        n11 += n6;
                        n10 += n4;
                        ++n9;
                    }
                    n13 += n7;
                    n14 += n5;
                    ++n12;
                }
            } else {
                n12 = 0;
                while (n12 < n2) {
                    n11 = n13;
                    n10 = n14;
                    n9 = 0;
                    while (n9 < n) {
                        dArray3[n10] = -dArray4[n11];
                        n11 += n6;
                        n10 += n4;
                        ++n9;
                    }
                    n13 += n7;
                    n14 += n5;
                    ++n12;
                }
            }
            ++n8;
        }
    }
}

