# Generated by WebService::BitbucketServer::WADL - DO NOT EDIT!
package WebService::BitbucketServer::JIRA::V1;
# ABSTRACT: Bindings for a Bitbucket Server REST API


use warnings;
use strict;

our $VERSION = '0.602'; # VERSION

use Moo;
use namespace::clean;


has context => (
    is          => 'ro',
    isa         => sub { die 'Not a WebService::BitbucketServer' if !$_[0]->isa('WebService::BitbucketServer'); },
    required    => 1,
);


sub _croak { require Carp; Carp::croak(@_) }

sub _get_url {
    my $url  = shift;
    my $args = shift || {};
    $url =~ s/\{([^:}]+)(?::\.\*)?\}/_get_path_parameter($1, $args)/eg;
    return $url;
}

sub _get_path_parameter {
    my $name = shift;
    my $args = shift || {};
    return delete $args->{$name} if defined $args->{$name};
    $name =~ s/([A-Z])/'_'.lc($1)/eg;
    return delete $args->{$name} if defined $args->{$name};
    _croak("Missing required parameter $name");
}


sub create_issue {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('jira/1.0/comments/{commentId}/issues', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub get_commits {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('jira/1.0/issues/{issueKey}/commits', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub get_issue_keys_for_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('jira/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/issues', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::BitbucketServer::JIRA::V1 - Bindings for a Bitbucket Server REST API

=head1 VERSION

version 0.602

=head1 SYNOPSIS

    my $stash = WebService::BitbucketServer->new(
        base_url    => 'https://stash.example.com/',
        username    => 'bob',
        password    => 'secret',
    );
    my $api = $stash->jira;

=head1 DESCRIPTION

This is a Bitbucket Server REST API for L<JIRA::V1|https://developer.atlassian.com/static/rest/bitbucket-server/5.5.0/bitbucket-jira-rest.html>.

Original API documentation created by and copyright Atlassian.

=head1 ATTRIBUTES

=head2 context

Get the instance of L<WebService::BitbucketServer> passed to L</new>.

=head1 METHODS

=head2 new

    $api = WebService::BitbucketServer::JIRA::V1->new(context => $webservice_bitbucketserver_obj);

Create a new API.

Normally you would use C<<< $webservice_bitbucketserver_obj->jira >>> instead.

=head2 create_issue

Create a JIRA issue and associate it with a comment on a pull request.

This resource can only be used with comments on a pull request. Attempting to
call this resource with a different type of comment (for example, a comment on a
commit) will result in an error.

The authenticated user must have B<<< REPO_READ >>> permission for the repository containing the comment
to call this resource.

The JSON structure for the create issue format is specified by JIRA's REST v2 API.

    POST jira/1.0/comments/{commentId}/issues

Parameters:

=over 4

=item * C<<< applicationId >>> - string, default: none

ID of the JIRA server

=back

Responses:

=over 4

=item * C<<< 201 >>> - data, type: application/json

The created JIRA issue key and the associated comment ID

=item * C<<< 400 >>> - errors, type: application/json

The specified application link ID does not match any linked JIRA instance.

=item * C<<< 401 >>> - errors, type: application/json

Authentication with the JIRA instance is required.

=back

=head2 get_commits

Retrieve a page of changesets associated with the given issue key.

    GET jira/1.0/issues/{issueKey}/commits

Parameters:

=over 4

=item * C<<< issueKey >>> - string, default: none

the issue key to search by.

=item * C<<< maxChanges >>> - int, default: 10

the maximum number of changes to retrieve for each changeset.

=back

Responses:

=over 4

=item * C<<< 200 >>> - page, type: application/json

A page of detailed changesets.

=back

=head2 get_issue_keys_for_pull_request

Retrieves JIRA issue keys that are associated with the commits in the specified pull request. The number of
commits checked for issues is limited to a default of 100.

    GET jira/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/issues

Parameters:

=over 4

=item * C<<< pullRequestId >>> - long, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - issueKeys, type: application/json

A list of JIRA issues keys for the pull request

=back

=head1 SEE ALSO

=over 4

=item * L<WebService::BitbucketServer>

=item * L<https://developer.atlassian.com/bitbucket/server/docs/latest/>

=back

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/chazmcgarvey/WebService-BitbucketServer/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Charles McGarvey <chazmcgarvey@brokenzipper.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Charles McGarvey.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
