package WebService::Mattermost::V4::API::Resource::Plugins;

# ABSTRACT: Wrapped API methods for the plugins API endpoints.

use Moo;

extends 'WebService::Mattermost::V4::API::Resource';
with    'WebService::Mattermost::V4::API::Resource::Role::View::Plugins';

################################################################################

sub upload {
    my $self     = shift;
    my $filename = shift;

    return $self->_single_view_post({
        required           => [ qw(plugin) ],
        override_data_type => 'form',
        parameters         => {
            plugin => { file => $filename },
        },
        view               => 'Status',
    });
}

sub all {
    my $self = shift;

    return $self->_get();
}

sub all_webapp {
    my $self = shift;

    return $self->_get({ endpoint => 'webapp' });
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Plugins - Wrapped API methods for the plugins API endpoints.

=head1 VERSION

version 0.23

=head1 DESCRIPTION

=head2 USAGE

    use WebService::Mattermost;

    my $mm = WebService::Mattermost->new({
        authenticate => 1,
        username     => 'me@somewhere.com',
        password     => 'hunter2',
        base_url     => 'https://my.mattermost.server.com/api/v4/',
    });

    my $resource = $mm->api->plugins;

=head2 METHODS

=over 4

=item C<upload()>

L<Upload plugin|https://api.mattermost.com/#tag/plugins%2Fpaths%2F~1plugins%2Fpost>

    my $response = $resource->upload('/path/to/plugin.tar.gz');

=item C<all()>

L<Get plugins|https://api.mattermost.com/#tag/plugins%2Fpaths%2F~1plugins%2Fget>

    my $response = $resource->all();

=item C<webapp()>

L<Get webapp plugins|https://api.mattermost.com/#tag/plugins%2Fpaths%2F~1plugins~1webapp%2Fget>

    my $response = $resource->all_webapp();

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
