package WebService::Mattermost::V4::API::Resource::Role::Single;

# ABSTRACT: Marks a resource as an object with an identifier.

use Moo::Role;
use Types::Standard 'Str';

################################################################################

has id => (is => 'rw', isa => Str, required => 0);

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Role::Single - Marks a resource as an object with an identifier.

=head1 VERSION

version 0.31

=head1 DESCRIPTION

To be included in API resources for a single result object (i.e. something with
a unique identifier).

The C<id> attribute may be overridden by an ID parameter being passed to a
method call (which will take precedence over the C<id> attribute).

=head1 ATTRIBUTES

=over 4

=item C<id>

String.

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
