#!/usr/bin/perl

package eBay::API::XML::Call::GetAccount::GetAccountResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetAccountResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetAccount::GetAccountResponseType

=head1 DESCRIPTION

Returns information about an eBay seller's own account.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetAccount::GetAccountResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::AccountEntriesType;
use eBay::API::XML::DataType::AccountSummaryType;
use eBay::API::XML::DataType::PaginationResultType;
use eBay::API::XML::DataType::Enum::CurrencyCodeType;


my @gaProperties = ( [ 'AccountEntries', 'ns:AccountEntriesType', ''
	     ,'eBay::API::XML::DataType::AccountEntriesType', '1' ]
	, [ 'AccountID', 'xs:string', '', '', '' ]
	, [ 'AccountSummary', 'ns:AccountSummaryType', ''
	     ,'eBay::API::XML::DataType::AccountSummaryType', '1' ]
	, [ 'Currency', 'ns:CurrencyCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CurrencyCodeType', '' ]
	, [ 'EntriesPerPage', 'xs:int', '', '', '' ]
	, [ 'HasMoreEntries', 'xs:boolean', '', '', '' ]
	, [ 'PageNumber', 'xs:int', '', '', '' ]
	, [ 'PaginationResult', 'ns:PaginationResultType', ''
	     ,'eBay::API::XML::DataType::PaginationResultType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAccountEntries()

Contains individual account entries, according to the report's scope and date range.
Each account entry represents one credit, debit, or administrative account action.

#    Argument: 'ns:AccountEntriesType'

=cut

sub setAccountEntries {
  my $self = shift;
  $self->{'AccountEntries'} = shift
}

=head2 getAccountEntries()

  Returned: Conditionally
#    Returns: 'ns:AccountEntriesType'

=cut

sub getAccountEntries {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AccountEntries'
		,'eBay::API::XML::DataType::AccountEntriesType');
}


=head2 setAccountID()

Specifies the seller's unique account number.

#    Argument: 'xs:string'

=cut

sub setAccountID {
  my $self = shift;
  $self->{'AccountID'} = shift
}

=head2 getAccountID()

  Returned: Always
#    Returns: 'xs:string'

=cut

sub getAccountID {
  my $self = shift;
  return $self->{'AccountID'};
}


=head2 setAccountSummary()

Contains summary data for the seller's account, such as the overall
balance, bank account and credit card information, and amount and
date of any past due balances. Can also contain data for
one or more additional accounts, if the user has changed country
of residence.

#    Argument: 'ns:AccountSummaryType'

=cut

sub setAccountSummary {
  my $self = shift;
  $self->{'AccountSummary'} = shift
}

=head2 getAccountSummary()

  Returned: Conditionally
#    Returns: 'ns:AccountSummaryType'

=cut

sub getAccountSummary {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AccountSummary'
		,'eBay::API::XML::DataType::AccountSummaryType');
}


=head2 setCurrency()

Indicates the currency used for monetary amounts in the report.

#    Argument: 'ns:CurrencyCodeType'

=cut

sub setCurrency {
  my $self = shift;
  $self->{'Currency'} = shift
}

=head2 getCurrency()

  Returned: Always
#    Returns: 'ns:CurrencyCodeType'

=cut

sub getCurrency {
  my $self = shift;
  return $self->{'Currency'};
}


=head2 setEntriesPerPage()

Specifies the number of items that are being returned per virtual page of date.
Value is the same as that specified in Pagination.EntriesPerPage.

#    Argument: 'xs:int'

=cut

sub setEntriesPerPage {
  my $self = shift;
  $self->{'EntriesPerPage'} = shift
}

=head2 getEntriesPerPage()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getEntriesPerPage {
  my $self = shift;
  return $self->{'EntriesPerPage'};
}


=head2 setHasMoreEntries()

Indicates whether there are more items yet to be retrieved. Additional calls
must be made to retrieve those items.

#    Argument: 'xs:boolean'

=cut

sub setHasMoreEntries {
  my $self = shift;
  $self->{'HasMoreEntries'} = shift
}

=head2 isHasMoreEntries()

  Returned: Conditionally
#    Returns: 'xs:boolean'

=cut

sub isHasMoreEntries {
  my $self = shift;
  return $self->{'HasMoreEntries'};
}


=head2 setPageNumber()

Indicates which page of data was just returned. Value is the same as the value
specified in Pagination.PageNumber. If PageNumber in the request is higher than
the total number of pages, the call fails with an error.)

#    Argument: 'xs:int'

=cut

sub setPageNumber {
  my $self = shift;
  $self->{'PageNumber'} = shift
}

=head2 getPageNumber()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getPageNumber {
  my $self = shift;
  return $self->{'PageNumber'};
}


=head2 setPaginationResult()

Contains the total number of pages (TotalNumberOfPages) and the total
number of account entries (TotalNumberOfEntries) that can be returned
on repeated calls with the same format and report criteria.

#    Argument: 'ns:PaginationResultType'

=cut

sub setPaginationResult {
  my $self = shift;
  $self->{'PaginationResult'} = shift
}

=head2 getPaginationResult()

  Returned: Always
#    Returns: 'ns:PaginationResultType'

=cut

sub getPaginationResult {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaginationResult'
		,'eBay::API::XML::DataType::PaginationResultType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
