/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : SERIALIZER
    Description : Generic Object serializer
    Author      : David Martnez Oliveira
    Date        : August, 14, 2002
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/
#include <stdlib.h>
#include <string.h> 
/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class SERIALIZER
***************************************************
*/
 
typedef struct
{
	EDMAT_BUFFER		buffer;
}DtSERIALIZER;

/* Other data struct required*/
typedef struct
{
  ESint32         type;
  ESint32         size;
  unsigned char   data[1];
} PROP_RECORD;

typedef struct
{
  EChar           class_name[EDMA_CLASS_NAME_LEN];
  PROP_RECORD   data[1];  /* PROP_RECORD packed array*/
} OBJECT_RECORD;

/*
***************************************************
  Method Declaration for class SERIALIZER
***************************************************
*/
 
ESint32 EDMAPROC
SERIALIZERmarshallOrS32 (OBJID IdObj, OBJID id)
{
  DtSERIALIZER	*m;
  CLASSID       cid;
  ESint32       n_prop;
  unsigned char *data;
  EUint32       type, size, new_size, old_size, i;
  EChar         prop_name[EDMA_PROP_NAME_LEN];
  EDMAT_BUFFER  aux;
  unsigned char base_type[8]; /* Max size for base types is 8 bytes*/
  PROP_RECORD   *item;

  m = (DtSERIALIZER *) edma_get_data_ref (IdObj);
  /* Get object class identifier*/
  if ((cid = edma_get_obj_class_id (id)) == -1)
    {
      edma_printf_obj (IdObj, "** ERROR ** Can't get class id for object %d",
		       id);
      return -1;
    }
  /* Get prop num */
  if ((n_prop = edma_get_prop_num (cid)) == -1)
    {
      edma_printf_obj (IdObj,
		       "** ERROR ** Can't get number of properties "
		       "for class id %ld", cid);
      return -1;
    }
  /* First we marshall properties for the base object */
  edma_buffer_alloc (&m->buffer, sizeof (OBJECT_RECORD));
  edma_get_class_name (cid, ((OBJECT_RECORD *)m->buffer.dat)->class_name);

  new_size = 0;
  old_size= EDMA_CLASS_NAME_LEN;
  m->buffer.dat = NULL;
  m->buffer.Size = 0;

  for (i = 0; i < n_prop; i++)
    {

      /* Get property information */
      edma_get_prop_name (cid, i, prop_name);
      type = edma_get_prop_type_id (cid, i);
      size = edma_get_type_size (type);

      /* First implementation. We just consider simple types*/
      /* Here we process special types */
      switch (type)
	{
	case DT_EBUFFER:
	  edma_rprop3 (id, prop_name, &aux);
	  size = aux.Size;
	  
	  break;
	}

      new_size = old_size + sizeof (PROP_RECORD) + size;

      edma_buffer_realloc (&m->buffer, new_size);

      item = (PROP_RECORD*)((EPByte)m->buffer.dat + old_size);
      item->type = type;
      item->size = size;

      switch (type)
	{
	case DT_EBUFFER:
	  data = (unsigned char*) aux.dat;
	  memcpy (item->data, data, size);
	  break;
	default:
	  edma_rprop3 (id, prop_name, &base_type);
	  data = base_type;
	  memcpy (item->data, data, size);
	  break;
	}
      old_size = new_size;
    }
  edma_printf_obj (IdObj, "%s", "-------------------------------------------");
  edma_printf_obj (IdObj, "Class name : %s", (EPChar) m->buffer.dat);
  item = (PROP_RECORD *) ((OBJECT_RECORD *)m->buffer.dat)->data;

  for (i = 0; i < n_prop; i++)
    {
      edma_printf_obj (IdObj, "Type = %ld Size = %ld", item->type, item->size);
      item = (PROP_RECORD *)((unsigned char *)item + item->size + sizeof(PROP_RECORD));
    }
  edma_printf_obj (IdObj, "Marshall done!!! <------------------------->");
  return 0;
}


ESint32 EDMAPROC
SERIALIZERunmarshallsOrS32(OBJID IdObj, OBJID *id)
{
  DtSERIALIZER	*m;
  PROP_RECORD   *item;
  ESint32       i, n_prop;
  EDMAT_BUFFER  *aux;
  CLASSID       cid;
  
  m = (DtSERIALIZER *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "Class name : %s", (EPChar) m->buffer.dat);
  if ((cid = edma_get_class_id ((EPChar) m->buffer.dat)) == -1)
    {
      edma_printf_obj (IdObj, "Wrong class name. Data inconsistent");
      return -1;
    }
  /* Get prop num */
  if ((n_prop = edma_get_prop_num (cid)) == -1)
    {
      edma_printf_obj (IdObj,
		       "** ERROR ** Can't get number of properties "
		       "for class id %ld", cid);
      return -1;
    }
 
  item = (PROP_RECORD *) ((OBJECT_RECORD *)m->buffer.dat)->data;
  edma_printf_obj (IdObj, "Pointer : %p [%d] properties to read", item, n_prop);
  for (i = 0; i < n_prop; i++)
    {
      edma_printf_obj (IdObj, "Type = %ld Size = %ld", item->type, item->size);
      switch (item->type)
	{
	case DT_EBUFFER:
	  aux = (EDMAT_BUFFER *) malloc (sizeof (EDMAT_BUFFER));
	  edma_buffer_alloc (aux, item->size);
	  memcpy (aux->dat, item->data, item->size);
	  _edma_wprop1_pargs (*id, i, aux); 
	  break;
	default:
	  _edma_wprop1_pargs (*id, i, item->data);
	}
      item = (PROP_RECORD *)((unsigned char *)item + item->size + sizeof(PROP_RECORD));
    }
  return 0; 
}


ESint32 EDMAPROC
SERIALIZERsaveZrS32(OBJID IdObj, EPChar fname)
{
  DtSERIALIZER	*m;
  OBJID         id;
  ESint32       len;
  
  m = (DtSERIALIZER *) edma_get_data_ref (IdObj);
  if ((id = edma_new_obj ("NFILE")) == -1)
    {
      edma_printf_obj (IdObj, "[ERROR] Can't create 'NFILE' object");
      return -1;
    }
  if ((edma_met3 (id, "open", fname, "wb")) == -1)
    {
      edma_printf_obj (IdObj, "Can't open %s file to save data", fname);
      edma_free_obj (id);
      return -1;
    }
  len = m->buffer.Size;
  if ((edma_met3 (id, "write", m->buffer, &len)) == -1)
    {
      edma_printf_obj (IdObj, "Can't write data to file");
      edma_free_obj (id);
      return -1;
    }
  edma_met3 (id, "close");
  edma_free_obj (id);
  return 0;
}


ESint32 EDMAPROC
SERIALIZERloadZrS32(OBJID IdObj, EPChar fname)
{
  DtSERIALIZER	*m;
  OBJID         id;
  ESint32       len;
  
  m = (DtSERIALIZER *) edma_get_data_ref (IdObj);
  if ((id = edma_new_obj ("NFILE")) == -1)
    {
      edma_printf_obj (IdObj, "[ERROR] Can't create 'NFILE' object");
      return -1;
    }
  if ((edma_met3 (id, "open", fname, "rb")) == -1)
    {
      edma_printf_obj (IdObj, "Can't open %s file to read data", fname);
      edma_free_obj (id);
      return -1;
    }
  len = (ESint32) edma_smet3 ("FILESYSTEM", "GetFileSize", fname);
  edma_printf_obj (IdObj, "[INFO] About to read %ld bytes from file %s", len, fname);
  /* Free old data and realloc buffer */
  if (m->buffer.dat)
    edma_buffer_free (&m->buffer);
  edma_buffer_alloc (&m->buffer, len);
  if ((edma_met3 (id, "read", &m->buffer, &len)) == -1)
    {
      edma_printf_obj (IdObj, "Can't write data to file");
      edma_free_obj (id);
      return -1;
    }
  edma_met3 (id, "close");
  edma_free_obj (id);
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
