/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.cvspm.State;
import com.sun.electric.tool.cvspm.Update;
import com.sun.electric.tool.user.Exec;
import com.sun.electric.tool.user.User;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class Edit {
    private static Map<CellId, CellId> modifiedCells = new HashMap<CellId, CellId>();
    private static final String hostName;
    private static final String userName;

    public static boolean edit(Cell cell) {
        File file = CVS.getCellFile(cell);
        if (!CVS.isDELIB(cell.getLibrary())) {
            return false;
        }
        if (!CVS.isFileInCVS(CVS.getCellFile(cell))) {
            return false;
        }
        String dir = file.getParent();
        String c = file.getName();
        boolean success = Edit.edit(c, dir);
        return success;
    }

    public static boolean edit(String file, String dir) {
        CVS.runCVSCommand(CVS.getCVSProgram(), CVS.getRepository(), "edit -a none " + file, "Edit", dir, System.out);
        return true;
    }

    public static void listEditorsProject() {
        ArrayList<Library> allLibs = new ArrayList<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk()) continue;
            allLibs.add(lib);
        }
        new ListEditorsJob(allLibs, null, true).startJob();
    }

    public static void listEditorsOpenLibraries() {
        ArrayList<Library> allLibs = new ArrayList<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk()) continue;
            allLibs.add(lib);
        }
        Edit.listEditors(allLibs, null);
    }

    public static void listEditors(Library lib) {
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.add(lib);
        Edit.listEditors(libs, null);
    }

    public static void listEditors(Cell cell) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        cells.add(cell);
        Edit.listEditors(null, cells);
    }

    public static void listEditors(List<Library> libs, List<Cell> cells) {
        new ListEditorsJob(libs, cells, false).startJob();
    }

    static void endBatch(Snapshot oldSnapshot, Snapshot newSnapshot, boolean undoRedo) {
        ArrayList<Object> newlyModifiedCells = new ArrayList<Object>();
        ArrayList<Object> newlyUnmodifiedCells = new ArrayList<Object>();
        for (CellId cellId : newSnapshot.getChangedCells(oldSnapshot)) {
            Object cell = Cell.inCurrentThread(cellId);
            if (cell == null) {
                modifiedCells.remove(cellId);
                continue;
            }
            if (((Cell)cell).isModified() && !modifiedCells.containsKey(cellId)) {
                modifiedCells.put(cellId, cellId);
                newlyModifiedCells.add(cell);
            }
            if (((Cell)cell).isModified() || !modifiedCells.containsKey(cellId)) continue;
            modifiedCells.remove(cellId);
            newlyUnmodifiedCells.add(cell);
        }
        ArrayList<Cell> markForEdit = new ArrayList<Cell>();
        for (Object cell : newlyModifiedCells) {
            State state = CVSLibrary.getState((Cell)cell);
            if (state != State.NONE && state != State.CONFLICT && state != State.UPDATE) continue;
            markForEdit.add((Cell)cell);
        }
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        for (Cell cell : newlyUnmodifiedCells) {
            State state = CVSLibrary.getState(cell);
            if (state != State.NONE && state != State.CONFLICT && state != State.UPDATE) continue;
            arrayList.add(cell);
        }
        CVSLibrary.LibsCells modified = CVSLibrary.getInCVSSorted(new ArrayList<Library>(), markForEdit);
        if (modified.libs.size() != 0 || modified.cells.size() != 0) {
            new MarkForEditJob(modified.libs, modified.cells, true, false).startJob();
        }
        CVSLibrary.LibsCells libsCells = CVSLibrary.getInCVSSorted(new ArrayList<Library>(), arrayList);
        if (libsCells.libs.size() != 0 || libsCells.cells.size() != 0) {
            new MarkForEditJob(libsCells.libs, libsCells.cells, false, true).startJob();
        }
    }

    public static void editConsistencyCheck() {
        ArrayList<Library> allLibs = new ArrayList<Library>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isFromDisk()) continue;
            allLibs.add(lib);
        }
        Edit.editConsistencyCheck(allLibs, new ArrayList<Cell>());
    }

    public static void editConsistencyCheck(List<Library> libs, List<Cell> cells) {
        new EditConsistencyCheckJob(libs, cells).startJob();
    }

    public static List<Editor> parseOutput(LineNumberReader result) {
        ArrayList<Editor> editors = new ArrayList<Editor>();
        while (true) {
            Editor editor;
            String line;
            try {
                line = result.readLine();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                break;
            }
            if (line == null) break;
            if (line.equals("") || (editor = Editor.parse(line)) == null) continue;
            editors.add(editor);
        }
        return editors;
    }

    static boolean isMe(Editor editor) {
        return editor.getUser().equals(Edit.getUserName()) && editor.getHostname().equals(Edit.getHostName());
    }

    public static final String getHostName() {
        return hostName;
    }

    public static final String getUserName() {
        return userName;
    }

    static {
        String name = "unknownHost";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            name = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        hostName = name;
        userName = System.getProperty("user.name", "unknownUser");
    }

    public static class ListEditorsJob
    extends Job {
        private List<Library> libs;
        private List<Cell> cells;
        private boolean forProject;
        private String cvsProgram = CVS.getCVSProgram();
        private String repository = CVS.getRepository();

        public ListEditorsJob(List<Library> libs, List<Cell> cells, boolean forProject) {
            super("List CVS Editors", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.libs = libs;
            this.cells = cells;
            this.forProject = forProject;
            if (this.libs == null) {
                this.libs = new ArrayList<Library>();
            }
            if (this.cells == null) {
                this.cells = new ArrayList<Cell>();
            }
        }

        @Override
        public boolean doIt() {
            StringBuffer cellsBuf;
            String useDir = CVS.getUseDir(this.libs, this.cells);
            StringBuffer libsBuf = CVS.getLibraryFiles(this.libs, useDir);
            Object args = libsBuf + " " + (cellsBuf = CVS.getCellFiles(this.cells, useDir));
            if (((String)args).trim().equals("")) {
                return true;
            }
            if (this.forProject) {
                args = "";
            }
            CVS.runCVSCommand(this.cvsProgram, this.repository, "editors " + (String)args, "List CVS Editors", useDir, System.out);
            System.out.println("List CVS Editors complete.");
            return true;
        }
    }

    public static class MarkForEditJob
    extends Job {
        private List<Library> libs;
        private List<Cell> cells;
        private boolean unedit;
        private boolean checkConflicts;
        private List<String> uneditMatchedStrings;
        private List<Editor> editors;
        private String cvsProgram = CVS.getCVSProgram();
        private String repository = CVS.getRepository();

        public MarkForEditJob(List<Library> libs, List<Cell> cells, boolean checkConflicts, boolean unedit) {
            super("Check CVS Editors", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.libs = libs;
            this.cells = cells;
            this.checkConflicts = checkConflicts;
            this.unedit = unedit;
            this.editors = new ArrayList<Editor>();
            if (this.libs == null) {
                this.libs = new ArrayList<Library>();
            }
            if (this.cells == null) {
                this.cells = new ArrayList<Cell>();
            }
        }

        @Override
        public boolean doIt() {
            String useDir = CVS.getUseDir(this.libs, this.cells);
            StringBuffer libsBuf = CVS.getLibraryFiles(this.libs, useDir);
            StringBuffer cellsBuf = CVS.getCellFiles(this.cells, useDir);
            if (this.unedit) {
                State state;
                this.fieldVariableChanged("uneditMatchedStrings");
                ArrayList<Library> libsToUnedit = new ArrayList<Library>();
                ArrayList<Cell> cellsToUnedit = new ArrayList<Cell>();
                for (Library lib : this.libs) {
                    state = CVSLibrary.getState(lib);
                    if (state != State.NONE) continue;
                    libsToUnedit.add(lib);
                }
                for (Cell cell : this.cells) {
                    state = CVSLibrary.getState(cell);
                    if (state != State.NONE) continue;
                    cellsToUnedit.add(cell);
                }
                libsBuf = CVS.getLibraryFiles(libsToUnedit, useDir);
                String args = libsBuf + " " + (cellsBuf = CVS.getCellFiles(cellsToUnedit, useDir));
                if (args.trim().equals("")) {
                    return true;
                }
                Exec.OutputStreamChecker checker = new Exec.OutputStreamChecker(System.out, "has been modified; revert changes?", false, null);
                UneditResponder uneditResponder = new UneditResponder();
                checker.addOutputStreamCheckerListener(uneditResponder);
                CVS.runCVSCommand(this.cvsProgram, this.repository, "unedit -l " + args, "CVS Unedit", useDir, checker);
                this.uneditMatchedStrings = uneditResponder.matchedStrings;
                return true;
            }
            String args = libsBuf + " " + cellsBuf;
            if (args.trim().equals("")) {
                return true;
            }
            if (this.checkConflicts) {
                Editor e;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                CVS.runCVSCommand(this.cvsProgram, this.repository, "editors " + args, "Check CVS Editors", useDir, out);
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
                this.editors = Edit.parseOutput(reader);
                Update.StatusResult status = Update.update(this.cvsProgram, this.repository, args, useDir, Update.UpdateEnum.STATUS);
                for (Cell cell : status.getCells(State.CONFLICT)) {
                    e = new Editor(cell.describe(false), "CONFLICT", new Date(), "", "");
                    this.editors.add(e);
                }
                for (Cell cell : status.getCells(State.UPDATE)) {
                    e = new Editor(cell.describe(false), "NEEDS UPDATE", new Date(), "", "");
                    this.editors.add(e);
                }
                this.fieldVariableChanged("editors");
            } else {
                CVS.runCVSCommand(this.cvsProgram, this.repository, "edit -a none " + args, "CVS Edit", useDir, System.out);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.unedit) {
                if (this.uneditMatchedStrings != null) {
                    for (String matched : this.uneditMatchedStrings) {
                        String[] parts = matched.split("\\s+");
                        if (parts[0].endsWith(".jelib")) {
                            Library lib = Library.findLibrary(parts[0].substring(0, parts[0].length() - 6));
                            if (lib == null) continue;
                            CVSLibrary.setState(lib, State.MODIFIED);
                            continue;
                        }
                        Cell cell = CVS.getCellFromPath(parts[0]);
                        if (cell == null) continue;
                        CVSLibrary.setState(cell, State.MODIFIED);
                    }
                }
            } else if (this.checkConflicts) {
                ArrayList<Editor> filteredEditors = new ArrayList<Editor>();
                if (this.editors != null) {
                    for (Editor e : this.editors) {
                        if (e.getUser().equals(System.getProperty("user.name"))) continue;
                        filteredEditors.add(e);
                    }
                }
                this.editors = filteredEditors;
                if (this.editors.size() > 0) {
                    JPanel panel = new JPanel(new GridBagLayout());
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.gridx = 0;
                    constraints.gridy = 0;
                    constraints.ipady = 20;
                    constraints.anchor = 17;
                    JLabel label = new JLabel("Other Users are already Editing the following:");
                    panel.add((Component)label, constraints);
                    Object[] headers = new String[]{"File", "User"};
                    Object[][] data = new Object[this.editors.size()][2];
                    for (int i = 0; i < this.editors.size(); ++i) {
                        Editor editor = this.editors.get(i);
                        data[i][0] = editor.getAbbrevFile();
                        data[i][1] = editor.getUser();
                    }
                    JTable table = new JTable(data, headers);
                    table.getColumnModel().getColumn(0).setPreferredWidth(300);
                    table.getColumnModel().getColumn(1).setPreferredWidth(100);
                    table.setPreferredScrollableViewportSize(new Dimension(400, 100));
                    table.setFocusable(false);
                    JScrollPane scrollpane = new JScrollPane(table);
                    scrollpane.setPreferredSize(new Dimension(400, 100));
                    Font font = new Font("Courier", 0, 12);
                    table.setFont(font);
                    constraints = new GridBagConstraints();
                    constraints.gridx = 0;
                    constraints.gridy = 1;
                    panel.add((Component)scrollpane, constraints);
                    Object[] options = new Object[]{"UNDO CHANGES", "CONTINUE ANYWAY"};
                    int ret = JOptionPane.showOptionDialog(null, panel, "Edit Conflict!", -1, 2, null, options, options[0]);
                    if (ret == 0) {
                        Undo.undo();
                        return;
                    }
                }
                new MarkForEditJob(this.libs, this.cells, false, this.unedit).startJob();
            }
        }
    }

    public static class EditConsistencyCheckJob
    extends Job {
        private List<Library> libs;
        private List<Cell> cells;
        private List<Editor> editors;
        private String cvsProgram = CVS.getCVSProgram();
        private String repository = CVS.getRepository();

        public EditConsistencyCheckJob(List<Library> libs, List<Cell> cells) {
            super("CVS Editors Check", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.libs = libs;
            this.cells = cells;
            this.editors = new ArrayList<Editor>();
            if (this.libs == null) {
                this.libs = new ArrayList<Library>();
            }
            if (this.cells == null) {
                this.cells = new ArrayList<Cell>();
            }
        }

        @Override
        public boolean doIt() {
            StringBuffer cellsBuf;
            String useDir = CVS.getUseDir(this.libs, this.cells);
            StringBuffer libsBuf = CVS.getLibraryFiles(this.libs, useDir);
            String args = libsBuf + " " + (cellsBuf = CVS.getCellFiles(this.cells, useDir));
            if (args.trim().equals("")) {
                return true;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            CVS.runCVSCommand(this.cvsProgram, this.repository, "editors " + args, "Check CVS Editors", useDir, out);
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
            this.editors = Edit.parseOutput(reader);
            this.libs.clear();
            this.cells.clear();
            for (Editor e : this.editors) {
                Cell cell;
                Library lib;
                ElectricObject eobj;
                if (!e.getUser().equals(System.getProperty("user.name")) || (eobj = e.findObject()) == null) continue;
                if (eobj instanceof Library && !(lib = (Library)eobj).isChanged() && CVSLibrary.getState(lib) == State.NONE) {
                    this.libs.add(lib);
                }
                if (!(eobj instanceof Cell) || (cell = (Cell)eobj).isModified() || CVSLibrary.getState(cell) != State.NONE) continue;
                this.cells.add(cell);
            }
            libsBuf = CVS.getLibraryFiles(this.libs, useDir);
            args = libsBuf + " " + (cellsBuf = CVS.getCellFiles(this.cells, useDir));
            if (args.trim().equals("")) {
                return true;
            }
            CVS.runCVSCommand(this.cvsProgram, this.repository, "unedit -l " + args, "CVS Unedit", useDir, System.out);
            return true;
        }
    }

    public static class Editor
    implements Serializable {
        private final String file;
        private final String user;
        private final Date date;
        private final String hostname;
        private final String dir;
        private final File FD;

        private Editor(String file, String user, Date date, String hostname, String dir) {
            this.file = file;
            this.user = user;
            this.date = date;
            this.hostname = hostname;
            this.dir = dir;
            this.FD = new File(dir, file);
        }

        static Editor parse(String editorResultLine) {
            if (editorResultLine.startsWith("?")) {
                return null;
            }
            String[] parts = editorResultLine.split("\\t");
            if (parts.length == 5) {
                Date date;
                String abbreviatedFile = parts[0];
                String user = parts[1];
                DateFormat df = DateFormat.getDateInstance();
                try {
                    date = df.parse(parts[2]);
                }
                catch (ParseException e) {
                    date = new Date(0L);
                }
                String computer = parts[3];
                String dir = parts[4];
                return new Editor(abbreviatedFile, user, date, computer, dir);
            }
            System.out.println("Bad Editor result line format: " + editorResultLine);
            return null;
        }

        public String getAbbrevFile() {
            return this.file;
        }

        public String getUser() {
            return this.user;
        }

        public Date getDate() {
            return this.date;
        }

        public String getHostname() {
            return this.hostname;
        }

        public File getFile() {
            return this.FD;
        }

        public String getDir() {
            return this.dir;
        }

        public ElectricObject findObject() {
            String file = this.getAbbrevFile();
            Library lib = Editor.findLibraryWithExt(file);
            if (lib != null) {
                return lib;
            }
            String[] parts = file.split("/");
            lib = Editor.findLibraryWithExt(parts[0]);
            if (lib == null) {
                return null;
            }
            int ext = parts[1].lastIndexOf(46);
            if (ext == -1) {
                return lib.findNodeProto(parts[1]);
            }
            String view = parts[1].substring(ext + 1);
            Object cellname = parts[1].substring(0, ext);
            cellname = (String)cellname + "{" + view + "}";
            return lib.findNodeProto((String)cellname);
        }

        private static Library findLibraryWithExt(String libname) {
            if (libname.endsWith(".delib") || libname.endsWith(".jelib")) {
                return Library.findLibrary(libname.substring(0, libname.length() - 6));
            }
            if (libname.endsWith(".elib")) {
                return Library.findLibrary(libname.substring(0, libname.length() - 5));
            }
            return null;
        }
    }

    private static class UneditResponder
    implements Exec.OutputStreamCheckerListener {
        private List<String> matchedStrings = new ArrayList<String>();

        private UneditResponder() {
        }

        @Override
        public void matchFound(Exec process, String matched) {
            process.writeln("n\n");
            this.matchedStrings.add(matched);
        }
    }
}

