/**
 * Types definitions

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/structures.h,v 1.5 2004/01/16 19:55:45 Beuc Exp $
 */

#ifndef STRUCTURES_H
#define STRUCTURES_H

#include "constants.h"
#include "typedefs.h"
#include "util.h"
#include "SDL_mixer.h"

struct soundstruct
{

  /*bool*/int repeat;
  int owner;
  int survive;
  int vol;

};



struct show_bmp_t
{

  /*bool*/int active;
  /*bool*/int showdot;
  int reserved;
  int script;
  int stime;
  int picframe;

};



struct attackinfo_struct
{

  int time;
  /*bool*/int active;
  int script;
  /*bool*/int hitme;
  int last_power;
  int wait;
  int pull_wait;

};



struct wait_for_button_t
{

  int script;
  int button;
  /*bool*/int active;

};



struct talk_struct
{

  char line[21][101];
  int line_return[21];
  char buffer[3000];
  int cur;
  int last;
  /*bool*/int active;
  int cur_view;
  int cur_view_end;
  int page;
  int script;
  int offset;
  int newy;
  int color;
  int curf;
  int timer;

};



struct idata
{

  int type;
  int seq;
  int frame;
  int xoffset, yoffset;
  struct rect hardbox;

};



struct mydata
{

  unsigned char type[100];
  unsigned short seq[100];
  unsigned char frame[100];
  int last_time;

};



struct varman
{

  int var;
  char name[20];
  int scope;
  BOOL_1BYTE active;

};


struct seth_sound
{
  Mix_Chunk *sound;
};


struct player_short_info
{
  int version;
  char gameinfo[196];
  int minutes;
};



struct item_struct
{

  BOOL_1BYTE active;
  char name[10];
  int seq;
  int frame;

};



struct player_info
{

  int version;
  char gameinfo[196];
  int minutes;
  int x, y, die, size, defense, dir, pframe, pseq, seq, frame, strength,
    base_walk, base_idle, base_hit, que;


  struct item_struct mitem[9];		/* added one to these, because I don't like referring to a 0 item */
  struct item_struct item[17];

  int curitem, unused;
  int counter;
  BOOL_1BYTE idle;
  struct mydata spmap[769];
  int button[10];
  struct varman var[MAX_VARS];


  BOOL_1BYTE push_active;
  int push_dir;
  DWORD push_timer;
  int last_talk;
  int mouse;
  BOOL_1BYTE item_magic;
  int last_map;
  int crap;
  int buff[95];
  DWORD dbuff[20];


  long lbuff[10];

  char cbuff[6000];

};



struct refinfo
{
  char name[10];
  long location;
  long current;
  int level;
  long end;
  int sprite;			/* if more than 0, it was spawned and is owned by a sprite, if 1000 doesn't die */
  /*bool*/int skipnext;
  int onlevel;
  int proc_return;
};



struct call_back
{

  int owner;
  /*bool*/int active;
  int type;
  char name[20];
  int offset;
  long min, max;
  int lifespan;
  DWORD timer;

};



struct sequence
{

  int frame[51];
  int delay[51];
  unsigned char special[51];
  char data[80];
  /*bool*/int active;

};



struct sp
{

  int x, moveman;
  int y;
  int mx, my;
  int lpx[51], lpy[51];
  int speed;
  int brain;
  int seq_orig, dir;
  int seq;
  int frame;
  DWORD delay;
  int pseq;
  int pframe;

  BOOL active;
  int attrib;
  DWORD wait;
  int timer;
  int skip;
  int skiptimer;
  int size;
  int que;
  int base_walk;
  int base_idle;
  int base_attack;

  int base_hit;
  int last_sound;
  int hard;
  struct rect alt;
  int althard;
  int sp_index;
  BOOL nocontrol;
  int idle;
  int strength;
  int damage;
  int defense;
  int hitpoints;
  int exp;
  int gold;
  int base_die;
  int kill;
  int kill_timer;
  int script_num;
  char text[200];
  int owner;
  int script;
  int sound;
  int callback;
  int freeze;
  /*bool*/int move_active;
  int move_script;
  int move_dir;
  int move_num;
  BOOL move_nohard;
  int follow;
  int nohit;
  BOOL notouch;
  DWORD notouch_timer;
  BOOL flying;
  int touch_damage;
  int brain_parm;
  int brain_parm2;
  BOOL noclip;
  BOOL reverse;
  BOOL disabled;
  int target;
  int attack_wait;
  int move_wait;
  int distance;
  int last_hit;
  BOOL live;
  int range;
  int attack_hit_sound;
  int attack_hit_sound_speed;
  int action;
  int nodraw;
  int frame_delay;
  int picfreeze;

};


struct seth_joy
{

  BOOL joybit[17];		/* is button held down? */
  BOOL letgo[17];		/* copy of old above */
  BOOL button[17];		/* has button been pressed recently? */
  BOOL key[256];
  BOOL kletgo[256];
  BOOL_1BYTE realkey[256];
  BOOL right, left, up, down;
  BOOL rightd, leftd, upd, downd;
  BOOL rightold, leftold, upold, downold;

};



/* sub struct for hardness map */

struct mega_y
{

  byte y[401];

};



/* struct for hardness map */


struct hit_map
{

  struct mega_y x[601];

};



/* sub struct for tile hardness */


struct block_y
{

  byte y[51];

};



struct ts_block
{

  struct block_y x[51];
  BOOL_1BYTE used;
  int hold;

};



/* struct for hardness info, INDEX controls which hardness each block
   has. 800 max types available. */

struct hardness
{

  struct ts_block tile[800];
  int index[8000];

};



struct map_info
{

  char name[20];
  int loc[769];
  int music[769];
  int indoor[769];
  int v[40];
  char s[80];
  char buffer[2000];

};



struct tile
{

  int num, property, althard, more2;
  byte more3, more4;
  int buff[15];

};



struct sprite_placement
{

  int x, y, seq, frame, type, size;
  BOOL_1BYTE active;
  int rotation, special, brain;


  char script[13];
  char hit[13];
  char die[13];
  char talk[13];
  int speed, base_walk, base_idle, base_attack, base_hit, timer, que;
  int hard;
  struct rect alt;
  int prop;
  int warp_map;
  int warp_x;
  int warp_y;
  int parm_seq;

  int base_die, gold, hitpoints, strength, defense, exp, sound, vision, nohit,
    touch_damage;
  int buff[5];

};



struct small_map
{

  char name[20];
  struct tile t[97];
  int v[40];
  char s[80];
  struct sprite_placement sprite[101];

  char script[13];
  char random[13];
  char load[13];
  char buffer[1000];
};



struct sprite_index
{

  int x, y;
  int s;
  int last;

};



struct pic_info
{

  SDL_Surface *k; /* Sprites */
  struct rect box, hardbox;

  int yoffset;
  int xoffset;

};

#endif
