/* Copyright (C) 2022 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */

package org.gprofng.mpmt.overview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;

/**
 * @author tpreisle
 */
public class GradientPanel extends javax.swing.JPanel {
  private final Color color1 = Color.WHITE;
  private final Color color2 = new Color(235, 235, 235);
  private static final int height = 12;
  private boolean top;

  public GradientPanel(boolean top) {
    this.top = top;
    initComponents();
    setPreferredSize(new Dimension(height, height));
  }
  // @Override
  public void paint(Graphics g) {
    int width = getWidth();
    //        int height = getHeight();

    Graphics2D g2d = (Graphics2D) g;
    GradientPaint gp;
    if (top) {
      gp = new GradientPaint(0, 0, color2, 0, height, color1);
    } else {
      gp = new GradientPaint(0, 0, color1, 0, height, color2);
    }
    g2d.setPaint(gp);
    g2d.fillRect(0, 0, width, height);
    setOpaque(false);
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    setLayout(new java.awt.BorderLayout());
  } // </editor-fold>//GEN-END:initComponents
  // Variables declaration - do not modify//GEN-BEGIN:variables
  // End of variables declaration//GEN-END:variables
}
