/*  globalblob.h -- All the main routine globals in a struct */
/*
   Copyright (C) 2006 Jim Lowe
   All Rights Reserved.
  
   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef globalblob_h_200604
#define globalblob_h_200604

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "vplob.h"
#include "swlib.h"
#include "usgetopt.h"
#include "ugetopt_help.h"
#include "swparse.h"
#include "swfork.h"
#include "swgp.h"
#include "swssh.h"
#include "swcommon0.h"
#include "progressmeter.h"
#include "swevents.h"
#include "swicol.h"
#include "swutillib.h"
#include "xformat.h"

typedef struct {
	int 	g_stdout_testfd;
	int 	g_fail_loudly; 
	int 	g_verbose_threshold;  /* threshold for printing a message */ 
	int 	g_verboseG;      /* current set verbosity. */
	int 	g_signal_flag;   /* POSIX signal number */
	int 	g_t_efd;         /* file descriptor, target stderr */
	int 	g_s_efd;         /* file descriptor, source stderr */
	pid_t 	g_logger_pid;    /* pid_t of logger process */
	int 	g_swevent_fd;    /* file descriptor, read by the (SWI*) module */
	FILE * 	g_vstderr;
	pid_t 	g_pid_array[SWC_PID_ARRAY_LEN + SWC_PID_ARRAY_LEN];
	int 	g_status_array[SWC_PID_ARRAY_LEN];
	int 	g_targetfd_array[SWC_TARGET_FD_ARRAY_LEN];
	int 	g_selectfd_array[SWC_TARGET_FD_ARRAY_LEN];
	struct timespec g_io_req;
	SHCMD * g_target_kmd;
	SHCMD * g_source_kmd;
	SHCMD * g_killcmd;
	int 	g_pid_array_len;
	int 	g_nullfd;
	int 	g_stderr_fd;
	int * 	g_target_fdar;
	int * 	g_source_fdar;
	char * g_fork_pty;
	char * g_fork_pty2;
	char * g_fork_pty_none;
	sigset_t g_fork_defaultmask;
	sigset_t g_fork_blockmask;
	sigset_t g_currentmask;
	int 	g_do_progressmeter;
	struct sw_logspec g_logspec;
	int 	g_loglevel;
	int 	g_meter_fd;
	XFORMAT * g_xformat;
	int 	g_swi_event_fd;
	SWUTIL * g_swutil;
	struct g_pax_write_command * g_pax_write_commands;
	struct g_pax_read_command * g_pax_read_commands;
	char * g_source_script_name;
	char * g_target_script_name;
  	void (*g_main_sig_handler)(int signum);
  	void (*g_safe_sig_handler)(int signum);
	int g_is_seekable;
	int g_do_debug_events;
} GB;
	
GB * gb_create(void);
void gb_delete(GB*);
void gb_init(GB*);

#endif
