BEGIN;
SELECT _v.register_patch('exchange-0003', NULL, NULL);
SET search_path TO exchange;
ALTER TABLE wire_accounts
  ADD COLUMN priority INT8 NOT NULL DEFAULT (0),
  ADD COLUMN bank_label TEXT DEFAULT (NULL);
COMMENT ON COLUMN wire_accounts.priority
  IS 'priority determines the order in which wallets should display wire accounts';
COMMENT ON COLUMN wire_accounts.bank_label
  IS 'label to show in the selector for this bank account in the wallet UI';
CREATE FUNCTION constrain_table_purse_decision3(
  IN partition_suffix TEXT
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'purse_decision';
BEGIN
  table_name = concat_ws('_', table_name, partition_suffix);
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_purse_decision_purse_pub'
    ' UNIQUE (purse_pub) '
  );
END
$$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('purse_decision3'
    ,'exchange-0003'
    ,'constrain'
    ,TRUE
    ,FALSE);
COMMIT;
