BEGIN;
SELECT _v.register_patch('exchange-0004', NULL, NULL);
SET search_path TO exchange;
CREATE OR REPLACE FUNCTION constrain_table_kyc_attributes4(
  IN partition_suffix TEXT
)
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'kyc_attributes';
BEGIN
  table_name = concat_ws('_', table_name, partition_suffix);
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
      ' ADD CONSTRAINT ' || table_name || '_legitimization_serial '
        'UNIQUE (h_payto,legitimization_serial)'
  );
END $$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('kyc_attributes4'
    ,'exchange-0004'
    ,'constrain'
    ,TRUE
    ,FALSE);
CREATE FUNCTION alter_table_refresh4()
RETURNS VOID
LANGUAGE plpgsql
AS $$
BEGIN
  ALTER TABLE refresh
    ADD COLUMN revealed BOOLEAN NOT NULL DEFAULT(FALSE),
    ADD COLUMN transfer_pubs BYTEA[];
  COMMENT ON COLUMN refresh.revealed
    IS 'TRUE if the client has successfully revealed the secrets in the cut-and-choose step.';
  COMMENT ON COLUMN refresh.transfer_pubs
    IS 'The selected batch of transfer public keys, at noreveal_index';
END $$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('refresh4'
    ,'exchange-0004'
    ,'alter'
    ,TRUE
    ,FALSE);
COMMIT;
