#include "cronvalidator.h"


// -- class CronValidator implementation

CronValidator::CronValidator(int bottom, int top, QWidget *parent = 0, const char *name = 0)
 : QValidator(parent, name)
{
  b = bottom;
  t = top;
}

typedef enum {START, NUMBER, COMMA, MINUS, MINUS2, DIV, DIV2, ASTERIX} TState;

QValidator::State CronValidator::validate(QString &input, int &)
{
  TState      state = START;
  static bool error = FALSE;
  char        *str, ch;
  int         num = 0, prevNum = 0;

  if (input.isEmpty())
    return QValidator::Valid;

  if (input.length() == 1)
    error = FALSE;

  str = new char[input.length() + 1];
  strcpy(str, input.data());

  while ((ch = *str))
  {
    if (ch >= '0' && ch <= '9')
    {
      if (state == NUMBER || state == MINUS2 || state == DIV2 || state == ASTERIX)
        return QValidator::Invalid;

      num = 0;
      do
      {
        num = (num * 10) + ch - '0';
        ch = *(++str);
      }
      while (ch >= '0' && ch <= '9');

      if (num < b || num > t)
        return QValidator::Invalid;

      if (state == MINUS && num <= prevNum)
        error = TRUE;
      else
        error = FALSE;

      if (state == DIV && (num < 1 || num > t / 2))
        return QValidator::Invalid;

      if (state == MINUS)
        state = MINUS2;
      else if (state == DIV)
        state = DIV2;
      else state = NUMBER;

      continue;
    }
    else
      if (error == TRUE)
        return QValidator::Invalid;

    switch(ch)
    {
      case ',': if (state != NUMBER && state != MINUS2 && state != DIV2)
                  return QValidator::Invalid;
                state = COMMA;
                break;

      case '-': if (state != NUMBER)
                  return QValidator::Invalid;
                prevNum = num;
                state = MINUS;
                break;

      case '/': if (state != MINUS2 && state != ASTERIX)
                  return QValidator::Invalid;
                state = DIV;
                break;

      case '*': if (state != START && state != COMMA)
                  return QValidator::Invalid;
                state = ASTERIX;
                break;

      default : return QValidator::Invalid;
    }

    str++;
  }

  if (state == MINUS2 || state == DIV2)
    state = NUMBER;

  if ((state == NUMBER || state == ASTERIX) && error == FALSE)
    return QValidator::Acceptable;
  else
    return QValidator::Valid;
}
