#ifndef EDITVARIABLE_H
#define EDITVARIABLE_H

#include <kapp.h>
#include <klocale.h>

#include <qstrlist.h>

#include <qwidget.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qframe.h>
#include <qaccel.h>

#include "kheader.h"
#include "vartable.h"


// -- class EditVariable

class EditVariable : public QWidget
{
  Q_OBJECT
public:
  EditVariable(QWidget *parent = 0, const char *name = 0, QStrList *list = 0);
  virtual ~EditVariable();
signals:
  void onClose(bool);
protected slots:
  void slotSelected();

  void slotEdit();
  void slotRemove();

  void slotOk();
  void slotCancel();
  void slotHelp();
protected:
  KHeader	*header;
  VarTable	*variables;
  QLabel	*labVariable;
  QLineEdit	*leVariable;
  QLabel	*labValue;
  QLineEdit	*leValue;
  QPushButton	*pbEdit;
  QPushButton	*pbRemove;

  QFrame	*frButton;
  QPushButton	*pbOk;
  QPushButton	*pbCancel;
  QPushButton	*pbHelp;

  void closeEvent(QCloseEvent *);
private:
  QStrList	*intList;
  bool          changed;
};

#endif // EDITVARIABLE_H
