#ifndef KCRONTAB_H
#define KCRONTAB_H

#include <kapp.h>
#include <kconfig.h>
#include <ktopwidget.h>
#include <kiconloader.h>
#include <kstdaccel.h>

#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>

#include <qframe.h>
#include <qlayout.h>
#include <qkeycode.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qaccel.h>
#include <qtimer.h>

#include "editentry.h"
#include "crontable.h"
#include "editvariable.h"


#define WAIT 5000

// -- class KCrontab

class KCrontab: public KTopLevelWidget
{
  Q_OBJECT
public:
  KCrontab(const char *name = 0);
  ~KCrontab();
protected:
  KConfig	*config;
  KMenuBar	*menubar;
  KStatusBar	*statusbar;
  KToolBar	*toolbar;
  QAccel	*accel;
  KHeader	*khead;
 
  QPopupMenu	*file, *edit, *options, *help;
  QFrame	*frMain;
  QGridLayout	*mainLayout;
 
  EditEntry	*edEntry;
  CronTable	*crontable;

  QString	tmpFilePath;

  QStrList      variables;

  QTimer	*timer;

  void closeEvent(QCloseEvent *e);
protected slots:
  void slotNew();
  void slotRead();
  void slotReadSystem();
  void slotWrite();
  void slotExit();

  void slotAdd();
  void slotEdit();
  void slotRemove();
  void slotVariable();

  void slotToggleToolBar();
  void slotToggleStatusBar();
  void slotSaveSettings();

  void slotHelp();

  void slotNewEntry(CronRow *, bool);
  void slotVariableClose(bool);
  void slotClearStatusBar();
  void slotChangeState();
private:
  QString	user;
  QStrList	*userList;

  void setupMenuBar();
  void setupToolBar();
  void setupStatusBar();
  void setupAccelerators();
  void setupData();

  bool hide_toolbar;
  bool hide_statusbar;
  int  toolID, statID, writeID, toolbarID;
  bool changed;
  bool editVariables;

  bool  syscron;
  QFile fin;

  void  readCrontab(bool _syscron);
};

#endif KCRONTAB_H
