/***************************************************************************
                          kcmkeafnode2.cpp  -  description
                             -------------------
    begin                : Tue Aug 10 1999
    copyright            : (C) 1999 by Guenter Schwann
    email                : vogel@ibk.dyn.priv.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qwidget.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qstring.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qstrlist.h>
#include <qsize.h>
#include <qfont.h>

#include <kapp.h>
#include <kconfig.h>
#include <kfiledialog.h>

#include "kcmkeafnode.h"


KDEkeafConfig::KDEkeafConfig(Parser *p, QWidget *parent, const char *name)
    : KConfigWidget(parent, name)
{
 pars=p;
 QSize size;
 QFont qf;

    QVBoxLayout *top_lay = new QVBoxLayout(this, 10);

    top_lay->addStretch(1);

    QHBoxLayout *h1_lay = new QHBoxLayout();
    top_lay->addLayout(h1_lay);

    h1_lay->addStretch(3);
    QLabel *lbl = new QLabel(i18n("config file"), this);
    lbl->setFixedSize(lbl->sizeHint());
    h1_lay->addWidget(lbl);

    cfile = new QLineEdit(this);
    cfile->setText("/var/blabla/spool/leafnode/config");
    size=cfile->sizeHint();
    size.setWidth(size.width()+80);
    cfile->setFixedSize(size);
    cfile->setText("");
    qf=cfile->font();
    qf.setBold(true);
    cfile->setFont(qf);
    h1_lay->addWidget(cfile);
    h1_lay->addStretch(1);

    searchcf = new QPushButton(this,"scf");
    searchcf->setPixmap(Icon("fileopen.xpm"));
    size.setWidth(28);
    size.setHeight(28);
    searchcf->setFixedSize(size);
    h1_lay->addWidget(searchcf);
    connect( searchcf, SIGNAL(clicked()), this, SLOT(sCFile()));
    h1_lay->addStretch(4);

    top_lay->addStretch(3);

    QHBoxLayout *h2_lay = new QHBoxLayout();
    top_lay->addLayout(h2_lay);

    h2_lay->addStretch(1);
    QLabel *lbl2 = new QLabel(i18n("Server"), this);
    lbl2->setFixedSize(lbl2->sizeHint());
    h2_lay->addWidget(lbl2);

    serverd = new QComboBox(FALSE,this);
    size=serverd->sizeHint();
    size.setWidth(size.width()+80);
    serverd->setFixedSize(size);
    serverd->clear();
    h2_lay->addWidget(serverd);
    h2_lay->addStretch(1);
    connect(serverd, SIGNAL(activated(int)), this, SLOT(setActual(int)) );

    newserver = new QPushButton(this,"new");
    newserver->setText("new");
    newserver->setFixedSize(newserver->sizeHint());
    h2_lay->addWidget(newserver);
    h2_lay->addStretch(1);
    connect( newserver, SIGNAL(clicked()), this, SLOT(addNewServer()));

    delserver = new QPushButton(this,"delete");
    delserver->setText("delete");
    delserver->setFixedSize(delserver->sizeHint());
    h2_lay->addWidget(delserver);
    h2_lay->addStretch(1);
    connect( delserver, SIGNAL(clicked()), this, SLOT(delThisServer()));

    top_lay->addStretch(1);

    QHBoxLayout *h22_lay = new QHBoxLayout();
    top_lay->addLayout(h22_lay);

    h22_lay->addStretch(1);
    QLabel *lbl22 = new QLabel(i18n("Servername"), this);
    lbl22->setFixedSize(lbl22->sizeHint());
    h22_lay->addWidget(lbl22);

    sname = new QLineEdit(this);
    size=sname->sizeHint();
    size.setWidth(size.width()+80);
    sname->setFixedSize(size);
    qf=sname->font();
    qf.setBold(true);
    sname->setFont(qf);
    connect( sname, SIGNAL( textChanged(const char*)), this, SLOT(newServerName()) );
    h22_lay->addWidget(sname);
    h22_lay->addStretch(1);


    top_lay->addStretch(1);

    QHBoxLayout *h3_lay = new QHBoxLayout();
    top_lay->addLayout(h3_lay);

    h3_lay->addStretch(1);
    QLabel *lbl3 = new QLabel(i18n("Port"), this);
    lbl3->setFixedSize(lbl3->sizeHint());
    h3_lay->addWidget(lbl3);

    port = new KIntegerLine(this);
    port->setValue(8000);
    port->setFixedSize(port->sizeHint());
    port->setValue(119);
    h3_lay->addWidget(port);
    h3_lay->addStretch(10);

    top_lay->addStretch(1);

    QHBoxLayout *h4_lay = new QHBoxLayout();
    top_lay->addLayout(h4_lay);

    h4_lay->addStretch(1);
    QLabel *lbl4 = new QLabel(i18n("Username"), this);
    lbl4->setFixedSize(lbl4->sizeHint());
    h4_lay->addWidget(lbl4);

    user = new QLineEdit(this);
    user->setText("dfgsdfgsdfg.dsfgsdfgsfdg");
    user->setFixedSize(user->sizeHint());
    user->setText("");
    h4_lay->addWidget(user);
    h4_lay->addStretch(2);

    h4_lay->addStretch(1);
    QLabel *lbl42 = new QLabel(i18n("Password"), this);
    lbl42->setFixedSize(lbl42->sizeHint());
    h4_lay->addWidget(lbl42);

    pass = new QLineEdit(this);
    pass->setEchoMode(QLineEdit::Password);
    pass->setText("very-secret.pass");
    pass->setFixedSize(pass->sizeHint());
    pass->setText("");
    h4_lay->addWidget(pass);
    h4_lay->addStretch(3);

    top_lay->addStretch(1);

    QHBoxLayout *h5_lay = new QHBoxLayout();
    top_lay->addLayout(h5_lay);

    h5_lay->addStretch(1);
    nodes = new QCheckBox(this);
    nodes->setFixedSize(nodes->sizeHint());
    nodes->setChecked(false);
    h5_lay->addWidget(nodes);

    QLabel *lbl5 = new QLabel(i18n("No description"), this);
    lbl5->setFixedSize(lbl5->sizeHint());
    h5_lay->addWidget(lbl5);
    h5_lay->addStretch(10);

    top_lay->addStretch(1);

    QHBoxLayout *h6_lay = new QHBoxLayout();
    top_lay->addLayout(h6_lay);

    h6_lay->addStretch(1);
    QLabel *lbl6 = new QLabel(i18n("Timeout"), this);
    lbl6->setFixedSize(lbl6->sizeHint());
    h6_lay->addWidget(lbl6);

    tout = new KIntegerLine(this);
    tout->setValue(8000);
    tout->setFixedSize(tout->sizeHint());
    tout->setValue(10);
    h6_lay->addWidget(tout);
    h6_lay->addStretch(10);

    top_lay->addStretch(3);

    QHBoxLayout *h7_lay = new QHBoxLayout();
    top_lay->addLayout(h7_lay);

    h7_lay->addStretch(3);
    QLabel *lbl7 = new QLabel(i18n("Expire"), this);
    lbl7->setFixedSize(lbl7->sizeHint());
    h7_lay->addWidget(lbl7);

    expire = new KIntegerLine(this);
    expire->setValue(500);
    expire->setFixedSize(expire->sizeHint());
    expire->setValue(14);
    qf=expire->font();
    qf.setBold(true);
    expire->setFont(qf);
    h7_lay->addWidget(expire);
    h7_lay->addStretch(8);


    top_lay->addStretch(2);

    loadSettings();
}


KDEkeafConfig::~KDEkeafConfig()
{
}

void KDEkeafConfig::loadSettings()
{
  int i;

  conf_file=pars->CFileName();

   expire_time=pars->ExpireTime();

   actual=0;

   for (i=0;i<10;i++)
   {
    serv[i]=pars->getServer(i);
    if (serv[i].name()!="") serverd->insertItem(serv[i].name());
   }

   if (serv[1].name()=="") delserver->setEnabled(false);
   if (serv[9].name()!="") newserver->setEnabled(false);

   actual=0;
   serverd->setCurrentItem(actual);

   updateSettings();
}


void KDEkeafConfig::applySettings()
{
 FILE *f;
 QString s;
 int i=0;

 fetchData();
 pars->setCFileName(conf_file);

 s="mv "+conf_file+" "+conf_file+"~";

 system(s.data());

 if ((f=fopen(conf_file.data(),"w"))!=0)
 {
  fprintf(f,"## This config-file was written by keafnode\n\n");
  fprintf(f,"## This is the NNTP server leafnode fetches its news from.\n");
  fprintf(f,"## You need read and post access to it. Mandatory.\n");
  s="server = "+serv[i].name()+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## Unread discussion threads will be deleted after this many days if\n");
  fprintf(f,"## you don't define special expire times. Mandatory.\n");
  s="expire = "+s.setNum(expire_time)+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n##\n## All the following parameters are optional\n##\n");

  fprintf(f,"\n## I have free access to my news server. If you don't have, comment out\n");
  fprintf(f,"## the following two lines and change them accordingly.\n");
  if (serv[i].user()=="") s="#username =\n";
  else s="username = "+serv[i].user()+"\n";
  fprintf(f,s.data());
  if (serv[i].passwd()=="") s="#password =\n";
  else s="password = "+serv[i].passwd()+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n## Standard news servers run on port 119. If your newsserver doesn't, comment\n");
  fprintf(f,"## out the following line and change it accordingly.\n");
  if (serv[i].port()==119) s="#port = 8000\n";
  else s="port = "+s.setNum(serv[i].port())+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n##Set higher timeout for slow servers.\n");
  if (serv[i].timeout()==10) s="#timeout = 10\n";
  else s="timeout = "+s.setNum(serv[i].timeout())+"\n";
  fprintf(f,s.data());

  fprintf(f,"\n##Don't fetch the newsgroup descriptions.\n");
  if (serv[i].nodesc()==false) s="#nodesc = 1\n";
  else s="nodesc = 1\n";
  fprintf(f,s.data());

// more servers
  i++;
  while (i<10)
  {
   if (serv[i].name()!="")
   {
    fprintf(f,"\n## This is another news server\n");
    s="supplement = "+serv[i].name()+"\n";
    fprintf(f,s.data());
    s="";
    if (serv[i].user()!="") s="username = "+serv[i].user()+"\n";
    fprintf(f,s.data());
    s="";
    if (serv[i].passwd()!="") s="password = "+serv[i].passwd()+"\n";
    fprintf(f,s.data());
    s="";
    if (serv[i].port()!=119) s="port = "+s.setNum(serv[i].port())+"\n";
    fprintf(f,s.data());
    s="";
    if ((serv[i].timeout()!=10)&&(serv[i].timeout()!=0))
     s="timeout = "+s.setNum(serv[i].timeout())+"\n";
    fprintf(f,s.data());
    s="";
    if (serv[i].nodesc()==true) s="nodesc = 1\n";
    fprintf(f,s.data());
   }
   i++;
  }


  fclose(f);
 }
 else printf("Error opening file!");
}

void KDEkeafConfig::defaultSettings()
{
}

void KDEkeafConfig::updateSettings()
{
 cfile->setText(conf_file);
 expire->setValue(expire_time);
 displayData();
}

void KDEkeafConfig::fetchData()
{
 conf_file=cfile->text();
 expire_time=expire->value();

 serv[actual].setName(sname->text());
 serv[actual].setPort(port->value());
 serv[actual].setUser(user->text());
 serv[actual].setPasswd(pass->text());
 serv[actual].setNodesc(nodes->isChecked());
 serv[actual].setTimeout(tout->value());


}

void KDEkeafConfig::addNewServer()
{
  fetchData();
  serverd->insertItem("new.news.server",serverd->count());
  actual=serverd->count()-1;
  serverd->setCurrentItem(actual);

  serv[actual].setName("new.news.server");
  serv[actual].setUser("");
  serv[actual].setPasswd("");
  serv[actual].setPort(119);
  serv[actual].setTimeout(10);
  serv[actual].setNodesc(false);
  displayData();
  if (serverd->count()==10) newserver->setEnabled(false);
  delserver->setEnabled(true);
}

void KDEkeafConfig::delThisServer()
{
 int i;

 serverd->removeItem(actual);
 for (i=actual;i<9;i++) serv[i]=serv[i+1];
 if (serv[actual].name()=="") actual--;
 displayData();
 if (serverd->count()==1) delserver->setEnabled(false);
 newserver->setEnabled(true);
}

void KDEkeafConfig::displayData()
{
 sname->setText(serv[actual].name());
 serverd->setCurrentItem(actual);
 user->setText(serv[actual].user());
 pass->setText(serv[actual].passwd());
 port->setValue(serv[actual].port());
 tout->setValue(serv[actual].timeout());
 nodes->setChecked(serv[actual].nodesc());
}

void KDEkeafConfig::setActual(int i)
{
 fetchData();
 actual=i;
 QString s;
 s.setNum(i);
 displayData();
}

void KDEkeafConfig::newServerName()
{
 serverd->changeItem(sname->text(),actual);
 serverd->update();
}


void KDEkeafConfig::sCFile()
{
 QString fn=KFileDialog::getOpenFileName();
 if (!fn.isNull())
 {
  conf_file=fn;
  cfile->setText(fn.data());
  pars->setCFileName(conf_file);
 }
}


