/***************************************************************************
                          kcmkeafnode.h  -  description                              
                             -------------------                                         
    begin                : Tue Aug 10 1999                                           
    copyright            : (C) 1999 by Guenter Schwann                         
    email                : vogel@ibk.dyn.priv.at                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef __Kcmkeafnode_h_included__
#define __Kcmkeafnode_h_included__

#include <qpushbutton.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qsize.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qcombobox.h>

#include <kcontrol.h>
#include <kapp.h>
#include <kconfig.h>
#include <kintegerline.h>
#include <kiconloader.h>

#include "server.h"
#include "parser.h"

class KDEkeafConfig : public KConfigWidget
{
    Q_OBJECT

public:
    KDEkeafConfig(Parser *p, QWidget *parent=0, const char *name=0);
    ~KDEkeafConfig();

public slots:
    void loadSettings();
    void applySettings();
    void defaultSettings();
    void updateSettings();

private slots:
  void fetchData();
  void addNewServer();
  void displayData();
  void setActual(int i);
  void newServerName();
  void delThisServer();
  void sCFile();

private:
  QLineEdit *cfile;
  QComboBox *serverd;
  QLineEdit *sname;
  KIntegerLine *port;
  QLineEdit *user;
  QLineEdit *pass;
  QCheckBox *nodes;
  KIntegerLine *tout;
  KIntegerLine *expire;
  QPushButton *newserver;
  QPushButton *delserver;
  QPushButton *searchcf;

  QString conf_file;
  int expire_time;
  server serv[10];
  int actual;

  Parser *pars;

};


#endif