/***************************************************************************
                          dlgpermissions.cpp  -  description
                             -------------------
    begin                : Wed Oct 20 1999
    copyright            : (C) 1999 by Rene Mrten, Christian Fricke
                           und Torsten Enkelmann
    email                : @-Mail to: delta_x@LinuxCoding.DE
                                      cfricke@LinuxCoding.DE
                                      Torsten@LinuxCoding.DE
****************************************************************************/

#include "dlgpermissions.h"
#include <sys/stat.h>

dlgPermissions::dlgPermissions(listView *lv, QWidget *parent, const char *name) : QDialog(parent,name,true){
	
	globalPermissions = 0;
	listview = lv;
	initDialog();
	getNextPermission();
}

void dlgPermissions::getNextPermission()
{
	if(listview->itemsSelected() == 0)
	{
		// beim ersten Aufruf den SetAll Button ausser Kraft setzen
		QPushButton_1->setEnabled(false);
		QString fname;
		fname = *listview->lastItemClicked->text[0];
		if(fname == "..")
		{
			accept2();	// sollte kein file mehr markiert sein, wird der focus
							// auf das ".." gesetzt !
			return;
		}
		showPermissions(fname);
		listview->lastItemClicked = listview->Liste;
		listview->refreshListview();
		return;	
	}

	// hier kommt er nur hin, wenn files selektiert wurden
	QString fname;
	listItem *li = listview->Liste;
	// nach dem ersten selektiertem Eintrag suchen
	while(li != 0)
	{
		if(li->selected)
		{
			// wurde gefunden, Selektion aufheben
			li->selected = false;
			fname = *li->text[0];
			listview->refreshListview();
			if(listview->itemsSelected() == 0)
			{
				listview->lastItemClicked = listview->Liste;
				listview->refreshListview();
			}
			showPermissions(fname);
			return;
		}
		li = li->next;
	}
	// wenn er hierher kommt, so ist kein File mehr selektiert
	// aber er kommt hier nicht hin !
	accept2();		
}

void dlgPermissions::showPermissions(QString fname)
{
	
	QFileInfo fi(listview->dirPath + fname);
	aktFile = listview->dirPath + fname;
	infoLabel[0]->setText(fname);
	infoLabel[2]->setText(fi.owner());
	infoLabel[3]->setText(fi.group());
	
	struct stat sBuffer;
	int i;
	i = stat(listview->dirPath + fname,&sBuffer);
	int permissions = sBuffer.st_mode;
	globalPermissions = permissions;
	filePermissions = permissions;	// diese werden NICHT gendert
	QString s;
	s.sprintf("Oktal: %o",permissions);
	infoLabel[1]->setText(s);
  	QCheckBoxes[3]->setChecked(permissions &  QFileInfo::ReadUser );
  	QCheckBoxes[4]->setChecked(permissions & QFileInfo::WriteUser );
  	QCheckBoxes[5]->setChecked(permissions & QFileInfo::ExeUser );
  	QCheckBoxes[6]->setChecked(permissions & QFileInfo::ReadGroup );
  	QCheckBoxes[7]->setChecked(permissions & QFileInfo::WriteGroup );
  	QCheckBoxes[8]->setChecked(permissions & QFileInfo::ExeGroup );
  	QCheckBoxes[9]->setChecked(permissions & QFileInfo::ReadOther );
  	QCheckBoxes[10]->setChecked(permissions & QFileInfo::WriteOther );
  	QCheckBoxes[11]->setChecked(permissions & QFileInfo::ExeOther );
}
/*
struct stat
  {
    __dev_t 				st_dev;			/ Device
    unsigned short int __pad1;
    __ino_t st_ino;			/ File serial number./
    __mode_t st_mode;			/ File mode.  /
    __nlink_t st_nlink;			/ Link count.  /
    __uid_t st_uid;			/ User ID of the file's owner.	/
    __gid_t st_gid;			/ Group ID of the file's group./
    __dev_t st_rdev;			/ Device number, if device.  /
    unsigned short int __pad2;
    __off_t st_size;			/ Size of file, in bytes.  /
    unsigned long int st_blksize;	/ Optimal block size for I/O.  /
#define	_STATBUF_ST_BLKSIZE		/ Tell code we have this member.  /

    unsigned long int st_blocks;	/ Number of 512-byte blocks allocated.  /
    __time_t st_atime;			/ Time of last access.  /
    unsigned long int __unused1;
    __time_t st_mtime;			/ Time of last modification.  /
    unsigned long int __unused2;
    __time_t st_ctime;			/ Time of last status change.  /
    unsigned long int __unused3;
    unsigned long int __unused4;
    unsigned long int __unused5;
  };
*/
	
	
	
	
	



dlgPermissions::~dlgPermissions(){
}

void  dlgPermissions::initDialog(){
  resize(580,480);
  setMinimumSize(580,480);
  setMaximumSize(580,480);

  QCheckBoxes[0]= new QCheckBox(this);
  QCheckBoxes[0]->setGeometry(30,20,500,20);
  QCheckBoxes[0]->setText(i18n("Set User ID On Execution"));

  QCheckBoxes[1]= new QCheckBox(this);
  QCheckBoxes[1]->setGeometry(30,50,500,20);
  QCheckBoxes[1]->setText(i18n("Set Group ID on Execution"));

  QCheckBoxes[2]= new QCheckBox(this);
  QCheckBoxes[2]->setGeometry(30,80,500,20);
  QCheckBoxes[2]->setText(i18n("Sticky Bit"));

  QCheckBoxes[3]= new QCheckBox(this);
  QCheckBoxes[3]->setGeometry(30,110,500,20);
  QCheckBoxes[3]->setText(i18n("Read By Owner"));

  QCheckBoxes[4]= new QCheckBox(this);
  QCheckBoxes[4]->setGeometry(30,140,500,20);
  QCheckBoxes[4]->setText(i18n("Write By Owner"));

  QCheckBoxes[5]= new QCheckBox(this);
  QCheckBoxes[5]->setGeometry(30,170,500,20);
  QCheckBoxes[5]->setText(i18n("Execute By Owner"));

  QCheckBoxes[6]= new QCheckBox(this);
  QCheckBoxes[6]->setGeometry(30,200,500,20);
  QCheckBoxes[6]->setText(i18n("Read By Group"));

  QCheckBoxes[7]= new QCheckBox(this);
  QCheckBoxes[7]->setGeometry(30,230,500,20);
  QCheckBoxes[7]->setText(i18n("Write By Group"));

  QCheckBoxes[8]= new QCheckBox(this);
  QCheckBoxes[8]->setGeometry(30,260,500,20);
  QCheckBoxes[8]->setText(i18n("Execute By Group"));

  QCheckBoxes[9]= new QCheckBox(this);
  QCheckBoxes[9]->setGeometry(30,290,500,20);
  QCheckBoxes[9]->setText(i18n("Read By Others"));

  QCheckBoxes[10]= new QCheckBox(this);
  QCheckBoxes[10]->setGeometry(30,320,500,20);
  QCheckBoxes[10]->setText(i18n("Write By Others"));

  QCheckBoxes[11]= new QCheckBox(this);
  QCheckBoxes[11]->setGeometry(30,350,500,20);
  QCheckBoxes[11]->setText(i18n("Execute By Others"));

  for(int i=0;i<12;i++)
	  connect(QCheckBoxes[i],SIGNAL(clicked()),SLOT(checkClicked()));


  QGroupBox *gb = new QGroupBox(i18n("[  Information  ]"),this);
  gb->setGeometry(250,20,300,350);

	QFont fnt2("Helvetica", 16);
	fnt2.setUnderline(true);
	fnt2.setItalic(true);
	QLabel *lb = new QLabel(i18n("Filename:"),gb);
	lb->setFont(fnt2);	
	lb->setGeometry(QRect(QPoint(10,20),lb->sizeHint()));
	
	lb = new QLabel(i18n("Permissions:"),gb);
	lb->setFont(fnt2);	
	lb->setGeometry(QRect(QPoint(10,80),lb->sizeHint()));
	
	lb = new QLabel(i18n("Owner:"),gb);
	lb->setFont(fnt2);	
	lb->setGeometry(QRect(QPoint(10,140),lb->sizeHint()));
	
	lb = new QLabel(i18n("Group:"),gb);
	lb->setFont(fnt2);	
	lb->setGeometry(QRect(QPoint(10,200),lb->sizeHint()));

	QFont fnt("Helvetica", 14, QFont::Bold);
	
	infoLabel[0] = new QLabel("Platzhalter",gb);
	infoLabel[0]->setGeometry(10,50,250,20);
	infoLabel[1] = new QLabel("Platzhalter",gb);
	infoLabel[1]->setGeometry(10,110,250,20);
	infoLabel[2] = new QLabel("Platzhalter",gb);
	infoLabel[2]->setGeometry(10,170,250,20);
	infoLabel[3] = new QLabel("Platzhalter",gb);
	infoLabel[3]->setGeometry(10,230,250,20);
	
	infoLabel[0]->setFont(fnt);
	infoLabel[1]->setFont(fnt);
	infoLabel[2]->setFont(fnt);
	infoLabel[3]->setFont(fnt);


  	QPushButton_1= new QPushButton(this);
  	QPushButton_1->setGeometry(30,390,160,30);
  	QPushButton_1->setMinimumSize(0,0);
  	QPushButton_1->setText(i18n("Set &All"));

  	QPushButton_3= new QPushButton(this);
  	QPushButton_3->setGeometry(390,390,160,30);
  	QPushButton_3->setMinimumSize(0,0);
  	QPushButton_3->setText(i18n("S&et Marked"));

  	QPushButton_4= new QPushButton(this);
  	QPushButton_4->setGeometry(30,430,160,30);
  	QPushButton_4->setMinimumSize(0,0);
  	QPushButton_4->setText(i18n("&Clear Marked"));

  	QPushButton_5= new QPushButton(this);
  	QPushButton_5->setGeometry(210,430,160,30);
  	QPushButton_5->setMinimumSize(0,0);
  	QPushButton_5->setText(i18n("&Set"));

  	QPushButton_6= new QPushButton(this);
  	QPushButton_6->setGeometry(390,430,160,30);
  	QPushButton_6->setMinimumSize(0,0);
  	QPushButton_6->setText(i18n("&Cancel"));

	connect(QPushButton_1,SIGNAL(clicked()),SLOT(setAllClicked()));
	connect(QPushButton_3,SIGNAL(clicked()),SLOT(setMarkedClicked()));
	connect(QPushButton_4,SIGNAL(clicked()),SLOT(clearMarkedClicked()));
	connect(QPushButton_5,SIGNAL(clicked()),SLOT(setClicked()));
	connect(QPushButton_6,SIGNAL(clicked()),SLOT(reject()));

}


void dlgPermissions::checkClicked()
{
	int permissions = 040000;
	for(int i=0;i<12;i++)
		switch(i)
		{
			case 0:
				if(QCheckBoxes[i]->isChecked())
					permissions += 04000;
				break;
			case 1:
				if(QCheckBoxes[i]->isChecked())
					permissions += 02000;
				break;
			case 2:
				if(QCheckBoxes[i]->isChecked())
					permissions += 01000;
				break;
			case 3:
				if(QCheckBoxes[i]->isChecked())
					permissions += 0400;
				break;
			case 4:
				if(QCheckBoxes[i]->isChecked())
					permissions += 0200;
				break;
			case 5:
				if(QCheckBoxes[i]->isChecked())
					permissions += 0100;
				break;
			case 6:
				if(QCheckBoxes[i]->isChecked())
					permissions += 0040;
				break;
			case 7:
				if(QCheckBoxes[i]->isChecked())
					permissions += 0020;
				break;
			case 8:
				if(QCheckBoxes[i]->isChecked())
					permissions += 0010;
				break;
			case 9:
				if(QCheckBoxes[i]->isChecked())
					permissions += 0004;
				break;
			case 10:
				if(QCheckBoxes[i]->isChecked())
					permissions += 0002;
				break;
			case 11:
				if(QCheckBoxes[i]->isChecked())
					permissions += 0001;
				break;
		};
	QString s;
	s.sprintf("Oktal: %o",permissions);
	infoLabel[1]->setText(s);
	globalPermissions = permissions;
		
}

void	dlgPermissions::setAllClicked()
{
	int global = globalPermissions;		// globalPermissions wird wieder berschrieben, deshalb retten !
	
	chmod(aktFile,global);

	
	while(listview->itemsSelected() != 0)
	{
//		getNextPermission();
		listItem *li = listview->Liste;
		while(!li->selected)
		{
			li = li->next;
		}
		li->selected = false;
		aktFile = listview->dirPath + *li->text[0];
		kapp->processEvents();
		chmod(aktFile,global);
	}
	accept2();
}
void	dlgPermissions::setMarkedClicked()
{
	int org = filePermissions;
	for(int i=0;i<12;i++)
		switch(i)
		{
			case 0:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 04000)) org += 04000;
				break;
			case 1:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 02000)) org += 02000;
				break;
			case 2:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 01000)) org += 01000;
				break;
			case 3:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 0400)) org += 0400;
				break;
			case 4:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 0200)) org += 0200;
				break;
			case 5:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 0100)) org += 0100;
				break;
			case 6:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 040)) org += 040;
				break;
			case 7:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 020)) org += 020;
				break;
			case 8:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 010)) org += 010;
				break;
			case 9:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 04)) org += 04;
				break;
			case 10:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 02)) org += 02;
				break;
			case 11:
				if(QCheckBoxes[i]->isChecked())
					if(!(org & 01)) org += 01;
				break;
		};
	chmod(aktFile,org);		// 100% !!
	getNextPermission();	

}
void	dlgPermissions::clearMarkedClicked()
{
	int org = filePermissions;
	for(int i=0;i<12;i++)
		switch(i)
		{
			case 0:
				if(QCheckBoxes[i]->isChecked())
					if(org & 04000) org -= 04000;
				break;
			case 1:
				if(QCheckBoxes[i]->isChecked())
					if(org & 02000) org -= 02000;
				break;
			case 2:
				if(QCheckBoxes[i]->isChecked())
					if(org & 01000) org -= 01000;
				break;
			case 3:
				if(QCheckBoxes[i]->isChecked())
					if(org & 0400) org -= 0400;
				break;
			case 4:
				if(QCheckBoxes[i]->isChecked())
					if(org & 0200) org -= 0200;
				break;
			case 5:
				if(QCheckBoxes[i]->isChecked())
					if(org & 0100) org -= 0100;
				break;
			case 6:
				if(QCheckBoxes[i]->isChecked())
					if(org & 040) org -= 040;
				break;
			case 7:
				if(QCheckBoxes[i]->isChecked())
					if(org & 020) org -= 020;
				break;
			case 8:
				if(QCheckBoxes[i]->isChecked())
					if(org & 010) org -= 010;
				break;
			case 9:
				if(QCheckBoxes[i]->isChecked())
					if(org & 04) org -= 04;
				break;
			case 10:
				if(QCheckBoxes[i]->isChecked())
					if(org & 02) org -= 02;
				break;
			case 11:
				if(QCheckBoxes[i]->isChecked())
					if(org & 01) org -= 01;
				break;
		};
	chmod(aktFile,org);		// 100% !!
	getNextPermission();	

}
void	dlgPermissions::setClicked()
{
	chmod(aktFile,globalPermissions);
	getNextPermission();	
}


void dlgPermissions::accept2()
{
	QString s(listview->dirPath);
	listview->readDir(s);
	accept();
}

