/***************************************************************************
 *
 *  Copyright (C) 1998 Neil Hart (nhart@magma.ca)
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Id: kprintadmin.h,v 1.4 1998/04/24 17:14:04 nhart Exp $
 *                                                                   
 ***************************************************************************/

#ifndef __KPRINTADMIN_H__
#define __KPRINTADMIN_H__

#include "kfiledir.h"
#include "kprintadd.h"

#include <qdialog.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qbttngrp.h>
#include <qlined.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qchkbox.h>

#include <kapp.h>
#include <kcontrol.h>

class KPrinterApplication;

class KPrinterAdmin : public KConfigWidget 
{
	Q_OBJECT
public:
	KPrinterAdmin ( KPrinterApplication* k, QWidget* parent=0, const char* name=0, bool init=FALSE );
	~KPrinterAdmin ();
	void loadSettings ();
	void applySettings ();

private slots:

	void addLocalPrinter();
	void addRemotePrinter();
	void editPrinter();
	void removePrinter();

private:

	QListBox* printerListBox;

	QPushButton* addLocalButton;
	QPushButton* addRemoteButton;
	QPushButton* editButton;
	QPushButton* removeButton;

	KPrinterApplication* kpa;

	void refreshPrinterListBox();

};

#endif
