/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   
#ifndef KDIFFTOPLEVEL_H
#define KDIFFTOPLEVEL_H

#include "kdiff.h"

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <kfm.h>
#include <kapp.h>
#include <ktopwidget.h>
#include <klocale.h>
#include <kconfig.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kurl.h>

#include <qscrbar.h>
#include <qframe.h>
#include <qgrpbox.h> 
#include <qfont.h>

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "kdiff.h"
#include "kdiffDisplay.h"


/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/ 

class KdiffTopLevel: public KTopLevelWidget
{
  Q_OBJECT;

public:
  KdiffTopLevel( KApplication *thisAppl, KLocale *thisLocation, const char *name=0 );
  ~KdiffTopLevel();

  void setBusy( bool busy );

protected:


public slots:

  void openLeft();                                // Open first file ( left window )
  void openRight();                               // Open second file ( right window )
  void quitDiff();                                // Quit the application
  
  void doDiff();                                  // Execute the diff - command
  void prevDiff();                                // show previous difference
  void nextDiff();                                // show next difference

  void selDiffFont();
  void selDiffColors();
  void showLineNr();
  void writeKDiffConfig();

  void helpContents();                            // Call KDE-Help 
  void helpIndex();    
  void helpAbout();                               // Show About Dialog


  void displayPaletteChanged();                   // Signal from KApplication


  void leftDropEvent( KDNDDropZone *dropZone );   // get file from kfm
  void rightDropEvent( KDNDDropZone *dropZone );  // get file from kfm
  void slotLeftKFMJobDone();                      // get file done
  void slotRightKFMJobDone();                     // get file done
 
  void slotProgressState( int percent );

private:

  KApplication     *application;
  KLocale          *locale;
  KConfig          *config;
     QColor        insertColorCfg, changeColorCfg, deleteColorCfg;
     QString       showLineCfg;
     QFont         drawFontCfg;

  // Toplevel-Widget-Items
  KMenuBar         *menuBar;
    QPopupMenu       *filePm;
    QPopupMenu       *diffPm;
    QPopupMenu       *optionPm;
    QPopupMenu       *helpPm;
  KToolBar         *toolBar;

  QFrame           *mainView;
  QGroupBox        *grBox;
  kdiffDisplay     *diffDisplay;
    
  KStatusBar       *statusBar;

  // Menubar and Toolbar ID's
  int doDiffID, prevDiffID, nextDiffID;
  int showLineNrID;


  KURL *leftKurl;
  KURL *rightKurl;
  QString lastPath;  
    
  // KFM-Communication
  KFM          *leftKfmConnection;
  const char   *leftUrl;
  KFM          *rightKfmConnection;
  const char   *rightUrl;


  // the Difference - Class
  KDiff *differences;


  void setSensitive();
  void setBoxTitle();
  
 
protected:
  virtual void closeEvent( QCloseEvent *e );
  virtual void resizeEvent( QResizeEvent *e );


};



#endif
