/***************************************************************************
                          settingsdialog.cpp  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999 by Torsten Uhlmann
    email                : TUhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmsgmodem.h"
#include "settingsdialog.h"

SettingsDialog::SettingsDialog(KMsgModemConfigurator config) :	QDialog(0, i18n("Application settings"), true)
{
	initDialog();
	connect(okButton,SIGNAL(clicked()), this, SLOT(accept()));
	connect(cancelButton,SIGNAL(clicked()), this, SLOT(reject()));
	
	// set correct item
	int bIdx = 0;
	switch (config.baudrate.toInt())
	{
		case 2400  	: bIdx = 0; break;
		case 4800  	: bIdx = 1; break;
		case 9600  	: bIdx = 2; break;
		case 19200 	: bIdx = 3; break;
		case 38400 	: bIdx = 4; break;
		case 57600 	: bIdx = 5; break;
		case 115200 : bIdx = 6; break;
		case 230400 : bIdx = 7; break;
	}
	serialDevice->setText( config.serialLine );
	audioDevice->setText( config.audioDevice );
	voiceProcessor->setText( config.voiceProcessor );
	faxViewer->setText( config.faxViewer );
	baudrate->setCurrentItem(bIdx);
	defaultEMail->setText( config.defaultEMail );
	printCommand->setText( config.printCommand );
	mailCommand->setText( config.mailCommand );
	wav2gsmCommand->setText( config.wav2gsmCommand );
}


SettingsDialog::~SettingsDialog(){
}
