/***************************************************************************
                          kbearftpview.cpp  -  description
                             -------------------
    Begin                : Fri Jun 2 2000
    Copyright            : (C) 2000 by Bjrn Sahlstrm
    Email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/********************************************************************************
 *																															*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version.																*
 *																															*
 *********************************************************************************/
#include "kbear.h"
#include "kbeardiroperator.h"
#include "kfilednddetailview.h"
#include "kfiledndiconview.h"
#include "kbearftpview.h"
//-----------------------------------------------
KBearFtpView::KBearFtpView( KBear* app, QWidget* parent, QString name )
	: QextMdiChildView( name, parent, name ), myKBearApp( app )
{
	// GUI stuff
	setup();
	setIcon( KApplication::kApplication()->miniIcon() );
	
	connect( dirOperator,SIGNAL( finishedLoading()), this,SLOT( slotFinishedLoading()));	
	connect( dirOperator->fileReader(),SIGNAL(started( const QString&)), this,SLOT( slotStartLoadingDir()));	
	connect( dirOperator,SIGNAL(showTreeView( bool )), this,SLOT( slotToggleTreeView( bool )));	
	connect( dirOperator, SIGNAL( updateInformation( int, int ) ), this, SLOT( slotUpdateDirsAndFiles( int, int ) ) );
	connect( dirOperator, SIGNAL( urlEntered (const KURL& ) ), this, SLOT( slotSetPathCombo(const KURL& ) ) );
	connect( dirOperator, SIGNAL( rereadDir( QString ) ), leftView, SLOT( slotPrepareForReread( QString ) ) );
	connect( dirOperator->fileReader(), SIGNAL(newItems( const KFileItemList& )),
	    				this, SLOT(slotInsertItems(const KFileItemList&)));
	connect( dirOperator, SIGNAL( showHidden(bool) ), leftView, SLOT( slotToggleShowHidden(bool)));
	connect( dirOperator->fileReader(), SIGNAL( deleteItem( KFileItem* ) ),leftView, SLOT( slotDeleteItem( KFileItem* ) ) );
	connect( myKBearApp, SIGNAL( deleteItem( KURL ) ),leftView, SLOT( slotDeleteItem( KURL ) ) );
	connect( leftView, SIGNAL( folderStatusChanged( QListViewItem* ) ), this,SLOT ( slotDirChanged( QListViewItem* ) ) );
	connect( leftView, SIGNAL( rightButtonPressed ( QListViewItem *, const QPoint &, int ) ),
						this,SLOT ( slotDirViewRightPressed(/* QListViewItem*, const QPoint&, int*/ ) ) );
   setFocusPolicy(QWidget::WheelFocus);
}
//-----------------------------------------------
KBearFtpView::~KBearFtpView() {
	delete myAnimWidget;
	delete t_myTime;
}
//-----------------------------------------------
void KBearFtpView::show(){
	QextMdiChildView::show();
	pathCombo->setFocus();
}
//-----------------------------------------------
void KBearFtpView::closeEvent(QCloseEvent *e) {
	if( url.protocol() == "ftp" )
		QextMdiChildView::closeEvent( e );
	else{  // is this the local filesystem view ?
		e->ignore(); //we ignore the event , and then signal
		emit localFileSysCloseRequest();
	}
}
//-----------------------------------------------
void KBearFtpView::setup(){
	////////////////////////////////////////////////////////////////////////
	// Setup the GUI
	vBox = new QVBox( this );
	setFirstFocusableChildWidget (vBox );
	toolBarUpper = new KToolBar( vBox, "ToolBarUpper");
	toolBarLower = new KToolBar( vBox, "ToolBarLower");
	splitter = new QSplitter( vBox );
	leftView = new KBearDirView( this, splitter, "DirView");
	dirOperator= new KBearDirOperator( this, "/", splitter, "MyDirOperator" );
	splitter->setResizeMode( leftView, QSplitter::Stretch);
	splitter->setResizeMode( dirOperator, QSplitter::Stretch);
	if( ! ((KToggleAction*)dirOperator->actionCollection()->action("tree view"))->isChecked() )
		leftView->hide();

	toolBarUpper->setEnableContextMenu( false );
	toolBarUpper->enableFloating( false );
	toolBarUpper->enableMoving( false );

	toolBarLower->setEnableContextMenu( false );
	toolBarLower->enableFloating( false );
	toolBarLower->enableMoving( false );

	//	now plug the actions to the toolbar
   dirOperator->actionCollection()->action( "up" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "back" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "forward" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "homeDir" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "separator" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "reload" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "separator" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "stop" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "separator" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "mkdir" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "separator" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "detailed list" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "icon view" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "separator" )->plug( toolBarUpper );
   dirOperator->actionCollection()->action( "tree view" )->plug( toolBarUpper );
	
	// insert a path label
	QLabel* pathLabel = new QLabel( i18n( " Path: " ), toolBarLower );
	toolBarLower->insertWidget( 0, 35, pathLabel, 0 );
	// insert a combobox for displaying current path
	toolBarLower->insertCombo( "",1,true,SIGNAL( activated ( const QString& ) ),
					 this,SLOT( slotDirChanged( const QString& ) ),true,i18n("This field displays the current directory."), 1 );
	pathCombo = toolBarLower->getCombo( 1 );
	QWhatsThis::add( pathCombo, i18n("This field displays the current directory.") );
	
	// insert a path label
	QLabel* filterLabel = new QLabel( i18n( " Filter: " ), toolBarLower );
	toolBarLower->insertWidget( 2, 35, filterLabel, 2 );
	// insert a combobox for displaying current path
	toolBarLower->insertCombo( "*",3,true,SIGNAL( activated ( const QString& ) ),
					 this,SLOT( slotFilterChanged( const QString& ) ),true,i18n("This field displays the current filter."), 3 );
	QWhatsThis::add( toolBarLower->getCombo(3), i18n("This field displays the current filter.\n\n"
																							"You can use wildcards here to filter the view") );
	toolBarLower->getCombo( 3 )->setFixedWidth( 120 );
	// add 'wheel' animation
	myAnimWidget = new KAnimWidget( QString("kde"), 0, toolBarLower, "WheelAnimation" );	

	toolBarLower->setItemAutoSized( 1, true );	

	toolBarUpper->updateRects();
	toolBarLower->updateRects();
	
	statusLabel = new QLabel( vBox, "StatusLabel" );
	statusLabel->setFrameStyle ( QFrame::StyledPanel | QFrame::Plain );

	statusBarLower = new QHBox( vBox  );

	// insert a progress bar
	dirOperator->progressBar()->reparent( statusBarLower, QPoint(0,0));
	QLabel* dummyLabel1 = new QLabel( statusBarLower, "DummyLabel1" );
	// insert labels for displaying numbers of dirs and files in current path
	directoryLabel = new QLabel( statusBarLower, "DirectoryLabel" );
	directoryLabel->setFrameStyle ( QFrame::StyledPanel | QFrame::Sunken );
	directoryLabel->setText( i18n("Directories: ") );
	
	fileLabel = new QLabel( statusBarLower, "FileLabel" );
	fileLabel->setFrameStyle ( QFrame::StyledPanel | QFrame::Sunken );
	fileLabel->setText( i18n("Files: ") );
	
	t_myTime = new QDateTime(QDateTime::currentDateTime().date(), QDateTime::currentDateTime().time());
	timeLabel = new QLabel( statusBarLower, "TimeLabel" );
	timeLabel->setFrameStyle ( QFrame::StyledPanel | QFrame::Sunken );
	timeLabel->setText( i18n("Connected: %1").arg( t_myTime->toString() ) );
	QTimer* t = new QTimer( this );
	t->start( 1000 );
	connect( t, SIGNAL( timeout() ), this, SLOT( slotUpdateClock() ) );
	
	QLabel* dummyLabel2 = new QLabel( statusBarLower, "DummyLabel2" );

	statusBarLower->setStretchFactor( dummyLabel1, 10 );
	statusBarLower->setStretchFactor( dummyLabel2, 10 );
	statusBarLower->setStretchFactor( directoryLabel, 0 );
	statusBarLower->setStretchFactor( fileLabel, 0 );
	statusBarLower->setStretchFactor( timeLabel, 0 );
	statusBarLower->setStretchFactor( dirOperator->progressBar(), 7 );

	setUpdatesEnabled ( true );
	installEventFilterForAllChildren();
}
//-----------------------------------------------
void KBearFtpView::slotConnectRemote(const QString& host,const int& port,bool anonym,
						const QString& user,const QString& pass,const QString& path){
    // let's connect to the FTP server
    // First we need to set stuff (host, path, etc.) which the user entered
	url ="ftp://"+host; // set protocol and host
	// if  "anonymous"
	// let's connect anonymous, else private with password
	if ( anonym || user == "") {
		url.setUser( "anonymous" );
		url.setPass( myKBearApp->emailDefault() );
	}
	else {
		url.setUser( user ); // set the user
		url.setPass( pass ); // set the password
	}			
	url.setPort( port ); // set the port
	url.setPath( path ); // set the path
	setupConnection();
}
//-----------------------------------------------
void KBearFtpView::slotConnectLocal(QString localPath){
	url.setPath( localPath );
	setupConnection();
}
//-----------------------------------------------

void KBearFtpView::setupConnection(){
	url = url.url( 1 );
	dirOperator->setHomeURL( url );
	KFileViewItem* item = new KFileViewItem( 0, 0, url, false );
	KBearDirViewItem* root = new KBearDirViewItem( leftView, item, url.path(), true );
	root->setOpenExt( true );
	leftView->setCurrentItem( root );
	((KBearDirView*)leftView)->setURL( url );
	dirOperator->setURL( url, true );
	connect( dirOperator->fileReader()->job(), SIGNAL( result ( KIO::Job* ) ),
					this, SLOT( slotConnectResult( KIO::Job* ) ) );
}
//-----------------------------------------------
void KBearFtpView::slotSetPathCombo( const KURL &u ) {
	for ( int i = 0; i < pathCombo->count(); i++ ) {
		if ( toolBarLower->getComboItem(1, i ) == u.path(1) ) {
			toolBarLower->setCurrentComboItem( 1, i );
			((KBearDirView*)leftView)->setDir( u.path(1) );
			return;
		}
	}
	pathCombo->insertItem( u.path(1) );
	pathCombo->setCurrentItem( pathCombo->count() -1 );
	((KBearDirView*)leftView)->setDir( u.path(1) );
}
//-----------------------------------------------
void KBearFtpView::slotDirChanged( const QString& path ) {
	if( path != "" ) {
		url.setPath( path );
		url.setPath( url.path( +1 ) );
	}
	pathCombo->changeItem( url.path(1), pathCombo->currentItem() );
	int alreadyThere = -1;
	for ( int i = 0; i < pathCombo->count(); i++ ) {
		if ( toolBarLower->getComboItem(1, i ) == url.path(1)
						&& i != pathCombo->currentItem() ) {
			alreadyThere = i;
			break;
		}
	}
	if( alreadyThere != -1 )
		pathCombo->removeItem( alreadyThere );
	dirOperator->setURL( url, false );
}
//-----------------------------------------------
void KBearFtpView::slotDirChanged( QListViewItem* item ) {
	url.setPath( ((KBearDirViewItem*)item)->url().path( 1 ) );
	dirOperator->setURL( url, false );
}
//-----------------------------------------------
/** update view if a resizeEvent occures
*@see QResizeEvent */
void KBearFtpView::resizeEvent( QResizeEvent* e ){
	QextMdiChildView::resizeEvent( e );
	vBox->resize( (e->size()).width(), (e->size()).height() );
	emit viewPositionChanged();
}
//-----------------------------------------------
void KBearFtpView::moveEvent( QMoveEvent* e ) {
	QextMdiChildView::moveEvent( e );
	emit viewPositionChanged();
}
//-----------------------------------------------
/**  */
void KBearFtpView::slotInsertItems( const KFileItemList & list)  {
	KFileItemListIterator it( list );
	for( ; it.current(); ++it ) {
		((KBearDirView*)leftView)->slotNewDirEntry( static_cast<KFileViewItem*>( *it ) );
		if( it.current()->isDir() )
			pathCombo->completionObject()->addItem( it.current()->url().path(+1) );
	}
}
//-----------------------------------------------
/**  this slot is called when the KBearDirOperator has finished loading a directory */
void KBearFtpView::slotFinishedLoading(){
	slotStatusMsg( NULL, i18n( "No Operation in Progress" ) );
	myAnimWidget->stop(); // stop wheel animation
}
//-----------------------------------------------
void KBearFtpView::slotStartLoadingDir(){
//	slotReadingDirProgress( NULL, 0 );
	myAnimWidget->start(); // start wheel animation
	slotStatusMsg( NULL, i18n( "Reading directory..." ) );
	pathCombo->completionObject( true )->clear();
}
//-----------------------------------------------
void KBearFtpView::slotUpdateDirsAndFiles( int dirs, int files ){
	directoryLabel->setText( i18n( "Directories: %1").arg(dirs) );
	fileLabel->setText( i18n( "Files: %1" ).arg(files) );
	// we have to redraw this in as fast as possible
	QApplication::flushX();
}
//-----------------------------------------------
void KBearFtpView::slotDirViewRightPressed(/* QListViewItem* item, const QPoint& p, int c */){
	//create popup menu of choices
	QPopupMenu menu( this );
	dirOperator->actionCollection()->action( "tree view" )->plug( &menu );
	menu.setMouseTracking( true );
	menu.exec( QCursor::pos() );
}
//-----------------------------------------------
/** show/hides the tree view */
void KBearFtpView::slotToggleTreeView( bool show ){
	if( show )
		leftView->show();
	else{
		leftView->hide();
	}
}
//-----------------------------------------------
/** returns the current url of the view */
KURL KBearFtpView::getCurrentURL() const {
	return dirOperator->url();
}
//-----------------------------------------------
const KFileViewItemList * KBearFtpView::selectedItems() const {
	return dirOperator->selectedItems();
}
//-----------------------------------------------
void KBearFtpView::slotStatusMsg( KIO::Job*, const QString& mess){
	statusLabel->setText( mess );
}
//-----------------------------------------------
void KBearFtpView::dropped( KURL::List urlList ){
	QPopupMenu menu( this );

	int COPY_ITEM = menu.insertItem( i18n("&Copy") );
	int MOVE_ITEM = menu.insertItem( i18n( "&Move" ) );

	menu.setMouseTracking( TRUE );
	int id = menu.exec( QCursor::pos() );
	if ( id == -1 )
		return;
	if ( id == COPY_ITEM )
		myKBearApp->startTransfer( this, urlList, false );
	else if ( id == MOVE_ITEM )
		myKBearApp->startTransfer( this, urlList, true );
}
//-----------------------------------------------
void KBearFtpView::showTreeView( bool flag ){
	if( flag )
		leftView->show();
	else
		leftView->hide();
}
//-----------------------------------------------
void KBearFtpView::slotFilterChanged( const QString& filter ){
	int alreadyThere = -1;
	KComboBox* combo = toolBarLower->getCombo( 3 );
	for ( int i = 0; i < toolBarLower->getCombo(3)->count(); i++ ) {
		if ( toolBarLower->getComboItem(3, i ) == filter
				&& i != combo->currentItem() ) {
			alreadyThere = i;
			break;
		}
	}
	if( alreadyThere != -1 ) {
		combo->removeItem( alreadyThere );
	}
	dirOperator->setNameFilter( filter );
	dirOperator->rereadDir();
}
//-----------------------------------------------
void KBearFtpView::slotConnectResult( KIO::Job* job ){
	if( job->error() ) {
kdDebug()<<"error="<<job->error()<<endl;
		close();
	}
}
//-----------------------------------------------
KURL::List KBearFtpView::myHighlightedItems(){
	KURL::List lst;
	const KFileViewItemList* fileList = dirOperator->selectedItems();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	for ( ; it.current(); ++it ){
		lst.append( (*it)->url() );
	}
	return lst;
}
//-----------------------------------------------
void KBearFtpView::slotUpdateClock(){
	int numOfDays = t_myTime->daysTo( QDateTime::currentDateTime() );
	int mSecs = t_myTime->time().elapsed();
	QTime t;
	QString tString = t.addMSecs( mSecs ).toString();
	QString tmpLeft = tString.left( 2 );
	QString tmpRight = tString.right( 6 );
	int hours = tmpLeft.toInt();
	hours += (numOfDays*24);
	tString = QString("%1").arg( hours );
	tString += tmpRight;
	
	timeLabel->setText( i18n("Connected: %1").arg( tString ) );
}
//-----------------------------------------------
void KBearFtpView::youAreDetached() {
   QextMdiChildView::youAreDetached();
	setFocusPolicy(QWidget::WheelFocus);
	if( ((KToggleAction*)(dirOperator->actionCollection()->action( "detailed list" )))->isChecked() )
		dirOperator->slotSetDetailedListViewMode();
	else
		dirOperator->slotSetIconViewMode();
}
//-----------------------------------------------

