#include "threads.h"
#include <iostream>

class TestThread : public Thread
{
protected:
  static int compare(const void* a, const void* b)
    {
      if(a==b) return 0;
      if(a<b) return -1;
      return 1;
    }
  void* threadMain()
    {
      const int NumVals=100000;
      int x[NumVals];
      int i;
      // -----
      cout << "TestThread::threadMain: started (pthread_t: "
	   << identity() << ")." << endl;
      for(i=0; i<NumVals; ++i)
	{
	  x[NumVals]=rand();
	}
      qsort(x, NumVals, sizeof(int), compare);
      cout << "TestThread::threadMain: done (pthread_t: "
	   << identity() << ")." << endl;
      return 0;
    }
};

int main()
{
  const int NumThreads=10;
  int i;
  TestThread threads[NumThreads];
  // -----
  for(i=0; i<NumThreads; ++i)
    {
      threads[i].start();
    }
  for(i=0; i<NumThreads; ++i)
    {
      Thread::joinThread(threads[i]);
    }
  return 0;
}
