/***************************************************************************
                          klock.cpp  -  description
                             -------------------
    begin                : Wed Oct 11 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "klock.h"
#include <kwin.h>
#include <qmessagebox.h>
#include <iostream.h>

Klock::Klock(QWidget *parent, const char *name) :
		KMainWindow(parent, name,
		WStyle_NoBorder | WStyle_Customize //| WStyle_StaysOnTop//| WStyle_Title ||WStyle_Title| WStyle_SysMenu | WStyle_MinMax
		)//paintNoErase | WPaintClever|  WResizeNoErase)//WPaintClever | WRepaintNoErase | WType_TopLevel)
{
    rootxpm         = 0L;
    optionDialog    = 0L;
    m_background    = 0L;
    m_backgroundPic = 0L;
    m_startup       = true;
    contextMenu     = new KPopupMenu(this);
    typeMenu        = new KPopupMenu(this);
    stopWatchMenu   = new KPopupMenu(this);
    accel           = new QAccel(this);
    m_transparentOn = false;
    createPopupMenu();
    readConfig();

    int backEffect = options.back.effect;
    options.back.effect = bmOneColor;

    setPlainCaption("K D Clock");
    setBackgroundMode( NoBackground );
    setFocusPolicy (QWidget::StrongFocus);
    setMinimumSize(5,5);

    m_dots = true;
    time   = QTime::currentTime();
    timer  = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(slotTimer()));

    recreate(parentWidget(),//tyle_Customize| WRepaintNoErase | WPaintClever|  WResizeNoErase |
      WType_TopLevel | WStyle_Customize | WStyle_NoBorder
      | WStyle_StaysOnTop, pos(), TRUE);
    slotTimer();
    if (options.mode.displayMode==dmClock)
        timer->start(1000);
    if (options.mode.displayMode==dmCountdown)
        startCountdown();
    if (options.mode.displayMode==dmStopWatch)
        resetStopWatch();
    updateContextMenu();

    int d = QMIN(width(),height());
    bool bl = contextMenu->isItemChecked(borderlessID);
	bool at = contextMenu->isItemChecked(alwaysOnTopID);
	if ((bl) && (at))
	{
//		QMessageBox::warning( this, "Klock", "b, a");
		recreate(parentWidget(),WStyle_NoBorder | WType_TopLevel
			|WStyle_StaysOnTop// | WStyle_Title| WStyle_SysMenu | WStyle_MinMax
			,pos(), TRUE);
	}
	else
	if ((bl) && (!at))
	{
		recreate(parentWidget(),WType_TopLevel | //WRepaintNoErase | WPaintClever|  WResizeNoErase |
			/*WStyle_Customize |*/ WStyle_NoBorder, pos(), TRUE);
	}
	else
	if ((!bl) && (at))
	{
		recreate(parentWidget(),WType_TopLevel | WStyle_StaysOnTop | WStyle_Title | WStyle_NormalBorder| WPaintClever|  WResizeNoErase
        | WStyle_SysMenu | WStyle_MinMax, pos(), TRUE);
	}
	else
	if ((!bl) && (!at))
	{
		recreate(parentWidget(),WType_TopLevel | WStyle_Title | WStyle_NormalBorder| WPaintClever|  WResizeNoErase
        | WStyle_SysMenu | WStyle_MinMax, pos(), TRUE);
	}
	if (bl)
	{
		if (typeMenu->isItemChecked(analogItem))
		{
			QRegion qr ((int)rect().center().x()-d/2,(int)rect().center().y()-d/2,(int)d,(int)d,QRegion::Ellipse);
			setMask(qr);
		}
		else
		{
			QRegion qr (rect(), QRegion::Rectangle);
			setMask(qr);
		}
	}
    if (options.back.effect == bmTransparent)
    {
        setTransparentMode(true);
    }
    else
    {
        setTransparentMode(false);
    }
    options.back.effect = backEffect;
    createBackgroundPixmap();
}

Klock::~Klock()
{
	delete m_background;
	delete m_backgroundPic;
    delete rootxpm;
}

void Klock::readConfig()
{
	KConfig *config = kapp->config();
	config->setGroup("values");
	m_analog = config->readBoolEntry("analog",true);
	m_borderless =config->readBoolEntry("borderless",false);
	m_top = config->readBoolEntry("ontop",false);
	config->setGroup("Geometry");
	int x = config->readNumEntry("x",0);
	int y = config->readNumEntry("y",0);
	int w = config->readNumEntry("width",120);
	int h = config->readNumEntry("height",120);
	setGeometry(x,y,w,h);
	config->setGroup("Mode");
	options.mode.displayMode = config->readNumEntry("displayMode",dmClock);
	options.mode.countHourMin = config->readEntry("countdown","00:00");
	options.mode.ampm = config->readBoolEntry("ampm",false);
	options.mode.enableAlarm = config->readBoolEntry("alarm",false);
	options.mode.alarmFile = config->readEntry("alarmFile","");
	options.mode.alarmTime = config->readDateTimeEntry("alarmTime").time();
	config->setGroup("Font");
	QFont f = QFont ("Courier",20,QFont::Bold);
	options.font.font = config->readFontEntry("font",&f);
	config->setGroup("Color");
	QColor c = QColor("black");
	options.color.foreground = config->readColorEntry("foreground",&c);
	c = QColor("darkgrey");
	options.color.shadow = config->readColorEntry("shadow",&c);
	c = QColor("red");
	options.color.plain = config->readColorEntry("plain",&c);
	config->setGroup("Background");
	c = QColor("grey");
	options.back.backgroundColor1 = config->readColorEntry("background1",&c);
	c = QColor("grey");
	options.back.backgroundColor2 = config->readColorEntry("background2",&c);
	options.back.backgroundPicture = config->readEntry("picture","");
	options.back.effect = config->readNumEntry("effect",0);
	options.back.effectNumber = config->readNumEntry("effektNumber",0);
	options.back.pictureMode = config->readNumEntry("pictureMode",pmMaxCentered);
	options.back.pictureBackground = config->readNumEntry("picBackground",pbOneColor);
	config->setGroup("Misc");
	options.misc.beep = config->readBoolEntry("beep",false);
	options.misc.showSeconds = config->readBoolEntry("seconds",true);
	options.misc.showDate = config->readBoolEntry("date",false);
	options.misc.showDateShadow = config->readBoolEntry("dateShadow",false);
	options.misc.showShadow = config->readBoolEntry("shadow",true);
	options.misc.blinkingDots = config->readBoolEntry("blinking",false);
	options.misc.saveSettings = config->readBoolEntry("save",true);
    options.misc.dateFontSize = config->readNumEntry("fontsize", 10);
    options.misc.dateFontState = config->readNumEntry("fontstate", 0);
    options.misc.shadowDist = config->readNumEntry("shadowDist", 3);
    options.misc.dateShadowDist = config->readNumEntry("dateShadowDist", 1);
    //contextMenu->setItemChecked(alwaysOnTopID, m_top);
    if (m_top) alwaysOnTopClicked();
    //contextMenu->setItemChecked(borderlessID, m_borderless);
    if (m_borderless) noBorderClicked();
    setDShadowFont();
}

void Klock::writeConfig()
{
	KConfig *config = kapp->config();
	config->setGroup("values");
	bool analogChecked = typeMenu->isItemChecked(analogItem);
	config->writeEntry("analog", analogChecked);
	config->writeEntry("borderless",contextMenu->isItemChecked(borderlessID));
	config->writeEntry("ontop",contextMenu->isItemChecked(alwaysOnTopID));
	config->setGroup("Geometry");
	config->writeEntry("x",x());
	config->writeEntry("y",y());
	config->writeEntry("width",width());
	config->writeEntry("height",height());
	config->setGroup("Mode");
	config->writeEntry("displayMode",options.mode.displayMode);
	config->writeEntry("countdown",options.mode.countHourMin);
	config->writeEntry("ampm",options.mode.ampm);
	config->writeEntry("alarm",options.mode.enableAlarm);
	config->writeEntry("alarmFile",options.mode.alarmFile);
	config->writeEntry("alarmTime",QDateTime(QDate::currentDate(),options.mode.alarmTime));
	config->setGroup("Font");
	config->writeEntry("font",options.font.font);
	config->setGroup("Color");
	config->writeEntry("foreground",options.color.foreground);
	config->writeEntry("shadow",options.color.shadow);
	config->writeEntry("plain",options.color.plain);
	config->setGroup("Background");
	config->writeEntry("background1",options.back.backgroundColor1);
	config->writeEntry("background2",options.back.backgroundColor2);
	config->writeEntry("picture",options.back.backgroundPicture);
	config->writeEntry("effect",options.back.effect);
	config->writeEntry("effektNumber",options.back.effectNumber);
	config->writeEntry("pictureMode",options.back.pictureMode);
	config->writeEntry("picBackground",options.back.pictureBackground);
	config->setGroup("Misc");
	config->writeEntry("beep",options.misc.beep);
	config->writeEntry("seconds",options.misc.showSeconds);
	config->writeEntry("dateShadow",options.misc.showDateShadow);
	config->writeEntry("shadow",options.misc.showShadow);
	config->writeEntry("date",options.misc.showDate);
	config->writeEntry("blinking",options.misc.blinkingDots);
	config->writeEntry("save",options.misc.saveSettings);
    config->writeEntry("fontsize",options.misc.dateFontSize);
    config->writeEntry("fontstate",options.misc.dateFontState);
    config->writeEntry("shadowDist",options.misc.shadowDist);
    config->writeEntry("dateShadowDist",options.misc.dateShadowDist);
}

void Klock::createPopupMenu()
{
   KStdAccel stdacc;

   startItem    = stopWatchMenu->insertItem(i18n("&Start"), this, SLOT(startStopWatch()));
   stopItem    = stopWatchMenu->insertItem(i18n("S&top"), this, SLOT(stopStopWatch()));
   resetItem   = stopWatchMenu->insertItem(i18n("&Reset"), this, SLOT(resetStopWatch()));
   watchItem   = contextMenu->insertItem(i18n("&Stop Watch"), stopWatchMenu);
   stopWatchMenu->setItemEnabled(false,stopItem);
   stopWatchMenu->setItemEnabled(false,resetItem);
   sepItem     = contextMenu->insertSeparator(-1);
   analogItem  = typeMenu->insertItem(i18n("&Analog"), this, SLOT(analogClicked()));
   digitalItem = typeMenu->insertItem(i18n("&Digital"),this, SLOT(digitalClicked()));
   typeMenu->setItemChecked(analogItem,m_analog);
   typeMenu->setItemChecked(digitalItem,!m_analog);
   contextMenu->insertItem(i18n("&Type"), typeMenu);
   borderlessID = contextMenu->insertItem(i18n("&No Border"), this, SLOT(noBorderClicked()));
   contextMenu->setItemChecked(borderlessID, m_borderless);
   alwaysOnTopID = contextMenu->insertItem(i18n("&Always on Top"), this, SLOT(alwaysOnTopClicked()));
   contextMenu->setItemChecked(alwaysOnTopID, m_top);
   contextMenu->insertItem(i18n("&Preferences"), this, SLOT(optionsClicked()));
   KPopupMenu *help = KMainWindow::helpMenu(QString("The K Desktop Clock")
	 + " " + KLOCK_VERSION + i18n(" released ") + KLOCK_RELEASE_DATE
         + "\n \n" + i18n("by") + " Norbert Andres"
         + " (nandres@gmx.de)\n"
         + "http://www.norbs.de/kdclock\n\n"
	 + i18n("\nSuggestions, bug reports etc. are welcome"),false
	 );
   contextMenu->insertItem(i18n("&Help"), help);
   contextMenu->insertSeparator(-1);
   contextMenu->insertItem(i18n("&Quit"), this, SLOT(quitClicked()),stdacc.quit());
   accel->connectItem(accel->insertItem(CTRL+Key_A), this, SLOT(analogClicked()));
   accel->connectItem(accel->insertItem(CTRL+Key_D), this, SLOT(digitalClicked()));
   accel->connectItem(accel->insertItem(CTRL+Key_T), this, SLOT(alwaysOnTopClicked()));
   accel->connectItem(accel->insertItem(CTRL+Key_B), this, SLOT(noBorderClicked()));
   accel->connectItem(accel->insertItem(stdacc.help()), this, SLOT(appHelpActivated()));
   sepIndex    = contextMenu->indexOf(sepItem);
   watchIndex  = contextMenu->indexOf(watchItem);
   stopWatchMenu->setItemEnabled(stopItem,false);
   stopWatchMenu->setItemEnabled(resetItem,false);
   stopWatchMenu->setItemEnabled(startItem,true);
   if (options.mode.displayMode!=dmStopWatch)
   {
        contextMenu->removeItem(watchItem);
        contextMenu->removeItem(sepItem);
   }
}

void Klock::mousePressEvent(QMouseEvent *ev)
{
  if (ev->button() == QMouseEvent::MidButton)
	noBorderClicked();
  if(ev->button() == QMouseEvent::RightButton)
	slotContextMenu();
  if (ev->button() == QMouseEvent::LeftButton)
  {
	m_offset = ev->pos();
        grabMouse(sizeAllCursor);
  }
}

void Klock::mouseReleaseEvent (QMouseEvent *ev)
{
	if( ev->button() == LeftButton )
	{
		m_dragging = false;
                releaseMouse();
		raise();
	}
}

void Klock::mouseMoveEvent(QMouseEvent *ev)
{
            if ( m_dragging )
            {
                    move( QCursor::pos() - m_offset );
            }
            else
            {
                m_dragging = (
                    (ev->pos().x() - m_offset.x()) * (ev->pos().x() - m_offset.x())
                    +
                    (ev->pos().y() - m_offset.y()) * (ev->pos().y() - m_offset.y())
                    >= 9 );
            }
            return;
}

bool Klock::queryClose()
{
	if (options.misc.saveSettings)
		writeConfig();
	return true;
}

void Klock::resizeEvent(QResizeEvent *)
{
	createBackgroundPixmap();
}

void Klock::quitClicked()
{
	if (options.misc.saveSettings)
		writeConfig();
	kapp->quit();
}

void Klock::analogClicked()
{
	typeMenu->setItemChecked(analogItem,true);
	typeMenu->setItemChecked(digitalItem,false);
	m_analog = true;
//	if (width()>height())
	resize((int)(width()+height())/2,(int)(width()+height())/2);
//	else
//		resize(height(),height());
	changeBorder();
}

void Klock::digitalClicked()
{
	m_analog = false;
	typeMenu->setItemChecked(analogItem,false);
	typeMenu->setItemChecked(digitalItem,true);
	changeBorder();
}

void Klock::optionsClicked()
{
	if( optionDialog == 0L )
	{
		optionDialog = new COptionDialog( this, 0, false );
		if ( optionDialog == 0L )
			{ return; }
		connect( optionDialog, SIGNAL(modeChoice(const SModeState &)),
			this, SLOT(setModeOption(const SModeState &)) );
		connect( optionDialog, SIGNAL(fontChoice(const SFontState &)),
			this, SLOT(setFontOption(const SFontState &)) );
		connect( optionDialog, SIGNAL(colorChoice(const SColorState &)),
			this, SLOT(setColorOption(const SColorState &)) );
		connect( optionDialog, SIGNAL(backgroundChoice(const SBackgroundState &)),
			this, SLOT(setBackgroundOption(const SBackgroundState &)) );
		connect( optionDialog, SIGNAL(miscChoice(const SMiscState &)),
			this, SLOT(setMiscOption(const SMiscState &)) );
	}
	if( optionDialog->isVisible() == false )
	{
		optionDialog->setState( options );
	}
	optionDialog->show();
}

void Klock::changeState()
{
	int d = QMIN(width(),height());
    int backEffect = options.back.effect;
    options.back.effect = bmOneColor;
	bool bl = contextMenu->isItemChecked(borderlessID);
	bool at = contextMenu->isItemChecked(alwaysOnTopID);
	if ((bl) && (at))
	{
		recreate(parentWidget(),WType_TopLevel | WPaintClever|  WResizeNoErase|//tyle_Customize| WRepaintNoErase | WPaintClever|  WResizeNoErase |
			WStyle_StaysOnTop /*|WStyle_Title| WStyle_SysMenu*/ | WStyle_NoBorder
			, pos(), TRUE);
	}
	else
	if ((bl) && (!at))
	{
		recreate(parentWidget(),WType_TopLevel | WPaintClever|  WResizeNoErase//| WRepaintNoErase | WPaintClever|  WResizeNoErase |
			/*|WStyle_Customize */ | WStyle_NoBorder, pos(), TRUE);
	}
	else
	if ((!bl) && (at))
	{
		recreate(parentWidget(),WType_TopLevel | WStyle_StaysOnTop| WPaintClever|  WResizeNoErase
            | WStyle_Title | WStyle_NormalBorder | WStyle_SysMenu | WStyle_MinMax, pos(), TRUE);
		setPlainCaption("K D Clock");
	}
	else
	if ((!bl) && (!at))
	{
		recreate(parentWidget(),WType_TopLevel | WStyle_Title | WStyle_NormalBorder| WPaintClever|  WResizeNoErase
            | WStyle_SysMenu | WStyle_MinMax, pos(), TRUE);
		setPlainCaption("K D Clock");
	}
	if (bl)
	{
		if (typeMenu->isItemChecked(analogItem))
		{
			QRegion qr ((int)rect().center().x()-d/2,(int)rect().center().y()-d/2,(int)d,(int)d,QRegion::Ellipse);
			setMask(qr);
		}
		else
		{
			QRegion qr (rect(), QRegion::Rectangle);
			setMask(qr);
		}
	}
	setPlainCaption("K D Clock");
    options.back.effect = backEffect;
}

void Klock::noBorderClicked()
{
	m_borderless = !contextMenu->isItemChecked(borderlessID);
	contextMenu->setItemChecked(borderlessID, m_borderless);
	changeState();
}

void Klock::alwaysOnTopClicked()
{
	m_top = !contextMenu->isItemChecked(alwaysOnTopID);
	contextMenu->setItemChecked(alwaysOnTopID, m_top);
	changeState();
}

void Klock::changeBorder()
{
	int d = QMIN(width(),height());
	changeState();
	if (contextMenu->isItemChecked(borderlessID))
	{
		if (typeMenu->isItemChecked(analogItem))
		{
			QRegion qr ((int)rect().center().x()-d/2,(int)rect().center().y()-d/2,(int)d,(int)d,QRegion::Ellipse);
			setMask(qr);
		}
		else
		{
			QRegion qr (rect(), QRegion::Rectangle);
			setMask(qr);
		}
	}
	setPlainCaption("K D Clock");
}

void Klock::changeAlwaysOnTop()
{
        if (contextMenu->isItemChecked(alwaysOnTopID))
        {
                WFlags wf = getWFlags();
                recreate (parentWidget(),wf | WStyle_StaysOnTop, pos(), true);
                //KWin::setState( winId(), NET::StaysOnTop );
                raise();
        }
        else
        {
                clearWFlags(WStyle_StaysOnTop);
                //KWin::clearState( winId(), NET::StaysOnTop );
        }
}

void Klock::slotContextMenu()
{
    contextMenu->exec(QCursor::pos());
}

void Klock::slotTimer()
{
    m_startup=false;
    repaint();
}

// The next method is taken from module kdesktop.
// Copyright (C) 1999 Geert Jansen <g.t.jansen@stud.tue.nl>
void Klock::tile(QImage *dest, QRect rect, QImage *src)
{
	rect &= dest->rect();

	int x, y;
	int h = rect.height(), w = rect.width();
	int offx = rect.x(), offy = rect.y();
	int sw = src->width(), sh = src->height();

	for (y=offy; y<offy+h; y++)
		for (x=offx; x<offx+w; x++)
			dest->setPixel(x, y, src->pixel(x%sw, y%sh));
}


void Klock::createBackgroundPixmap()
{
	if ((options.back.effect!=bmTwoColors) && (options.back.effect!=bmPicture))
		return;
	if (m_background != 0L)
	{
		delete m_background;
		m_background = 0L;
	}
	if (m_backgroundPic != 0L)
	{
		delete m_backgroundPic;
		m_backgroundPic = 0L;
	}
	m_background = new QPixmap(size());
	m_backgroundPic = new QPixmap(size());

	if ((options.back.effect==bmTwoColors)
        || (options.back.pictureBackground == pbTwoColors))
	{
		switch (options.back.effectNumber)
		{
			case eHorizontalGradient:
			{
				*m_background = KImageEffect::gradient(size(), options.back.backgroundColor1, options.back.backgroundColor2,
					KImageEffect::HorizontalGradient, 0);
				break;
			}
			case eVerticalGradient:
			{
				*m_background = KImageEffect::gradient(size(), options.back.backgroundColor1, options.back.backgroundColor2,
					KImageEffect::VerticalGradient, 0);
				break;
			}
			case ePyramidGradient:
			{
				*m_background = KImageEffect::gradient(size(), options.back.backgroundColor1, options.back.backgroundColor2,
					KImageEffect::PyramidGradient, 0);
				break;
			}
			case ePipeCrossGradient:
			{
				*m_background = KImageEffect::gradient(size(), options.back.backgroundColor1, options.back.backgroundColor2,
					KImageEffect::PipeCrossGradient, 0);
				break;
			}
			case eEllipticGradient:
			{
				*m_background = KImageEffect::gradient(size(), options.back.backgroundColor1, options.back.backgroundColor2,
					KImageEffect::EllipticGradient, 0);
				break;
			}
			case eDiagonalGradient:
			{
				*m_background = KImageEffect::gradient(size(), options.back.backgroundColor1, options.back.backgroundColor2,
					KImageEffect::DiagonalGradient, 0);
				break;
			}
			case eCrossDiagonalGradient:
			{
				*m_background = KImageEffect::gradient(size(), options.back.backgroundColor1, options.back.backgroundColor2,
					KImageEffect::CrossDiagonalGradient, 0);
				break;
			}
			case eRectangleGradient:
			{
				*m_background = KImageEffect::gradient(size(), options.back.backgroundColor1, options.back.backgroundColor2,
					KImageEffect::RectangleGradient, 0);
				break;
			}
		}
	} // End two Colors

	if (options.back.effect==bmPicture)
	{
		QFile qf(options.back.backgroundPicture);
		if (!qf.exists())
		{
			options.back.effect=bmOneColor;
			return;
		}
		QImage *m_backgroundPicture = new QImage(options.back.backgroundPicture);
		int wp = m_backgroundPicture->width();
		int hp = m_backgroundPicture->height();
		int wa = width();
		int ha = height();

		switch (options.back.pictureMode)
		{
			case pmMaxCentered:
			{
				int sw;
				int sh;
				double sx = (double) wa / wp;
				double sy = (double) ha / hp;
				if (sx > sy)
				{
					sw = (int) (sy*wp);
					sh = ha;
				}
				else
				{
					sw = wa;
					sh = (int) (sx*hp);
				}
				*m_backgroundPicture = m_backgroundPicture->smoothScale(sw, sh);
				*m_backgroundPic = *m_backgroundPicture;
				break;
			}
			case pmCentered:
			{
				// nothing to do here, image centering is done in paintEvent
				*m_backgroundPic = *m_backgroundPicture;
				break;
			}
			case pmTiled:
			{
				QImage *qim = new QImage(size(),32);
				tile(qim, rect(), m_backgroundPicture);
				*m_backgroundPic = *qim;
				break;
			}
			case pmScaled:
			{
				*m_backgroundPicture = m_backgroundPicture->smoothScale(wa,ha);
				*m_backgroundPic = *m_backgroundPicture;
				break;
			}
		}
		delete m_backgroundPicture;
		m_backgroundPicture=0L;
	}
}

void Klock::paintEvent(QPaintEvent *)
{
    if ( !isVisible())
        return;

    QString buffer, subTitle;
    time = QTime::currentTime();

    if (options.mode.displayMode == dmStopWatch)
    {
        if (timer->isActive())
        {
            stopTime = QTime::currentTime();
        }
        int h = stopTime.hour() - startTime.hour();
        int m = stopTime.minute() - startTime.minute();
        int s = stopTime.second() - startTime.second();
        if (s<0) { s += 60; m -= 1; }
        if (m<0) { m += 60; h -= 1; }
        if (h<0) { h += 24; }
        time.setHMS(h, m, s, 0);
        subTitle = i18n("Stopp watch");
    }
    else
    if (options.mode.displayMode == dmCountdown)
    {
        QDateTime dt = QDateTime::currentDateTime();
        int s = countdownDateTime.secsTo(dt);
        if (s==0) stopCountdown();
        int m = (int)(s / 60);
        s = s - (m*60);
        int h = (int)(m / 60);
        m = m - (h*60);
        if (h < 0) h *= -1;
        if (m < 0) m *= -1;
        if (s < 0) s *= -1;
        while (h > 23)
        {
            h -= 24;
        }
        time.setHMS(h, m, s);
        if (!timer->isActive())
            time.setHMS(0, 0, 0);
        subTitle = i18n("Countdown");
    }
    else
    {
        QDate qt = QDate::currentDate();
        if (options.misc.showDate)
            subTitle = KGlobal::locale()->formatDate(qt, true);
        else
            subTitle = "";
    }
    int d = QMIN(width(), height());

    QPixmap pm(size());
    QPainter paint;
    if (options.back.effect == bmTransparent)
    {
        if (!m_transparentOn)
        {
            setTransparentMode(true);
        }
        paint.begin(this);
    }
    else
    if (options.back.effect == bmTwoColors)
    {
        paint.begin( &pm);
        bitBlt(&pm, 0, 0, m_background);
    }
    else
    if (options.back.effect == bmPicture)
    {
        int x = (int) (width() -  m_backgroundPic->width()) / 2;
        int y = (int) (height() - m_backgroundPic->height()) / 2;
        if (options.back.pictureBackground == pbTransparent)
        {
            if (!m_transparentOn)
            {
                setTransparentMode(true);
            }
            paint.begin(this);
            bitBlt(this, x, y, m_backgroundPic);
        }
        else
        if (options.back.pictureBackground != pbTransparent)
        {
            if (m_transparentOn)
            {
                setTransparentMode(false);
            }
            paint.begin( &pm);
            if (options.back.pictureBackground == pbOneColor)
            {
                pm.fill(options.back.backgroundColor1);
            }
            else
            {
                bitBlt(&pm, 0 ,0 , m_background);
            }
            bitBlt(&pm, x, y, m_backgroundPic);
        }
    }
    else
    {
        paint.begin( &pm);
        pm.fill (options.back.backgroundColor1);
    }

    if (typeMenu->isItemChecked(digitalItem))
    {
        bool am = false;
        if (options.mode.ampm)
		{
			if (time.hour() < 12)
			{
				am = true;
			}
			else
			{
				am = false;
				time = time.addSecs(-12 * 60 * 60);
			}
		}
		if (options.misc.blinkingDots == false)
			m_dots = true;

        if (m_dots)
		{
			if (options.misc.showSeconds)
				buffer.sprintf("%02d:%02d:%02d", time.hour(), time.minute(), time.second());
			else
				buffer.sprintf("%02d:%02d", time.hour(), time.minute());
		}
		else
		{
			if (options.misc.showSeconds)
				buffer.sprintf("%02d %02d %02d", time.hour(), time.minute(), time.second());
			else
				buffer.sprintf("%02d %02d", time.hour(), time.minute());
		}
		if(options.mode.ampm)
		{
			if (am)
				buffer += " AM";
			else
				buffer += " PM";
		}
		m_dots = !m_dots;

        paint.setFont(options.font.font);
		if (options.misc.showShadow)
		{
			paint.setPen(options.color.shadow);
			paint.drawText(options.misc.shadowDist, options.misc.shadowDist,
                           width(), height(), AlignHCenter | AlignVCenter, buffer,
                           -1, 0, 0);
		}
		paint.setPen(options.color.foreground);
		paint.drawText(rect(), AlignHCenter | AlignVCenter, buffer, -1, 0, 0);
		paint.setFont(m_dShadowFont);
		if (options.misc.showDateShadow)
		{
    		paint.setPen(options.color.shadow);
		    paint.drawText(options.misc.dateShadowDist, options.misc.dateShadowDist,
                           width(), height(), AlignHCenter|AlignBottom, subTitle,
                           -1, 0, 0);
        }
		paint.setPen(options.color.foreground);
		paint.drawText(rect(), AlignHCenter | AlignBottom, subTitle, -1, 0, 0);
	}
	else
	{
		paint.setPen(options.color.foreground);

        paint.setFont(m_dShadowFont);

        if (options.misc.showDateShadow)
		{
    		paint.setPen(options.color.shadow);
		    paint.drawText(options.misc.dateShadowDist, options.misc.dateShadowDist + 20,
                           width(), height(), AlignHCenter|AlignVCenter, subTitle,
                           -1, 0, 0);
        }

        paint.setPen(options.color.foreground);
		paint.drawText(0, 20, width(), height(), AlignHCenter | AlignVCenter,
                       subTitle, -1, 0, 0);
		QPointArray pts;
		QPoint cp = rect().center();
		paint.setPen( options.color.shadow );
		paint.setBrush( options.color.shadow );
		if (options.misc.showShadow)
			paint.setViewport(options.misc.shadowDist, options.misc.shadowDist,
                              width(), height());
		for (int c = 0 ; c < 2 ; c++)
		{
			QWMatrix matrix;
			matrix.translate( cp.x(), cp.y() );
			matrix.scale( d/1000.0F, d/1000.0F );
			float h_angle = 30 * (time.hour() % 12 - 3) + time.minute() /2;
			matrix.rotate( h_angle );
			paint.setWorldMatrix( matrix );
			pts.setPoints( 4, -20,0,  0,-20, 300,0, 0,20 );
			paint.drawPolygon( pts );
			matrix.rotate( -h_angle );
			float m_angle = (time.minute() - 15) * 6;
			matrix.rotate( m_angle );
			paint.setWorldMatrix( matrix );
			pts.setPoints( 4, -10,0, 0,-10, 400,0, 0,10 );
			paint.drawPolygon( pts );
			matrix.rotate( -m_angle );
			float s_angle = (time.second()-15)*6;
			matrix.rotate( s_angle );
			paint.setWorldMatrix( matrix );
			pts.setPoints(4, 0, 0, 0, 0, 400, 0, 0, 0);
			if ( options.misc.showSeconds )
				paint.drawPolygon( pts );
			matrix.rotate( -s_angle );

			for ( int i=0 ; i < 60 ; i++ )
			{
				paint.setWorldMatrix( matrix );
				if ( (i % 5) == 0 )
					paint.drawLine( 450, 0, 500, 0 );	// draw hour lines
				else
					paint.drawPoint( 480, 0 );	// draw second lines
				matrix.rotate( 6 );
			}

			paint.setPen( options.color.foreground );
			paint.setBrush( options.color.plain );
			paint.setViewport(0, 0, width(), height());
		}
	}
	paint.end();
    if (options.back.effect != bmTransparent)
    {
        if ((options.back.effect != bmPicture)
             || (options.back.pictureBackground != pbTransparent))
            bitBlt (this, 0,0, &pm);
    }
	if ((time.minute()==0) && (time.second()==0) && (options.misc.beep))
	{
		if (timer->isActive())
			kapp->beep();
	}
	if (options.mode.enableAlarm)
	{
		if ((options.mode.alarmTime.hour()==QTime::currentTime().hour())
		  && (options.mode.alarmTime.minute()==QTime::currentTime().minute())
		  && (options.mode.alarmTime.second()==QTime::currentTime().second()))
		{
			KAudioPlayer::play(options.mode.alarmFile);
		}
	}
}

void Klock::updateContextMenu()
{
    contextMenu->clear();
    typeMenu->clear();
    stopWatchMenu->clear();
    createPopupMenu();
}

QString Klock::getHour(QString s)
{
        for (uint i=0;i<s.length();i++)
        {
                if (s[i]==':')
                {
                        return s.left(i);
                }
        }
        return s;
}

QString Klock::getMin(QString s)
{
        int n=0;int m=0;
        for (uint i=0;i<s.length();i++)
        {
                if ((s[i]==':') && (n==0))
                {
                        n=i;
                }
                else
                if (s[i]==':')
                {
                        m=i;
                }
        }
        if (m==0) m=s.length();
        return s.mid(n+1,m-n-1);
}

void Klock::setModeOption(const SModeState &mode)
{
	options.mode = mode;
	updateContextMenu();
	if (options.mode.displayMode==dmClock)
	{
		timer->start(1000);
	}
	else
	if (options.mode.displayMode==dmCountdown)
	{
		startCountdown();
	}
	else
	if (options.mode.displayMode==dmStopWatch)
	{
		resetStopWatch();
		stopStopWatch();
	}
}

void Klock::setFontOption( const SFontState &font )
{
	options.font = font;
}

void Klock::setColorOption( const SColorState &color )
{
	options.color = color;
}

void Klock::setBackgroundOption( const SBackgroundState &back )
{
    options.back = back;
    if (options.back.effect == bmTransparent)
    {
        setTransparentMode(true);
    }
    else
    {
        setTransparentMode(false);
    }
    createBackgroundPixmap();
}


void Klock::setMiscOption( const SMiscState &misc )
{
	options.misc = misc;
	writeConfig();
    setDShadowFont();
}

void Klock::setDShadowFont()
{
    m_dShadowFont = options.font.font;
    m_dShadowFont.setPointSize(options.misc.dateFontSize);
    int fState = options.misc.dateFontState;
    if (fState - fUnderline >= 0)
    {
        m_dShadowFont.setUnderline(true);
        fState -= fUnderline;
    }
    else
        m_dShadowFont.setUnderline(false);
    if (fState - fBold >= 0)
    {
        m_dShadowFont.setBold(true);
        fState -= fBold;
    }
    else
        m_dShadowFont.setBold(false);
    if (fState - fItalic >= 0)
    {
        m_dShadowFont.setItalic(true);
        fState -= fItalic;
    }
    else
        m_dShadowFont.setItalic(false);
}

void Klock::startStopWatch()
{
	stopWatchMenu->setItemEnabled(stopItem,true);
	stopWatchMenu->setItemEnabled(resetItem,true);
	stopWatchMenu->setItemEnabled(startItem,false);
	QTime t = QTime::currentTime();
	int h = t.hour() - stopTime.hour();
	int m = t.minute() - stopTime.minute();
	int s = t.second() - stopTime.second();
	if (s<0) { s += 60; m -= 1; }
	if (m<0) { m += 60; h -= 1; }
	if (h<0) { h += 24; }
	t.setHMS(h,m,s);
	h = t.hour() + startTime.hour();
	m = t.minute() + startTime.minute();
	s = t.second() + startTime.second();
	if (s>59) { s -= 60; m += 1; }
	if (m>59) { m -= 60; h += 1; }
	if (h>23) { h -= 24; }
	startTime.setHMS(h,m,s);
	timer->start(1000);
}

void Klock::stopStopWatch()
{
	stopTime = QTime::currentTime();
	timer->stop();
	stopWatchMenu->setItemEnabled(stopItem,false);
	stopWatchMenu->setItemEnabled(resetItem,true);
	stopWatchMenu->setItemEnabled(startItem,true);
}

void Klock::resetStopWatch()
{
	time = QTime::currentTime();
	stopTime = QTime::currentTime();
	startTime = QTime::currentTime();
	repaint();
}

void Klock::startCountdown()
{
	int h = getHour(options.mode.countHourMin).toInt();
	int m = getMin(options.mode.countHourMin).toInt();
	countdownDateTime = QDateTime::currentDateTime();
	QString str;
	int s = (h * 60 + m) * 60;
	countdownDateTime = countdownDateTime.addSecs(s);
	if (!timer->isActive())
		timer->start(1000);
}

void Klock::stopCountdown()
{
    timer->stop();
    kapp->beep();
}

void Klock::setTransparentMode(bool state)
{
    m_transparentOn = state;
    if (state)
    {
        if (!rootxpm)
            rootxpm = new KRootPixmap(this);
        rootxpm->start();
    }
    else
    {
        if (rootxpm)
            rootxpm->stop();
        setBackgroundMode( NoBackground );
    }
}





