/***************************************************************************
                          optiondialog.h  -  description
                             -------------------
    begin                : Wed Oct 11 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _OPTIONDIALOG_H_
#define _OPTIONDIALOG_H_

#include <kdialogbase.h>
#include <kfontdialog.h>
#include <kfiledialog.h>
#include <kcolorbutton.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qvbox.h>
#include <qdatetime.h>
#include <qmessagebox.h>
#include <qfile.h>

#include "optionstate.h"

/**
  *@author Norbert Andres
  */

class COptionDialog : public KDialogBase
{
        Q_OBJECT

public:
        enum Page
        {
                page_mode=0,
                page_font,
                page_colors,
                page_back,
                page_misc
        };

	COptionDialog(QWidget *parent =0, char *name=0, bool modal=false);
	~COptionDialog();
        void setMode(const SModeState &mode);
        void setFont(const SFontState &font);
        void setColor(const SColorState &color);
        void setBackground(const SBackgroundState &back);
        void setMisc(const SMiscState &misc);
        void setState(const SOptionState &state);

protected slots:
        virtual void slotDefault (void);
        virtual void slotOk (void);
        virtual void slotApply (void);
        virtual void slotHelp (void);

private slots:
        void alarmFileEditClicked(void);
        void backgroundPictureClicked(void);
        void adjustDateTime();

signals:
        void modeChoice(const SModeState &mode);
        void fontChoice(const SFontState &font);
        void colorChoice(const SColorState &color);
        void backgroundChoice(const SBackgroundState &back);
        void miscChoice(const SMiscState &misc);

private:
    QButtonGroup *clockModeGroup;
    QRadioButton *RadioButton1;
    QRadioButton *RadioButton2;
    QRadioButton *RadioButton3;
    QButtonGroup *normalGroup;
    QCheckBox *amCheck;
    QButtonGroup *countdownGroup;
    QLineEdit *hourEdit;
    QLineEdit *minEdit;
    QLabel* TextLabel1;
    QLabel* TextLabel2;
    QGroupBox* GroupBox1;
    QCheckBox* enableAlarmCheck;
    QLineEdit* fileEdit;
    QLineEdit* timeEdit;
    QPushButton* PushButton1;
    QLabel* TextLabel1_2;
    QLabel* TextLabel1_2_2;
    KFontChooser *fontChooser;
    KColorButton *foregroundButton;
    KColorButton *shadowButton;
    KColorButton *contentButton;

    KColorButton *backgroundButton1;
    KColorButton *backgroundButton2;
    QCheckBox *transparentBox;
    QLineEdit *backgroundFileEdit;
    QButtonGroup *backgroundGroup;
    QRadioButton *RButton1;
    QRadioButton *RButton2;
    QRadioButton *RButton3;
    QRadioButton *RButton4;
    QPushButton *chooseFileButton;
    QComboBox *effectBox;
    QComboBox *picBackground;
	QComboBox *pictureMode;

    QCheckBox *beepBox;
    QCheckBox *secondsBox;
    QCheckBox *dateBox;
    QCheckBox *dateShadowBox;
    QCheckBox *boldBox;
    QCheckBox *underlineBox;
    QCheckBox *italicBox;
    QCheckBox *shadowBox;
    QCheckBox *saveBox;
    QCheckBox *blinkingBox;
    QComboBox *sizeBox;
    QComboBox *shadowDistBox;
    QComboBox *dateShadowDistBox;
    QPushButton *adjustButton;

    SOptionState options;
    void setupModePage(void);
    void setupFontPage(void);
    void setupColorPage(void);
    void setupBackgroundPage();
    void setupMiscPage();
    QString getHour(QString s);
    QString getMin(QString s);
    QString getSec(QString s);

    bool checkValues();
	bool m_passed;

    QHBoxLayout *hbox;
};

#endif

