/***************************************************************************
                          kaboutkfilecoder.cpp  -  description
                             -------------------
    begin                : Sat Jul 22 2000
    copyright            : (C) 2000 by Franois Dupoux
    email                : fdupoux@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kstddirs.h>
#include <kaboutdata.h>

#include "kaboutkfilecoder.h"
#include "kfilecoder.h"

// ===========================================================================================================================
KAboutKFileCoder::KAboutKFileCoder(QWidget *parent, const char *name, bool modal)
:KAboutDialog(AbtKDEStandard | AbtProduct, "KFileCoder", KDialogBase::Close, KDialogBase::Close, parent, name, modal)
{
	setTitle("KFileCoder for KDE 2");
	setImage(locate("data", "kfilecoder/pics/about.png"));
	setImageFrame(false);
	setProduct(QString(PACKAGE), QString(VERSION), QString("Franois Dupoux"), QString("2000"));
 	
 	// 2. Add text to the dialog
    const QString strUseful = i18n(""
	"<p><b>KFileCoder</b> is an application which allows you to encoder files "
		"in an archive with a password. Then you can easily send all files of a directory with "
		"an only file, and with a protection. Only people who have the password can read or "
		"modify the archive </p>");
	
    const QString strContribute = i18n(""
    "<p><b>Everyone is welcome to contribute</b> to this project. "
    "You don't have to be a developer to do it. You can do many things:<br>"
    "- Write the SGML documentation in english<br>"
    "- Translate the SGML documentation, or the program strings (in PO files)<br>"
    "- Write some C++ code to add new features<br>"
    "- Send ideas about new features which wan be useful<br>"
    "- Send bug reports to the author<br>"
    "- Draw new icons<br></p>"
    " "
    "<p><b>Please, contact the author if you want to work to help this project</b>, then we will "
    "check the work is not already done, or being done. You also need to download "
    "the last version before writing anything: don't translate an old documentation version!  "
    "You can look at the TODO file to have more details about things to do in the project</p>");

	// About page
	KAboutContainer *cAbout;
	cAbout = addScrolledContainerPage(i18n("&About"), KAboutDialog::AlignCenter, KAboutDialog::AlignLeft);
	if (cAbout)
	{
		static const QString strText1 = i18n("<p><b>KFileCoder</b> is distributed under the <b>GNU GPL 2 (General Public License version 2) license</b>.<br>"
			"Please, report all bugs you find to the author. <p>");
	
		cAbout -> addWidget(new QLabel(strText1, topLevelWidget()));
		cAbout -> addPerson(QString::null, QString("fdupoux@free.fr"), QString("http://kfilecoder.sourceforge.net/"), QString::null, true);
	}

	// Text pages
	addTextPage(i18n("&What KFileCoder does"), strUseful, true);
	addTextPage(i18n("&Contribute"), strContribute, true);

	// Authors page
	KAboutContainer *cAuthors = addScrolledContainerPage(i18n("Aut&hors"), KAboutDialog::AlignCenter, KAboutDialog::AlignLeft);
	if (cAuthors != 0)
	{
		cAuthors -> addPerson(QString("Franois Dupoux"), QString("fdupoux@free.fr"), QString::null, i18n("Main author and French translator"), true);	
		cAuthors -> addPerson(QString("Alexandre Pukall"), QString("alexandermail@hotmail.com"), QString::null, i18n("PC1, PC2 and PSCHF author"), true);
		cAuthors -> addPerson(QString("Richard De Moliner"), QString("demoliner@isi.ee.ethz.ch"), QString::null, i18n("IDEA algorithm author"), true);
	}

	// GPL license text
	const KAboutData *aboutData = KGlobal::instance()->aboutData();
	if (!aboutData->license().isEmpty())
		addLicensePage(i18n("&License"), aboutData->license(), true);

}

// ===========================================================================================================================
KAboutKFileCoder::~KAboutKFileCoder()
{
}
