/***************************************************************************
                          kfilecoder.h  -  description                              
                             -------------------                                         
    begin                : lun mai  3 20:19:52 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@free.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KFILECODER_H
#define KFILECODER_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>
#include <qlistview.h>
#include <qstrlist.h>
#include <qcstring.h>

// include files for KDE
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <klocale.h>

// includes files for standard unix
#include <sys/param.h>

// application specific includes
#include "resource.h"
#include "struct.h"

class KFileCoderDoc;
class QDropEvent;
class KSelectAction;
class QDragEnterEvent;
class KAboutKFileCoder;
class KURL;

extern KApplication *g_app;
extern KAlgoInfo g_algo[];

// ===========================================================================================================================
class KFileCoderApp : public KTMainWindow
{
	Q_OBJECT

public:
	KFileCoderApp();
	~KFileCoderApp();
	void initGUI();
	void initView();
	void saveOptions();
	void readOptions();
	void updateCommandsAccess();
	void setWhatsThis();
	void slotHelpWhatsThis();

public slots:
	void slotFileNewWindow();
	void slotFileNew();
	void slotFileOpen();
	void slotFileClose();
	void slotFileProperties();
	void slotFileTest();
	void slotFileQuit();
	void slotArchiveAddFile();
	void slotArchiveAddDir(QString strDir);
	void slotArchiveExtractAll();
	void slotArchiveExtractSel();
	void slotArchiveDelete();
	void slotViewToolBar();
	void slotViewStatusBar();
	void slotStatusMsg(const char *text);
	void slotStatusHelpMsg(const char *text);
	void closeEvent ( QCloseEvent *);
	void showAboutApplication(void);
	void slotFileConfigureToolbars();
	void slotOptionsCompress();
	void openURL(const KURL&);
	void appHelpActivated();
	void contextHelpActivated();
	void aboutKDE();
	void reportBug();
	
private:
	void dropEvent(QDropEvent *event);
	void dragEnterEvent(QDragEnterEvent *event);
	void setWorking(bool bIsWorking);
	void deleteSelectedFilesInArchive();
	int createNewArchive(QString strFilename);
	int askPassword(BYTE *szDestPass);

private:
	QListView *m_view;
  KFileCoderDoc *m_doc;
	bool m_bViewToolbar;
	bool m_bViewStatusbar;
	QStringList m_recentStringFileList; // a list of recently accessed files
	KSelectAction *m_actCompress;
	KAboutKFileCoder *m_dlgAbout;
	
};
 

#endif // KFILECODER_H
 
 
 
 
 
 
 
 













































