/***************************************************************************
                          kfilecoderdoc.h  -  description                              
                             -------------------                                         
    begin                : ven avr 23 18:58:17 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KFILECODERDOC_H
#define KFILECODERDOC_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qfile.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qstrlist.h>

#include "kfilecoder.h"
#include "ArchiveHeaders.h"
#include "resource.h"


/**
  * This class provides base functionality for your application document
  */

class KFileCoderDoc
{
 public:
  /** Constructor for the fileclass of the application */
  KFileCoderDoc(QObject*, const char *filename=0L);
  ~KFileCoderDoc();

	bool IsArchiveOpened()
	{	return m_bArchiveOpened;
	}

  /** Destructor for the fileclass of the application */

  // Pointers to interface elements
	void SetMainWnd (QWidget *mainWnd);
	void SetListView (QListView *lv);
	QFile *GetArchiveFile();
	int GetNbFiles();
	int GetAlgoUsed();
	
 private: // Datas used for KFileCoder
	QWidget *m_MainWnd;
	QListView *m_List;

	char m_szPassword[MAX_PASSLEN];
	char m_szArchivePath[MAXPATHLEN];
	QFile m_fArchive; // File descriptor of the current archive	
 	bool m_bArchiveOpened; // Is there an archive which is opened ?
	int m_nNbFiles; // Number of files in the current archive
	int m_nAlgorithmUsed;
	uint m_nFlags;

 public: // Functions which works for the files: File menu
	int CreateArchive(char *szFilename, char *szPassword, int nAlgorithmUsed); // Create a new archive and write header: put m_szPassword, m_szArchivePAth, m_fdArchive
	int OpenArchive(char *szFilename, char *szPassword); // Open the archive and read header: put m_szPassword, m_szArchivePAth, m_fdArchive
	int CloseArchive(bool bClearList = true); // Close the current Archive
	
 public: // List View
	int ListView_Fill();
	int ListView_AddItem(char *szName, uint nSize, uint nCRC, char *szPath);

 public: // Internal Functions
	int WriteHeader(); // When creating new archive
	int ReadHeader();	// When opening an archive		
	bool IsFileSelected(char *szFileName, char *szFilePath);
	int GetNbSelectedFiles(); // number of selected files in the list view
	bool DoesFileExistsInArchive(char *szFileName, char *szFilePath);
	int EncodeString(char *szDest, char *szSource, int nStrLen, char *szPassword); // Encode and decode a string using m_szPassword
	uint GetPasswordTestCrc();
	int GetDiskFreeSpaceForFile(uint *nAvailDiskSpace, char *szFilename);			
	int WriteFileString(QFile *qfOut, char *szString, bool bEncode, char *szPassword, bool bErrMsg = true);			
	int ReadFileString(QFile *qfIn, char *szString, bool bEncode, char *szPassword, bool bErrMsg = true);			


 public: // Functions which works for the files: Archive menu. ONLY if file is opened
	int AddFile(char *szFilename);
	int ExtractFiles(char *szDestPath, bool bOnlySelFiles);
	int DeleteSelectedFilesInArchive();

	int AddFileAlgo1(char *szFilename, QFile *fFileToAdd, uint *nOriginalCrc);
	int ExtractFilesAlgo1(char *szFullpath, QFile *fFileToDecode, uint *nExtractedCrc, uint nFileSize);
};

#endif // KFILECODERDOC_H



























































