/***************************************************************************
                          kfilereplace.cpp  -  description                              
                             -------------------                                         
    begin                : ven jun 11 17:07:02 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kfilereplace.h"
#include "repdirargu.h"

#include <qmessagebox.h>
#include <qregexp.h>
#include <qfiledialog.h>

#include <unistd.h>
#include <stdio.h>

#include <kfm.h>
#include <kstdaccel.h>


// Global Thread data
pthread_t g_threadReplace;
bool g_bThreadRunning;
bool g_bThreadMustStop;
int g_nFilesRep;
RepDirArg g_argu;

// ===========================================================================================================================
KFileReplaceApp::KFileReplaceApp()
{
  setCaption("KFileReplace " VERSION);

	// Initialize var
	g_bThreadRunning = false;
	g_bThreadMustStop = false;
	g_nFilesRep = -1;

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initView();

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
	enableToolBar(m_bViewToolbar ? KToolBar::Show : KToolBar::Hide,0);
  enableStatusBar(m_bViewStatusbar ? KStatusBar::Show : KStatusBar::Hide);

  menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
  UpdateCommandsAccess();
  ShowResultList(false);

	// *-*-*-*-*-*-*-*-*-*-* Main window properties -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
	
	setMinimumSize(500, 300);
	setMaximumSize(32767, 32767);
	resize(500, 350);

}

// ===========================================================================================================================
KFileReplaceApp::~KFileReplaceApp()
{
  
}

// ===========================================================================================================================
void KFileReplaceApp::closeEvent (QCloseEvent *)
{	saveOptions();
	slotFileQuit();
}

// ===========================================================================================================================
void KFileReplaceApp::enableCommand(int id_, bool bState)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, bState);
  toolBar()->setItemEnabled(id_, bState);
}

// ===========================================================================================================================
void KFileReplaceApp::UpdateCommandsAccess()
{	// User has made a replace and the list view can contains items
	enableCommand(ID_FILE_INFO, g_nFilesRep > 0 && !g_bThreadRunning);	
	enableCommand(ID_FILE_OPEN, g_nFilesRep > 0 && !g_bThreadRunning);	
	enableCommand(ID_FILE_DIROPEN, g_nFilesRep > 0 && !g_bThreadRunning);	
	enableCommand(ID_FILE_DELETE, g_nFilesRep > 0 && !g_bThreadRunning);
	enableCommand(ID_FILE_SAVE, g_nFilesRep > 0 && !g_bThreadRunning);	

	enableCommand(ID_FILE_STOP, g_bThreadRunning); // If the replace thread is running	
	enableCommand(ID_FILE_REPLACE, !g_bThreadRunning); // If the replace thread is running	
}

// ===========================================================================================================================
void KFileReplaceApp::ShowResultList(bool bState)
{
  // Show or Hide the List View
	if (bState)
	{	view -> GetListView() -> show();
    resize(size().width(), 550);
	}
	else	
	{	view -> GetListView() -> hide();
    resize(size().width(), 350);
	}
}

// ===========================================================================================================================
void KFileReplaceApp::slotFileSaveResults()
{	QFileDialog dlg;
	QString strFilename;
	char szMess[MAX_MESSAGE];
	QListView *lvResult;

	lvResult = view -> GetListView();
	
	// Check there are results
	if (lvResult -> childCount() == 0)
	{	KMsgBox::message(this, "KFileReplace", i18n("There are no results to save: the result list is empty."), KMsgBox::EXCLAMATION, i18n("Cancel"));	
   	return ;
	}

	// Select the file where results will be saved
	strFilename = dlg.getSaveFileName(0, "*.htm");
	
	if (strFilename.isEmpty())
		return ;

	// Force the extension to be "htm" or "html"
	if((strFilename.size() > 3 && strFilename.right(4) != ".htm") && (strFilename.size() > 4 && strFilename.right(5) != ".html"))
		strFilename += ".html";

	// Save results to file
	
  // a) Open the file
	FILE *fResults;
	fResults = fopen(strFilename.data(),"w");

	if (fResults == NULL) // Can't open file
	{	sprintf (szMess, i18n("Can't open the file %s in writing mode to save results."), strFilename.data() );
		KMsgBox::message(this, "KFileReplace", szMess, KMsgBox::EXCLAMATION, i18n("Cancel"));	
   	return ;
	}

	// b) Write header of the HTML file
	fprintf(fResults, "<HTML><HEAD>\n");
	fprintf(fResults, "<!DOCTYPE %s>\n", i18n("KFileReplace Results File"));
	fprintf(fResults, "<TITLE>%sKFileReplace Results File</TITLE></HEAD>\n", i18n("KFileReplace Results File"));
	fprintf(fResults, "<BODY><H1>%s</H1>\n", i18n("KFileReplace Results File"));
	fprintf(fResults, "<DL><p>\n");

	// c) Write the file list
	QListViewItem *lviCurItem;
	QListViewItem *lviFirst;
	QString strPath;
	
	lviCurItem = lviFirst = lvResult -> firstChild();
	if (lviCurItem == NULL)
	{	return ;
	}

	do
	{	strPath.sprintf("%s/%s", lviCurItem -> text(1), lviCurItem -> text(0));
		fprintf(fResults,"<DT><A HREF=\"file:%s\">file:%s</A><br>\n",	strPath.data(), strPath.data());
		fprintf(fResults,i18n("Size: %s --> %s **** %.3ld strings replaced.<br><br>\n"), lviCurItem -> text(2), lviCurItem -> text(3), atol(lviCurItem -> text(2)));

    lviCurItem = lviCurItem -> nextSibling();
	} while(lviCurItem && lviCurItem != lviFirst);


	// d) Write the end of the file
	fprintf(fResults,"</DL><P></BODY></HTML>\n");
	fclose(fResults);
}

// ===========================================================================================================================
void KFileReplaceApp::timerEvent(QTimerEvent *)
{
	char szMess[MAX_MESSAGE];
	
	UpdateCommandsAccess();

	ShowResultList(g_nFilesRep > 0); // Show Result List if files found

	if (g_bThreadRunning == false) // Thread not running: it has finished since the last call of this function
	{	killTimers();
		view -> EnableWidgets(true); // Show widgets

		if (g_nFilesRep > 0) // Success
		{	sprintf(szMess, i18n("%ld files replaced successfully."), g_nFilesRep);
			slotStatusMsg(szMess);
  	}
	}
}

// ===========================================================================================================================
void KFileReplaceApp::resizeEvent( QResizeEvent *re )
{
	KTMainWindow::resizeEvent(re);	

	// Check the size has changed
  if (re && (re->size() == re->oldSize()))
    return;

	view -> ResizeWidgets(re);
}

// ===========================================================================================================================
void KFileReplaceApp::initMenuBar()
{	KStdAccel stdAccel;

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(Icon("mini/kfilereplaceapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW);
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("replace.xpm"), i18n("&Replace"), ID_FILE_REPLACE);
  file_menu->insertItem(Icon("stop.xpm"), i18n("&Stop"), ID_FILE_STOP);
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("save.xpm"), i18n("Sa&ve results"), ID_FILE_SAVE);
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("fileinfo.xpm"), i18n("&Informations about file"), ID_FILE_INFO);
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("Open &file"), ID_FILE_OPEN);
  file_menu->insertItem(Icon("diropen.xpm"), i18n("Open &Parent Directory"), ID_FILE_DIROPEN);
  file_menu->insertItem(Icon("filedel.xpm"), i18n("&Delete File"), ID_FILE_DELETE);
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

  // file_menu key accelerators
  file_menu->setAccel(stdAccel.replace(), ID_FILE_REPLACE);
  file_menu->setAccel(CTRL+Key_S, ID_FILE_STOP);
  file_menu->setAccel(CTRL+Key_I, ID_FILE_INFO);
  file_menu->setAccel(CTRL+Key_F, ID_FILE_OPEN);
  file_menu->setAccel(CTRL+Key_D, ID_FILE_DIROPEN);
  file_menu->setAccel(stdAccel.quit(), ID_FILE_QUIT);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR, m_bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, m_bViewStatusbar);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  //help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));
  help_menu->insertItem(i18n("KFileReplace &Home page"), ID_HELP_WEBSITE);
  help_menu->insertItem(i18n("&About KFileReplace..."), ID_HELP_ABOUT);


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
  CONNECT_CMD(view_menu);
  CONNECT_CMD(help_menu);

}

// ===========================================================================================================================
void KFileReplaceApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("replace.xpm"), ID_FILE_REPLACE, true, i18n("Replace"));
  toolBar()->insertButton(Icon("stop.xpm"), ID_FILE_STOP, true, i18n("Stop"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("save.xpm"), ID_FILE_SAVE, true, i18n("Save results"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("fileinfo.xpm"), ID_FILE_INFO, true, i18n("Informations about file"));
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open file"));
  toolBar()->insertButton(Icon("diropen.xpm"), ID_FILE_DIROPEN, true, i18n("Open Parent Directory"));
  toolBar()->insertButton(Icon("filedel.xpm"), ID_FILE_DELETE, true, i18n("Delete File"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands 


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(toolBar());

}

// ===========================================================================================================================
void KFileReplaceApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

// ===========================================================================================================================
void KFileReplaceApp::initView()
{ 
  doc = new KFileReplaceDoc(this);

  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  KApplication *app=KApplication::getKApplication();
  view = new KFileReplaceView(app,doc,this);
  setView(view);
}

// ===========================================================================================================================
bool KFileReplaceApp::queryExit()
{
  /*int exit=KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"));

  if(exit==1)*/
    return true;
  /*else
    return false; */
}

// ===========================================================================================================================
void KFileReplaceApp::saveOptions()
{
  KConfig *config = kapp->getConfig();
	QString strTemp;
  int i;

  config->setGroup("APPEARANCE");
  config->writeEntry("ShowToolbar",toolBar()->isVisible());
  config->writeEntry("ShowStatusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());

	// Get View's combo boxes
	QComboBox* comboDir = view -> GetComboDir();
	QComboBox* comboFilter = view -> GetComboFilter();
	QComboBox* comboSearch = view -> GetComboSearch();
	QComboBox* comboReplace = view -> GetComboReplace();

	// Combo box informations
	config->setGroup("Directories");
  for(i = 0; i < (int) comboDir -> count(); i++)
	{	strTemp.setNum(i+1);
		config->writeEntry(strTemp.data(), comboDir -> text(i));
  }

	config->setGroup("Filters");
  for(i = 0; i < (int) comboFilter -> count(); i++)
	{	strTemp.setNum(i+1);
		config->writeEntry(strTemp.data(), comboFilter -> text(i));
  }

	config->setGroup("SearchText");
  for(i = 0; i < (int) comboSearch -> count(); i++)
	{	strTemp.setNum(i+1);		
		config->writeEntry(strTemp.data(), comboSearch -> text(i));
  }

	config->setGroup("ReplaceText");
  for(i = 0; i < comboReplace -> count(); i++)
	{	strTemp.setNum(i+1);
		//KMsgBox::yesNo(this, strTemp, m_strReplaceText.at(i));	
		config->writeEntry(strTemp.data(), comboReplace -> text(i));
  }

	// Save options
	config->setGroup("Options");

	// Get values from QCheckBox
  config->writeEntry("RecursiveFolders", view -> GetCheckRecursiveFolders() -> isChecked());
  config->writeEntry("CaseSensitive", view -> GetCheckCaseSensitive() -> isChecked());
  config->writeEntry("Bakup", view -> GetCheckBakup() -> isChecked());
}

// ===========================================================================================================================
void KFileReplaceApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();
	QString str, strTemp;
	int i;

  config->setGroup("APPEARANCE");
  m_bViewToolbar = config->readBoolEntry("ShowToolbar", true);
  m_bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);
  tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);

	// Get View's combo boxes
	QComboBox* comboDir = view -> GetComboDir();
	QComboBox* comboFilter = view -> GetComboFilter();
	QComboBox* comboSearch = view -> GetComboSearch();
	QComboBox* comboReplace = view -> GetComboReplace();

	// Combo box informations
	config->setGroup("Directories");
	for(i = 0; i < MAX_STRINGSINCOMBO; i++)
	{	strTemp.setNum(i+1);
		str = config->readEntry(strTemp, "");		
		if (!str.isEmpty())
			comboDir -> insertItem(str.data());
  }

	config->setGroup("Filters");
	for(i = 0; i < MAX_STRINGSINCOMBO; i++)
	{	strTemp.setNum(i+1);
		str = config->readEntry(strTemp, "");		
		if (!str.isEmpty())
			comboFilter -> insertItem(str.data());
  }

	config->setGroup("SearchText");
	for(i = 0; i < MAX_STRINGSINCOMBO; i++)
	{	strTemp.setNum(i+1);
		str = config->readEntry(strTemp, "");	
		//KMsgBox::yesNo(this, i18n("Exit"), str);	
		if (!str.isEmpty())
			comboSearch -> insertItem(str.data());
  }

	config->setGroup("ReplaceText");
	for(i = 0; i < MAX_STRINGSINCOMBO; i++)
	{	strTemp.setNum(i+1);
		str = config->readEntry(strTemp, "");		
		if (!str.isEmpty())
			comboReplace -> insertItem(str.data());
  }

	// Read options
	config->setGroup("Options");

	// Set values from QCheckBox	
	view -> GetCheckRecursiveFolders() -> setChecked( config->readBoolEntry("RecursiveFolders", true) );
	view -> GetCheckCaseSensitive() -> setChecked( config->readBoolEntry("CaseSensitive", true) );
	view -> GetCheckBakup() -> setChecked( config->readBoolEntry("Bakup", true) );

	UpdateCommandsAccess();
}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

// ===========================================================================================================================
void KFileReplaceApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new KFileReplaceApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

// ===========================================================================================================================
void KFileReplaceApp::slotFileOpen()
{
	if (view -> GetListView() -> currentItem() == NULL) // If no selected item
		return ;

	QString tmp= "file:";
	KFM *kfm= new KFM();

	tmp.append(view -> GetListView() -> currentItem() -> text(1)); // Append Directory
	tmp.append("/"); // Append separator
	tmp.append(view -> GetListView() -> currentItem() -> text(0)); // Append Filename
	kfm->exec(tmp.data(),0L);

	delete kfm;
}

// ===========================================================================================================================
void KFileReplaceApp::slotFileStop()
{
	if (g_bThreadRunning == false) // If no thread running
		return ;

	// Stop the current thread
	g_bThreadMustStop = true;

	//pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
	//pthread_join(&g_threadReplace, NULL); // Wait the thread finished

}

// ===========================================================================================================================
void KFileReplaceApp::slotParentDirectoryOpen()
{
	QString tmp= "file:";

	if (view -> GetListView() -> currentItem() == NULL) // If no selected item
		return ;

	KFM *kfm= new KFM();
	tmp.append(view -> GetListView() -> currentItem() -> text(1)); // Append Directory
	kfm->exec(tmp.data(),0L);

	delete kfm;
}

// ===========================================================================================================================
void KFileReplaceApp::slotFileInfo()
{
	if (view -> GetListView() -> currentItem() == NULL) // If no selected item
		return ;

	QString strFilename;
	KFM *kfm= new KFM();

	strFilename.append(view -> GetListView() -> currentItem() -> text(1)); // Append Directory
	strFilename.append("/"); // Append separator
	strFilename.append(view -> GetListView() -> currentItem() -> text(0)); // Append Filename

	kfm->openProperties(strFilename.data());
	delete kfm;
}

// ===========================================================================================================================
void KFileReplaceApp::slotFileDelete()
{	QString strFilename;
	char szMess[MAX_MESSAGE];
  QFile qf;

	if (view -> GetListView() -> currentItem() == NULL) // If no selected item
		return ;

	strFilename.append(view -> GetListView() -> currentItem() -> text(1)); // Append Directory
	strFilename.append("/"); // Append separator
	strFilename.append(view -> GetListView() -> currentItem() -> text(0)); // Append Filename
	
  // The user must confirm the deletion of the file
  sprintf (szMess, "Are you sure you really want to delete the file %s ?", strFilename.data());
	if (KMsgBox::yesNo(this, "KFileReplace", szMess, KMsgBox::QUESTION) == 2) // No clicked
		return ; // Cancel

	qf.setName(strFilename.data());
	qf.remove();
	delete view -> GetListView() -> currentItem(); // Remove item from ListView
}

// ===========================================================================================================================
bool KFileReplaceApp::IsDateValid(char *szDate)
{	QRegExp qreDate("[0-9][0-9]?[/][0-9][0-9]?[/][0-9][0-9][0-9][0-9]");
	int nDay, nMonth, nYear;
	QDate qdDate;

	// a. Check the string is not empty, and the lenght is 2+1+2+1+4 = 10
	if (strlen(szDate) != 10)
		return false;

	// b. Check the format of the string: DD/MM/AAAA
	if (qreDate.match(szDate) != 0)
  	return false;

	// c. Check the date is valid (ex: 32/13/1999 is not valid)
	
	// Convert String to QDate
  sscanf(szDate, "%2d/%2d/%4d", &nDay, &nMonth, &nYear);
  qdDate.setYMD(nYear, nMonth, nDay);
	if (! qdDate.isValid() )
		return false;

	return true;
}

// ===========================================================================================================================
void KFileReplaceApp::slotFileReplace()
{
	int nRes;

	// ================= Check Thread is not running ========================
	if (g_bThreadRunning)
	{	KMsgBox::message(this, "KFileReplace", i18n("The replacing operation is already running. You must finish it before."), KMsgBox::EXCLAMATION, i18n("Cancel"));
		return;
	}

 	 // ================== DIRECTORY AND FILTER ========================
	QString strDir, strFilter;

	strDir.sprintf("%s", view -> GetComboDir() -> currentText());
	strFilter.sprintf("%s", view -> GetComboFilter() -> currentText());

	// Check Dir and Filter are not empty
	if (strDir.isEmpty() || strFilter.isEmpty() || view -> GetTextList() -> childCount() == 0) // If combo boxes are empty
	{	KMsgBox::message(this, "KFileReplace", i18n("You must fill all edit boxes and the text list before any operation."), KMsgBox::EXCLAMATION, i18n("Cancel"));	
    		return ;
	}

	// Check the last char of szDir is not '/'
	if (strDir.right(1) == "/")
		strDir.truncate(strDir.length()-1);
	
	// Get strings from combo Boxes and Insert items to Combo boxes
	bool bAlready;

	QComboBox* combo[2] = {view -> GetComboDir(), view -> GetComboFilter()};
	const char *szString[2] = {strDir.data(), strFilter.data()};

	for (int i=0; i < 2; i++)
	{	
		// Check string is not already in the combo
		bAlready = false;
		for (int j=0; j < combo[i] -> count(); j++)
		{	if ( strcmp(szString[i], combo[i] -> text(j)) == 0 )
				bAlready = true;
		}

		if (!bAlready) // Add it
		{	if (combo[i] -> count() >= MAX_STRINGSINCOMBO) // If full
				combo[i] -> removeItem(4);
		
			combo[i] -> insertItem(szString[i], 0);
		}
	}

  	// ================== GET LIST WIDGETS ========================
	QListView *lvResult;
	QListView *lvText;

	lvResult = view -> GetListView();
	lvText = view -> GetTextList();

 	 // =========================================== OPTIONS ==================================================
	bool bRecursive, bCaseSensitive, bBakup;
	bRecursive = view -> GetCheckRecursiveFolders() -> isChecked();
	bCaseSensitive = view -> GetCheckCaseSensitive() -> isChecked();
	bBakup = view -> GetCheckBakup() -> isChecked();
	
 	 // ================== SIZE OPTIONS ========================
	bool bMinSize, bMaxSize;
	uint nMinSize, nMaxSize;
	view -> GetMaxFilesSize(&bMaxSize, &nMaxSize);
	view -> GetMinFilesSize(&bMinSize, &nMinSize);

  	// ================== DATE OPTIONS ========================
	bool bDateOptionChecked;
	int nTypeOfAccess; // Read or Write access
	bool bMinDate, bMaxDate;
	QString strMinDate, strMaxDate;
	QDate qdMinDate, qdMaxDate;
	int nDay, nMonth, nYear;

	bDateOptionChecked = view -> GetCheckDateOption() -> isChecked();
	nTypeOfAccess = view -> GetComboDateRW() -> currentItem();
	bMinDate = view -> GetCheckDateMin() -> isChecked();
	bMaxDate = view -> GetCheckDateMax() -> isChecked();
	strMinDate.sprintf("%s", view -> GetEditDateMin() -> text());
	strMaxDate.sprintf("%s", view -> GetEditDateMax() -> text());

	// Check option "Size Min/Max": check MinSize is not greater than MaxSize
	if (bMaxSize && bMinSize && nMaxSize < nMinSize)
	{ KMsgBox::message(this, "KFileReplace", i18n("In option \"Size & Date\", the MINimal size is greater than the MAXimal size."), KMsgBox::EXCLAMATION, i18n("Cancel"));
		return ;
	}

	// Check option "Date Min/Max": check date is Valid
	// Check 2 things: * QRegExp ==> Texte Valide (2/2/4)
	//                 * QDate::isValid()

	if (bDateOptionChecked) // If "Date Option" is checked
	{
   		 // 1. Check the first Date: DateMin (After...)
		if (bMinDate) // If "DateMin" option in checked
		{	if ( !IsDateValid(strMinDate.data()))
			{ KMsgBox::message(this, "KFileReplace", i18n("The dates in \"Size & Date\" must be in the DD/MM/AAAA format."), KMsgBox::EXCLAMATION, i18n("Cancel"));
				return ;
			}
		}
			
    		// 2. Check the second Date: DateMax (Before...)
		if (bMaxDate) // If "DateMax" option in checked
		{	if ( !IsDateValid(strMaxDate.data()))
			{ KMsgBox::message(this, "KFileReplace", i18n("The dates in \"Size & Date\" must be in the DD/MM/AAAA format."), KMsgBox::EXCLAMATION, i18n("Cancel"));
				return ;
			}
		}

		// 3. Convert Strings to QDate		
		if (bMinDate) // If "DateMin" option in checked
		{	sscanf(strMinDate.data(),"%2d/%2d/%4d",&nDay, &nMonth, &nYear);
			qdMinDate.setYMD(nYear, nMonth, nDay);
		}

		if (bMaxDate) // If "DateMax" option in checked
		{	sscanf(strMaxDate.data(),"%2d/%2d/%4d",&nDay, &nMonth, &nYear);
			qdMaxDate.setYMD(nYear, nMonth, nDay);
		}

		// 4. Check DateMax is not before DateMin
		if (bMinDate && bMaxDate && qdMinDate > qdMaxDate)
		{ KMsgBox::message(this, "KFileReplace", i18n("In option \"Size & Date\", the MINimal Date is after the MAXimal Date."), KMsgBox::EXCLAMATION, i18n("Cancel"));
			return ;
		}
	}

 	 // ================== Prepare argument structure to pass to the ReplaceDirectory function ========================

	
	sprintf (g_argu.szDir, "%s", strDir.data());
	sprintf (g_argu.szFilter, "%s", strFilter.data());
	g_argu.lvResult = lvResult;
	g_argu.lvText = lvText;
	g_argu.bMinSize = bMinSize;
	g_argu.bMaxSize = bMaxSize;
	g_argu.nMinSize = nMinSize;
	g_argu.nMaxSize = nMaxSize;
	g_argu.bDateOptionChecked = bDateOptionChecked;
	g_argu.nTypeOfAccess = nTypeOfAccess;
	g_argu.bMinDate = bMinDate;
	g_argu.bMaxDate = bMaxDate;
	g_argu.qdMinDate = qdMinDate;
	g_argu.qdMaxDate = qdMaxDate;
	g_argu.bCaseSensitive = bCaseSensitive;
	g_argu.bRecursive = bRecursive;
	g_argu.bBakup = bBakup;
	g_argu.app = (QWidget *) this;

  	slotStatusMsg(i18n("Replacing files..."));
	
	// Clear the list view
	view -> GetListView() -> clear();

	// Run the Replacing operation Thread
	g_bThreadRunning = true;
	view -> EnableWidgets(false);
	UpdateCommandsAccess();
	nRes = pthread_create(&g_threadReplace, NULL, ReplaceThread, (void *) &g_argu);

	if (nRes != 0) // Can't create Thread	
	{	slotStatusMsg(i18n("Can't create thread to run the replace operation."));
		return ;
	}
	else // if success
	{	startTimer(100);
	}
}

// ===========================================================================================================================
void KFileReplaceApp::slotFileQuit()
{ 
	// Check Thread is not running
	if (g_bThreadRunning)
	{	KMsgBox::message(this, "KFileReplace", i18n("You can't quit before having finished the replacing operation."), KMsgBox::EXCLAMATION, i18n("Cancel"));
		return;
	}

  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit())
    {
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
    }
  else
    slotStatusMsg(IDS_DEFAULT);
    return;
}

// ===========================================================================================================================
void KFileReplaceApp::slotHelpWebSite()
{	if(vfork() > 0)
	{ // drop setuid, setgid
    setgid(getgid());
    setuid(getuid());

    execlp("kfmclient", "kfmclient", "exec", QString("http://perso.club-internet.fr/dupoux/sysexp/linux/kfilerep/").data(), 0);
    _exit(0);
  }
}

// ===========================================================================================================================
void KFileReplaceApp::slotHelpAbout()
{
  QMessageBox aboutmsg(this, "About KFileReplace");
  aboutmsg.setCaption(i18n("About KFileReplace..."));
  aboutmsg.setButtonText(1, i18n("OK"));
  aboutmsg.setText("\t           KFileReplace version "VERSION" \n\n\n"
                   "Franois Dupoux <fdupoux@lemel.fr>\n\n"
                   "http://perso.club-internet.fr/dupoux/sysexp/linux/kfilerep/\n");

  QPixmap pm;
  pm.load(KApplication::kde_datadir() + "/kfilereplace/pics/about.bmp");
  aboutmsg.setIconPixmap(pm);
  aboutmsg.show();

}

// ===========================================================================================================================
void KFileReplaceApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  m_bViewToolbar=!m_bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, m_bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  enableToolBar(m_bViewToolbar ? KToolBar::Show : KToolBar::Hide,0);
  slotStatusMsg(IDS_DEFAULT);
}

// ===========================================================================================================================
void KFileReplaceApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  m_bViewStatusbar=!m_bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, m_bViewStatusbar);
  enableStatusBar();
  enableStatusBar(m_bViewStatusbar ? KStatusBar::Show : KStatusBar::Hide);
  slotStatusMsg(IDS_DEFAULT);
}


// ===========================================================================================================================
void KFileReplaceApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}


// ===========================================================================================================================
void KFileReplaceApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



// ===========================================================================================================================
void KFileReplaceApp::commandCallback(int id_)
{
  switch (id_)
	{
    ON_CMD(ID_FILE_NEW_WINDOW,          slotFileNewWindow())
    ON_CMD(ID_FILE_REPLACE,             slotFileReplace())
    ON_CMD(ID_FILE_SAVE,                slotFileSaveResults())
    ON_CMD(ID_FILE_STOP,                slotFileStop())
    ON_CMD(ID_FILE_INFO,                slotFileInfo())
    ON_CMD(ID_FILE_OPEN,                slotFileOpen())
		ON_CMD(ID_FILE_DIROPEN,             slotParentDirectoryOpen())
    ON_CMD(ID_FILE_DELETE,              slotFileDelete())
    ON_CMD(ID_FILE_QUIT,                slotFileQuit())

    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())

    ON_CMD(ID_HELP_WEBSITE,             slotHelpWebSite())
    ON_CMD(ID_HELP_ABOUT,               slotHelpAbout())
  }
}


// ===========================================================================================================================
void KFileReplaceApp::statusCallback(int id_)
{
  switch (id_)
	{
    ON_STATUS_MSG(ID_FILE_NEW_WINDOW,   i18n("Opens a new application window"))
    ON_STATUS_MSG(ID_FILE_REPLACE,      i18n("Replace"))
    ON_STATUS_MSG(ID_FILE_SAVE,         i18n("Save results in a HTML file"))
		ON_STATUS_MSG(ID_FILE_STOP,         i18n("Stop the current replace operation"))
    ON_STATUS_MSG(ID_FILE_INFO,         i18n("Draw informations about selected file"))
    ON_STATUS_MSG(ID_FILE_OPEN,         i18n("Open selected file"))
		ON_STATUS_MSG(ID_FILE_DIROPEN,      i18n("Open the parent directory of the file"))
    ON_STATUS_MSG(ID_FILE_DELETE,       i18n("Delete selected file"))
    ON_STATUS_MSG(ID_FILE_QUIT,         i18n("Exits the program"))

    ON_STATUS_MSG(ID_VIEW_TOOLBAR,      i18n("Enables / disables the actual Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,    i18n("Enables / disables the Statusbar"))

    ON_STATUS_MSG(ID_HELP_WEBSITE,      i18n("Go to KFileReplace Home Page"))
    ON_STATUS_MSG(ID_HELP_ABOUT,        i18n("Draw informations about program"))
  }
}






























































































































