/***************************************************************************
                          apifiles.cpp  -  description
                             -------------------
    begin                : Sat Sep 25 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@lemel.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kfilereplacedoc.h>
#include <kfilereplaceview.h>
#include "kfilereplace.h"
#include "apistruct.h"

#include <qdir.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qregexp.h>


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/param.h>
#include <sys/vfs.h>
#include <sys/stat.h>
#include <sys/statvfs.h>
#include <errno.h>
#include <ctype.h>

#include <kmsgbox.h>
#include <ktablistbox.h>

#include "apistruct.h"
#include "apifiles.h"
#include "resource.h"


// ===========================================================================================================================
void *ReplaceThread(void *param)
{	int nRes;
	RepDirArg *argu;
	argu = (RepDirArg *) param;

	g_bThreadRunning = true;



	// Call another function to make easier to verify Thread Variables
	nRes = ReplaceDirectory(argu -> szDir, argu, true); // true --> replace

	// The thread always finished here: success or error
	g_nFilesRep = nRes; // Number of replaced files
	g_bThreadRunning = false;
	
  /*if (nRes == -1) // Error
	{	pthread_exit(-1);
		return 0;
	}
	else // Success
	{	pthread_exit(nRes);
		return 0;
	} */
}

// ===========================================================================================================================
void *SearchThread(void *param)
{	int nRes;
	RepDirArg *argu;
	argu = (RepDirArg *) param;

	g_bThreadRunning = true;

	// Call another function to make easier to verify Thread Variables
	nRes = ReplaceDirectory(argu -> szDir, argu, false); // false --> search

	// The thread always finished here: success or error
	g_nFilesRep = nRes; // Number of replaced files
	g_bThreadRunning = false;

  /*if (nRes == -1) // Error
	{	pthread_exit(-1);
		return 0;
	}
	else // Success
	{	pthread_exit(nRes);
		return 0;
	} */
}

// ===========================================================================================================================
int ReplaceDirectory(char *szDir, RepDirArg* argu, bool bReplace)
{	char szFileReadpath[MAXPATHLEN];
	char szFileWritepath[MAXPATHLEN];
	char szDirpath[MAXPATHLEN];
	char szBakup[MAXPATHLEN];
	char szTemp[MAXPATHLEN];
	QDir dir;
	QFileInfo fi, fiOld, fiNew;
	int nRes;
	int i;
	int nNbRepFiles = 0;
	bool bNeedReplace; // Total Nb Rep made in the current function
	int nNbReplacements; // Nb Rep made in a call to ReplaceFile
	uint nDiskFreeSpace;
	int nAccess;
	QListViewItem *lvi;
	QString strTemp;

	KFileReplaceApp *app;
	app = (KFileReplaceApp *) (argu -> app);

	// What type of files we must lis
	dir.setFilter(QDir::Files | QDir::Readable);
	dir.setPath(szDir);
	dir.setNameFilter(argu -> szFilter);

	// 0. -*-*-*-*-*-*-*-*-*- Check it's a valid directory -*-*-*-*-*-*-*-*-*-
	if (!dir.isReadable() || !dir.exists())
	{	sprintf (g_szErrMsg, i18n("Can't access to directory %s"), szDir);
		return -1;
	}
	
	// 1. -*-*-*-*-*-*-*-*-*- First, list all files -*-*-*-*-*-*-*-*-*-

	// If directory doesn't exists
	if (!dir.exists())
	{	//sprintf (g_szErrMsg, i18n("Directory %s doesn't exists"), szDir);
		return -1;
	}

	for (i=0; i < dir.count(); i++)
	{
    // Check the Thread needn't to stop
		if (g_bThreadMustStop == true)
		{ return -1;
		}

		sprintf (szFileWritepath, "%s/%s.new", szDir, dir[i]);
		sprintf (szFileReadpath, "%s/%s", szDir, dir[i]);
		fiOld.setFile(szFileReadpath);

		// Check the file is not a .OLD (Bakup) file
	 	strcpy(szTemp, dir[i]+strlen(dir[i])-4);

    // if the file dates & size are correct for options
		if (strcmp(szTemp, ".old") != 0 && IsFileGoodSizeProperties(szFileReadpath, argu -> bMinSize, argu -> bMaxSize, argu -> nMinSize, argu -> nMaxSize)
    		&& ((argu -> bMinDate == false && argu -> bMaxDate == false) || (IsFileGoodDateProperties(szFileReadpath, argu -> nTypeOfAccess, argu -> bMinDate, argu -> bMaxDate, argu -> qdMinDate, argu -> qdMaxDate))))
		{

			// Test read access for file
			nAccess = access(szFileReadpath, F_OK | R_OK);
			if (nAccess == -1) // We don't have access to the file
			{	sprintf (g_szErrMsg, i18n("Can't access to the file %s in reading mode."), szFileReadpath);
				argu -> view -> ListView_AddFullItem(false, dir[i], szDir, fiOld.size(), 0, 0, g_szErrMsg);
				fprintf(stderr, "%s\n", g_szErrMsg);
			}
      if (nAccess == 0) // If access is okay
			{	fprintf(stderr,"%s*\n", szFileReadpath);

				// ***** IF SEARCHNIG *******
				if (bReplace == false)
				{
					// If there are strings to search
        	if (argu -> qlvStrings -> childCount() > 0)
					{
						// Add the item in the list, but without details
						strTemp = formatSize(fiOld.size());
						lvi = new QListViewItem(argu -> qlvResult, dir[i], szDir, strTemp.data());
						if (lvi == 0) // Not enought memory
							return -1;
      			
						// Run the search operation									
						nRes = SearchFile(lvi, szFileReadpath, argu -> bCaseSensitive, &nNbReplacements, argu);
						if (nRes == 0)
						{	// Update Result ListView	if found	
							if (nNbReplacements > 0)
							{	nNbRepFiles++;
								argu -> view -> ListView_UpdateItem(lvi, true, fiOld.size(), nNbReplacements);
								//argu -> view -> ListView_AddFullItem(true, dir[i], szDir, fiOld.size(), fiOld.size(), nNbReplacements);
							}
							else // No strings found
								delete lvi;
						
						}
						else // (nRes == -1)
						{	// Update Result ListView	if found	
							nNbRepFiles++;
							argu -> view -> ListView_AddFullItem(false, dir[i], szDir, fiOld.size(), 0, 0, g_szErrMsg);
						}

					}
					else // if there are no strigns to search
					{	nNbRepFiles++;
						argu -> view -> ListView_AddFullItem(true, dir[i], szDir, fiOld.size(), fiOld.size(), 0);
					}

				}
				else // ******* IF REPLACING *******
      	{
    			// Test read access for file
					nAccess = access(szFileReadpath, F_OK | R_OK | W_OK);
					if (nAccess == -1) // We don't have access to the file
					{	sprintf (g_szErrMsg, i18n("Can't access to the file %s in writing mode."), szFileReadpath);
						argu -> view -> ListView_AddFullItem(false, dir[i], szDir, fiOld.size(), 0, 0, g_szErrMsg);
						fprintf(stderr, "%s\n", g_szErrMsg);
					}
      		if (nAccess == 0) // If access is okay
   		    {	
						// Get Number of occurrences in Old File
						fprintf(stderr,"In DoesFileNeedReplace %s\n", szFileReadpath);
						nRes = DoesFileNeedReplace(szFileReadpath, &bNeedReplace, argu);
						fprintf(stderr,"Out DoesFileNeedReplace %s\n", szFileReadpath);
  					if (nRes == -1)
							return -1;

						if (bNeedReplace) // Replace only if there are occurrences
						{	
							// Check there is enought free disk space
							nRes = GetDiskFreeSpaceForFile(&nDiskFreeSpace, szFileReadpath);
							if (nRes != -1 && nDiskFreeSpace < fiOld.size())
							{	sprintf (g_szErrMsg, i18n("There is not enought disk free space to replace in the file %s."), szFileReadpath);
								return -1;
							}
							
							// Add the item in the list, but without details
							strTemp = formatSize(fiOld.size());
							lvi = new QListViewItem(argu -> qlvResult, dir[i], szDir, strTemp.data());
							if (lvi == 0) // Not enought memory
								return -1;
      			
							// Run the replace operation									
							fprintf(stderr,"In ReplaceFile %s\n", szFileReadpath);
							nRes = ReplaceFile(lvi, szFileReadpath, szFileWritepath, argu -> bCaseSensitive, &nNbReplacements, argu);
							fprintf(stderr,"Out ReplaceFile %s\n", szFileReadpath);
							if (nRes == 0) // If success
							{	nNbRepFiles++;

								// Update Result ListView		
								fiNew.setFile(szFileWritepath);
								argu -> view -> ListView_UpdateItem(lvi, true, fiNew.size(), nNbReplacements);
							}
							else //(nRes == -1) // Error
							{	// Update Result ListView		
								argu -> view -> ListView_UpdateItem(lvi, false, 0, 0, g_szErrMsg);
							}
  		
							if (argu -> bBakup) // Create a backup of the file if option is true
							{	sprintf (szBakup, "%s/%s.old", szDir, dir[i]);
								nRes = unlink(szBakup); // Delete OLD file if exists
								nRes = rename(szFileReadpath, szBakup);
							}
							else // Delete the old file
							{	nRes = unlink(szFileReadpath);
							}

							// Rename the new file into OldFileName
 							nRes = rename(szFileWritepath, szFileReadpath);
						}
					}

				}
			}

		}
	}

	// 2. -*-*-*-*-*-*-*-*-*- Second, list all dir -*-*-*-*-*-*-*-*-*-

	if (argu -> bRecursive) // If we must explore sub directories
	{	// What type of files we must lis
		dir.setFilter(QDir::Dirs | QDir::Readable | QDir::Executable);
		dir.setPath(szDir);
		dir.setNameFilter("*");

		for (i=0; i < dir.count(); i++)
		{ if (strcmp(dir[i], ".") != 0 && strcmp(dir[i], "..") != 0)
			{	sprintf (szDirpath, "%s/%s", szDir, dir[i]); 	  	
				nRes = ReplaceDirectory(szDirpath, argu, bReplace); // Use recursivity
				if (nRes == -1) // If error
					return -1; // Stop the operation
				nNbRepFiles += nRes;
			}
		}
	}

	return nNbRepFiles;
}

// ==================================================================================
bool IsFileGoodSizeProperties(char *szFileName, bool bMinSize, bool bMaxSize, uint nMinSize, uint nMaxSize)
{	// If Minimal Size Option is Checked
	QFileInfo fi;
	fi.setFile(szFileName);

	bool bCond = (bMinSize && fi.size() < nMinSize || bMaxSize && fi.size() > nMaxSize);

	return (!bCond);
}

// ==================================================================================
bool IsFileGoodDateProperties(char *szFileName, int nTypeOfAccess, bool bMinDate, bool bMaxDate, QDate qdMinDate, QDate qdMaxDate)
{	// If Minimal Size Option is Checked
	QFileInfo fi;
	fi.setFile(szFileName);
	QDate dateFiledate; // Date of the file we must to compare with dateLimit
	
  // Get the File Date
	if (nTypeOfAccess == 0) // Last WRITE date
		dateFiledate = fi.lastModified().date();
	if (nTypeOfAccess == 1) // Last READ date
		dateFiledate = fi.lastRead().date();

  if (bMinDate && dateFiledate < qdMinDate) // Check the Minimal Date (After ...)
			return false;

  if (bMaxDate && dateFiledate > qdMaxDate) // Check the Maximal Date (Before ...)
			return false;

	return true; // File is valid
}

// ==================================================================================
int DoesFileNeedReplace(char *szOldFile, bool *bNeedReplace, RepDirArg* argu)
{		
	int nFdOldFile; // File descriptors
	uint nOldFileSize;
	char *cBeginOldFile; // Pointer to the begin of the file
	char *cOldPt; // Pointer to the current data
	char *s1, *s2;
	QListViewItem *lviCurItem;
	QListViewItem *lviFirst;
	int nItemPos;

	KFileReplaceApp *app;
	app = (KFileReplaceApp *) (argu -> app);

	// Items of the string list
  QString strOld[MAX_STRINGSTOSEARCHREP];

	// Copy strings to search/remplace into strings in memory
	nItemPos = 0;
	lviCurItem = lviFirst = argu -> qlvStrings -> firstChild();
	if (lviCurItem == NULL)
	{	sprintf (g_szErrMsg, i18n("Can't list tree items"));
		return -1;
  }

	do
	{	strOld[nItemPos] = lviCurItem -> text(0);		
		nItemPos++;
		lviCurItem = lviCurItem -> nextSibling();
	 } while(lviCurItem && lviCurItem != lviFirst);

	// 0. Init
	*bNeedReplace = false;
	QFileInfo fiOld(szOldFile);
	nOldFileSize = fiOld.size();

	// 1. Check we have the file writing access right // ALREADY DONE IN REPLACEDIRECTORY()
	/*nRes = access(szOldFile, F_OK | R_OK | W_OK);
	if (nRes == -1) // We don't have access to the file
	{	sprintf (g_szErrMsg, i18n("Can't access to the file %s. Maybe writing is forbidden"), szOldFile);
		fprintf(stderr, "Can't access to file %s", szOldFile);
		return -1;
	}*/

	// 2. Open files
	nFdOldFile = open(szOldFile, O_RDONLY);
	if (nFdOldFile == -1)
	{	sprintf (g_szErrMsg, i18n("Can't open file %s for reading"), szOldFile);
		return -1;
	}

	// 3. Map files
	cBeginOldFile = mmap((caddr_t)0, nOldFileSize, PROT_READ, MAP_SHARED, nFdOldFile, 0);
	if ((caddr_t) cBeginOldFile == MAP_FAILED)
	{	sprintf (g_szErrMsg, i18n("Can't open file %s for reading"), szOldFile);
		close(nFdOldFile);
		return -1;
	}

	cOldPt = cBeginOldFile;

	// --------------------------------------------

	while ( ((cOldPt - (char *) cBeginOldFile) < nOldFileSize)) // While not end of file
	{
		begin_prepare:

		for (int i=0; i < argu -> qlvStrings -> childCount(); i++) // For all strings to replace
		{
			s1 = cOldPt;
			s2 = strOld[i].data();

			if (argu -> bCaseSensitive == TRUE) // si il faut respecter la casse
				while ( *s1 && *s2 && *s1 == *s2 )
				{	s1++;
					s2++;
				}
			else // si il ne faut pas respecter la casse
				while ( *s1 && *s2 && tolower(*s1) == tolower(*s2) )
				{	s1++;
					s2++;
				}

			if (*s2 == 0) // Si le mot entier est trouv
			{ *bNeedReplace = true;
				// Unamp files and close files
				munmap(cBeginOldFile, nOldFileSize);
				close(nFdOldFile);
      			
				return 0; // Success
			}
		}

		// Searched Text not present: copy char
		cOldPt++;

	}
	
	// --------------------------------------------

	// Unamp files and close files
	munmap(cBeginOldFile, nOldFileSize);
	close(nFdOldFile);

	return 0; // Success
}

// ==================================================================================
int ReplaceFile(QListViewItem *lvi, char *szOldFile, char *szNewFile, bool bCaseSensitive, int *nNbReplacements, RepDirArg* argu)
{	int nFdOldFile, nFdNewFile; // File descriptors
	void *vBeginOldFile;
	char *cBeginOldFile; // Pointer to the begin of the file
	char *cOldPt; // Pointer to the current data
	char *s1, *s2;
	int nRes;
	uint nOldFileSize;
	QListViewItem *lviCurItem;
	QListViewItem *lviFirst;
	int nItemPos;
	struct stat statFile;

	KFileReplaceApp *app;
	app = (KFileReplaceApp *) (argu -> app);

	// Items of the string list
	int nReplaceCount[MAX_STRINGSTOSEARCHREP];	
  QString strOld[MAX_STRINGSTOSEARCHREP];
  QString strNew[MAX_STRINGSTOSEARCHREP];

	// 0. Init
	*nNbReplacements = 0;
	QFileInfo fiOld(szOldFile);
	nOldFileSize = fiOld.size();

	// 1. Check we have the file writing access right  // ALREADY DONE IN REPLACEDIRECTORY()
	/*nRes = access(szOldFile, F_OK | R_OK | W_OK);
	if (nRes == -1) // We don't have access to the file
	{	sprintf (g_szErrMsg, i18n("Can't access to the file %s. Maybe writing is forbidden"), szOldFile);
		return -1;
	}*/

	// 2. Open files
	nFdOldFile = open(szOldFile, O_RDONLY);
	if (nFdOldFile == -1)
	{	sprintf (g_szErrMsg, i18n("Can't open file %s for reading"), szOldFile);
		return -1;
	}

 	nFdNewFile = open(szNewFile, O_CREAT | O_TRUNC | O_RDWR, S_IRWXU);
	if (nFdNewFile == -1)
	{	sprintf (g_szErrMsg, i18n("Can't open file %s for writing"), szNewFile);
		return -1;
	}

	// 3. Put new file the access rights of the old file
	nRes = fstat(nFdOldFile, &statFile);
  if (nRes == -1)
	{	sprintf (g_szErrMsg, i18n("Can't read file %s access rights"), szOldFile);
		return -1;
	}

	nRes = fchmod(nFdNewFile, statFile.st_mode);
  if (nRes == -1)
	{	sprintf (g_szErrMsg, i18n("Can't put file %s access rights"), szNewFile);
		return -1;
	}

	// Map files
	vBeginOldFile = mmap((caddr_t)0, nOldFileSize, PROT_READ, MAP_SHARED, nFdOldFile, 0);
	if ((caddr_t) vBeginOldFile == MAP_FAILED)
	{	sprintf (g_szErrMsg, i18n("Can't map file %s for reading"), szOldFile);
		close(nFdOldFile);
		return -1;
	}

	cBeginOldFile = (char *) vBeginOldFile;
	cOldPt = cBeginOldFile;

	// Copy strings to search/remplace into strings in memory
	nItemPos = 0;
	lviCurItem = lviFirst = argu -> qlvStrings -> firstChild();
	if (lviCurItem == NULL)
	{	sprintf (g_szErrMsg, i18n("Can't list tree items"));
		return -1;
  }

	do
	{	strOld[nItemPos] = lviCurItem -> text(0);		
		strNew[nItemPos] = lviCurItem -> text(1);
		nReplaceCount[nItemPos] = 0;		
		nItemPos++;
		lviCurItem = lviCurItem -> nextSibling();
	 } while(lviCurItem && lviCurItem != lviFirst);

	// --------------------------------------------
	while ( ((cOldPt - (char *) cBeginOldFile) < nOldFileSize)) // While not end of file
	{	begin_replace:

		for (int i=0; i < argu -> qlvStrings -> childCount(); i++) // For all strings to replace
		{	s1 = cOldPt;
			s2 = strOld[i].data();

			if (bCaseSensitive == TRUE) // si il faut respecter la casse
				while ( *s1 && *s2 && *s1 == *s2 )
				{	s1++;
					s2++;
				}
			else // si il ne faut pas respecter la casse
				while ( *s1 && *s2 && tolower(*s1) == tolower(*s2) )
				{	s1++;
					s2++;
				}

			if (*s2 == 0) // Si le mot entier est trouv
			{	// Remplacer
				(*nNbReplacements)++;
				(nReplaceCount[i])++; // Number of replacements for this string

				// Write new text in new file
				nRes = write(nFdNewFile, strNew[i].data(), strNew[i].length());
				if (nRes != strNew[i].length())
				{	// Free allocated memory
					sprintf(g_szErrMsg, i18n("Can't write data in %s"), szNewFile);
					return -1;
				}

				cOldPt += strOld[i].length(); // Dans le fichier en lecture (ancien) on passe le chaine cherche
				goto begin_replace; // Do not make other replace on this byte
			}

		} ;

		// Searched Text not present: copy char
		nRes = write(nFdNewFile, cOldPt, 1);
		if (nRes != 1)
		{	sprintf(g_szErrMsg, i18n("Can't write data in %s"), szNewFile);
			return -1;
		}

		cOldPt++;
	}
	
	// --------------------------------------------

	// Unamp files
	munmap(vBeginOldFile, nOldFileSize);

	// Close files
	close(nFdOldFile);
	close(nFdNewFile);

  // Create ListView tree inside item with replacements details
	QListViewItem *lviDetails;
	QString strTitle;


	for (int i=0; i < argu -> qlvStrings -> childCount(); i++)
	{	
		if (nReplaceCount[i] > 0)
		{	strTitle.sprintf("%s = %ld", strOld[i].data(), nReplaceCount[i]);
			lviDetails = new QListViewItem(lvi, strTitle.data());
			if (lviDetails)	
				lviDetails -> setPixmap(0, argu -> view -> getIconString());
		}	
	 }

	return 0; // Success
}

// ==================================================================================
int SearchFile(QListViewItem *lvi, char *szOldFile, bool bCaseSensitive, int *nNbReplacements, RepDirArg* argu)
{	int nFdOldFile; // File descriptors
	void *vBeginOldFile;
	char *cBeginOldFile; // Pointer to the begin of the file
	char *cOldPt; // Pointer to the current data
	char *s1, *s2;
	uint nOldFileSize;
	QListViewItem *lviCurItem;
	QListViewItem *lviFirst;
	int nItemPos;

	KFileReplaceApp *app;
	app = (KFileReplaceApp *) (argu -> app);

	// Items of the string list
	int nReplaceCount[MAX_STRINGSTOSEARCHREP];	
  QString strOld[MAX_STRINGSTOSEARCHREP];

	// 0. Init
	*nNbReplacements = 0;
	QFileInfo fiOld(szOldFile);
	nOldFileSize = fiOld.size();

	// 1. Open files
	nFdOldFile = open(szOldFile, O_RDONLY);
	if (nFdOldFile == -1)
	{	sprintf (g_szErrMsg, i18n("Can't open file %s for reading"), szOldFile);
		return -1;
	}

	// Map files
	vBeginOldFile = mmap((caddr_t)0, nOldFileSize, PROT_READ, MAP_SHARED, nFdOldFile, 0);
	if ((caddr_t) vBeginOldFile == MAP_FAILED)
	{	sprintf (g_szErrMsg, i18n("Can't map file %s for reading"), szOldFile);
		close(nFdOldFile);
		return -1;
	}
 	
	cBeginOldFile = (char *) vBeginOldFile;
	cOldPt = cBeginOldFile;

	// Copy strings to search/remplace into strings in memory
	nItemPos = 0;
	lviCurItem = lviFirst = argu -> qlvStrings -> firstChild();
	if (lviCurItem == NULL)
	{	sprintf (g_szErrMsg, i18n("Can't list tree items"));
		return -1;
  }

	// Copy strings to search/remplace into strings in memory
	nItemPos = 0;
	lviCurItem = lviFirst = argu -> qlvStrings -> firstChild();
	if (lviCurItem == NULL)
	{	sprintf (g_szErrMsg, i18n("Can't list tree items"));
		return -1;
  }

	do
	{	strOld[nItemPos] = lviCurItem -> text(0);		
		nReplaceCount[nItemPos] = 0;		
		nItemPos++;
		lviCurItem = lviCurItem -> nextSibling();
	 } while(lviCurItem && lviCurItem != lviFirst);

	// --------------------------------------------
	while ( ((cOldPt - (char *) cBeginOldFile) < nOldFileSize)) // While not end of file
	{	begin_search:

		for (int i=0; i < argu -> qlvStrings -> childCount(); i++) // For all strings to search
		{	
			s1 = cOldPt;
			s2 = strOld[i].data();

			if (bCaseSensitive == TRUE) // si il faut respecter la casse
				while ( *s1 && *s2 && *s1 == *s2 )
				{	s1++;
					s2++;
				}
			else // si il ne faut pas respecter la casse
				while ( *s1 && *s2 && tolower(*s1) == tolower(*s2) )
				{	s1++;
					s2++;
				}

			if (*s2 == 0) // Si le mot entier est trouv
			{	(*nNbReplacements)++;
				(nReplaceCount[i])++; // Number of replacements for this string
				
				cOldPt += strOld[i].length(); // Dans le fichier en lecture (ancien) on passe le chaine cherche
				goto begin_search; // Do not make other search on this byte
			}

		}

		cOldPt++;
	}
	
	// --------------------------------------------

	// Unamp files
	munmap(vBeginOldFile, nOldFileSize);

	// Close files
	close(nFdOldFile);

  // Create ListView tree inside item with replacements details
	QListViewItem *lviDetails;
	QString strTitle;

	for (int i=0; i < argu -> qlvStrings -> childCount(); i++)
	{	
		if (nReplaceCount[i] > 0)
		{	strTitle.sprintf("%s = %ld", strOld[i].data(), nReplaceCount[i]);
			lviDetails = new QListViewItem(lvi, strTitle.data());
			if (lviDetails)	
				lviDetails -> setPixmap(0, argu -> view -> getIconString());
		}	
	}

	return 0; // Success
}


// ===========================================================================================================================
int GetDiskFreeSpaceForFile(uint *nAvailDiskSpace, char *szFilename)			
{
	int nRes;
	struct statvfs fsInfo;

	*nAvailDiskSpace = 0;

	nRes = statvfs(szFilename, &fsInfo);
	if (nRes == -1)	
		return -1;	

	*nAvailDiskSpace = fsInfo.f_bavail * fsInfo.f_bsize;

	return 0;
}
















