#
#  testPuKDE2.py (C) 2001 Jim Bublitz <jbublitz@nwinternet.com>
#

# Simple tests to verify operation of manually written code for PyKDE

from kdecore import KAccel, KStdAccel, kapp, KCmdLineArgs, KURL, KApplication, i18n, KAboutData,\
        BarIcon, NETRootInfo

from kdeui import KMainWindow, KMessageBox

from kfile import KFileDialog

from qt import QMultiLineEdit, QPopupMenu, QFile, QTextStream, QDir, SLOT, SIGNAL,\
        QString, IO_ReadOnly, QImage, QImageDrag, QTextDrag

import testkdeui, testdcop, testkdecore

import sys

FALSE = 0
TRUE  = not FALSE

TOOLBAR_EXIT = 0
TOOLBAR_OPEN = 1


class KTestPyKDE(KMainWindow):
        def __init__ (self, *args):
                apply (KMainWindow.__init__, (self,) + args)
                self.edit = QMultiLineEdit(self)
                self.setCentralWidget(self.edit)
                self.setAcceptDrops(TRUE)

                p = QPopupMenu (self)

                self.a = KAccel(self)
                self.a.connectItem(KStdAccel.New, self.slotNewWindow)
                self.a.connectItem(KStdAccel.Open, self.slotLoadFile)
                self.a.connectItem(KStdAccel.Quit, kapp.quit)

                id = p.insertItem(i18n("&New Window"), self.slotNewWindow)
                self.a.changeMenuAccel(p, id, KStdAccel.New)
                p.setItemEnabled (id, self.parent () == None)
                id = p.insertItem(i18n("&Open"), self.slotLoadFile)
                self.a.changeMenuAccel(p, id, KStdAccel.Open)
                p.insertSeparator()
                id = p.insertItem(i18n("&Quit"), self.close)
                self.a.changeMenuAccel(p, id, KStdAccel.Quit)

                #// put the popupmenu as File-menu into the menu bar
                self.menuBar().insertItem(i18n("&File"), p)
                self.menuBar().insertSeparator()

                q = QPopupMenu (self)
                p = QPopupMenu (self)

                p.insertItem(i18n("DCOPClient"), self.testDCOPClient)
                p.insertItem(i18n("DCOPObject"), self.testDCOPObject)

                q.insertItem ("dcop module", p)

                p = QPopupMenu (self)
                p.insertItem(i18n("KAboutData"), self.testKAboutData)
                p.insertItem(i18n("KAccel"), self.testKAccel)
                p.insertItem(i18n("KApplication"), self.testKApplication)
                p.insertItem(i18n("KCharsets"), self.testKCharsets)
                p.insertItem(i18n("KCmdLineArgs"), self.testKCmdLineArgs)
                p.insertItem(i18n("KCompletionBase"), self.testKCompletionBase)
                p.insertItem(i18n("KConfig"), self.testKConfig)
                p.insertItem(i18n("KConfigBase"), self.testKConfigBase)
                p.insertItem(i18n("KCrash"), self.testKCrash)
                p.insertItem(i18n("KDCOPProperty"), self.testKDCOPProperty)
                p.insertItem(i18n("KDEStyle"), self.testKDEStyle)
                p.insertItem(i18n("KGlobal"), self.testKGlobal)
                p.insertItem(i18n("KGlobalAccel"), self.testKGlobalAccel)
                p.insertItem(i18n("KGlobalSettings"), self.testKGlobalSettings)
                p.insertItem(i18n("KIconTheme"), self.testKIconTheme)
                p.insertItem(i18n("KLocale"), self.testKLocale)
                p.insertItem(i18n("KProcess"), self.testKProcess)
                p.insertItem(i18n("KRandomSequence"), self.testKRandomSequence)
                p.insertItem(i18n("KStyle"), self.testKStyle)
                p.insertItem(i18n("KURL"), self.testKURL)
                p.setItemEnabled (id, FALSE)
                p.insertItem(i18n("KURLDrag"), self.testKURLDrag)
                p.insertItem(i18n("KWin"), self.testKWin)
                p.setItemEnabled (id, FALSE)
                p.insertItem(i18n("KWinModule"), self.testKWinModule)
                p.insertItem(i18n("NETRootInfo"), self.testNETRootInfo)
                p.insertItem(i18n("NETWinInfo"), self.testNETWinInfo)

                q.insertItem ("kdecore module", p)

                # items commented out have no manually written code to test,
                # but probably have unimplemented methods

                p = QPopupMenu (self)
#                p.insertItem(i18n("KActionCollection"), self.testKActionCollection)
#                p.insertItem(i18n("KCharSelect"), self.testKCharSelect)
#                p.insertItem(i18n("KCharSelectTable"), self.testKCharSelectTable)
                p.insertItem(i18n("KColor"), self.testKColor)
                p.insertItem(i18n("KCommandHistory"), self.testKCommandHistory)
#                p.insertItem(i18n("KDateValidator"), self.testKDateValidator)
                p.insertItem(i18n("KDCOPActionProxy"), self.testKDCOPActionProxy)
                p.insertItem(i18n("KDockTablCtl"), self.testKDockTabCtl)
                p.insertItem(i18n("KEdit"), self.testKEdit)
                p.insertItem(i18n("KEditListBox"), self.testKEditListBox)
                p.insertItem(i18n("KImageEffect"), self.testKImageEffect)
                p.insertItem(i18n("KLineEditDlg"), self.testKLineEditDlg)
                p.insertItem(i18n("KListView"), self.testKListView)
                p.insertItem(i18n("KMainWindow"), self.testKMainWindow)
#                p.insertItem(i18n("KIntSpinBox"), self.testKIntSpinBox)
#                p.insertItem(i18n("KIntValidator"), self.testKIntValidator)
#                p.insertItem(i18n("KFloatValidator"), self.testKFloatValidator)
                p.insertItem(i18n("KPasswordDialog"), self.testKPasswordDialog)
#                p.insertItem(i18n("KThemeBase"), self.testKThemeStyle)
#                p.insertItem(i18n("KThemeStyle"), self.testKThemeStyle)
#                p.insertItem(i18n("KToolbar"), self.testKToolbar)
                p.insertItem(i18n("KXMLGUIBuilder"), self.testKXMLGUIBuilder)
                p.insertItem(i18n("KXMLGUIFactory"), self.testKXMLGUIFactory)

                q.insertItem ("kdeui module", p)

                id = q.insertItem ("kab module", None)
                q.setItemEnabled (id, FALSE)
                id = q.insertItem ("kspell module", None)
                q.setItemEnabled (id, FALSE)
                id = q.insertItem ("kio module", None)
                q.setItemEnabled (id, FALSE)
                id = q.insertItem ("kfile module", None)
                q.setItemEnabled (id, FALSE)
                id = q.insertItem ("khtml module", None)
                q.setItemEnabled (id, FALSE)
                id = q.insertItem ("kparts module", None)
                q.setItemEnabled (id, FALSE)

                #// put the popupmenu as File-menu into the menu bar
                self.menuBar().insertItem(i18n("&Test"), q)
                self.menuBar().insertSeparator()


                #// we let KDE generate a nifty help menu
                p = self.helpMenu(i18n("testPyKDE --- frontend for PyKDE class/method tests\n\n"
		    "(c) 2001 Jim Bublitz\n"
		    "Test Application for PyKDE.\n"
                    ""))

                self.menuBar().insertItem(i18n("&Help"), p)

                #//---------------------------------------------------
                #// build a small toolbar

                #// insert some buttons, the icons are from the standard KDE toolbar.

                self.toolBar().insertButton(BarIcon("fileopen.xpm"),TOOLBAR_OPEN, TRUE ,i18n("Open File"))

                #// Hint: toolBar() returns toolBar(0). If you want another toolbar, simply
                #//       use toolBar(1), toolBar(2) and so on.

                #// we connect the entire toolbar to one single slot. We could also
                #// connect the single toolbar buttons to special slots in the
                #// insertButton call above, for example:
                #//   insertButton(BarIcon("exit.xpm"),TOOLBAR_EXIT,
                #//                SIGNAL(clicked()), kapp, SLOT(quit()),
                #//                true,"Exit")
                #// This would be even better for this simple toolbar. We have chosen
                #// the other design --- which is more flexible for bigger toolbars ---
                #// for demonstration purposes in kless.

                self.connect(self.toolBar(), SIGNAL("clicked(int)"), self.slotToolbarClicked)



        def slotToolbarClicked(self, item):
               if item == TOOLBAR_OPEN:
                        self.slotLoadFile()

        def loadFile(self, filename):
        #// load a file from a filename
                self.edit.clear ()

                print "Filename:", filename.path ()

                f = QFile (filename.path ())
                if f.open(IO_ReadOnly):
                        t = QTextStream (f)
                        while (not t.eof()):
                                self.edit.append (t.readLine ())
                f.close()

        def dropEvent(self, event):
        #  #// the user dropped something on our window.
        #  // So we simply use KIO slaves to download the stuff wherever it is.
        #  // The following code respects Qt's DnD tutorial
                print "drop event"

                im = QImage ()
                txt = QString ()
                u   = QString ()
                uri = []

                if QImageDrag.decode(event, im):
                        KMessageBox.sorry(this, i18n("This application accepts only URL drops"))

                if QTextDrag.decode(event, txt):
                        print "text"
                        setCaption("The KDE text viewer")
                        self.edit.setText(txt)

                if QUriDrag.decode(event, uri):
                        u = uri [0]
                        print "uri", u
                        loadFile(u)

        def slotNewWindow(self):
                #// this slot is invoked from File->New_Window
                w = KTestPyKDE (self, "child")
                w.show()
                self.show ()

        def slotLoadFile(self):
                #// this slot is invoked from File->Open

                #// ask kfiledialog for a filename. We pass "this" to the function
                #// to indicate the window manager that the file dialog belongs
                #// to our application window.
                u = KFileDialog.getOpenURL(QString.null,     # initial dir
                                    QString.null,              # filter
                                    self)

                if not u.isEmpty():
                        self.loadFile(u)


        def queryClose(self):
                res = KMessageBox.warningYesNoCancel(self,\
                        i18n("Save changes to Document?<br>(Does not make sense, we know, but it is just a programming example :-)"))
                if res == KMessageBox.Yes:
	        #// save document here. If saving fails, return FALSE
	                return TRUE

                elif res == KMessageBox.No:
                        return TRUE

                else: #// cancel
	                return FALSE

        def queryExit(self):
                #// this slot is invoked in addition when the *last* window is going
                #// to be closed. We could do some final cleanup here.
                return TRUE #// accept

#// Session management: save data
        def saveProperties(self, config):
  #// This is provided just as an example.
  #// It is generally not so good to save the raw contents of an application
  #//  in its configuration file (as this example does).
  #// It is preferable to save the contents in a file on the application's
  #//  data zone and save an URL to it in the configuration resource.
                config.writeEntry("text", self.edit.text())


#// Session management: read data again
        def readProperties(self, config):
  #// See above
                self.edit.setText(config.readEntry("text"))

        def testDCOPClient (self):
                dlg = testdcop.testDCOPClient (self, app.dcopClient ())
                dlg.show ()

        def testDCOPObject (self):
                self.notImpl ()

        def testKAboutData (self):
                dlg = testkdecore.testKAboutData (self)
                dlg.show ()

        def testKAccel (self):
                dlg = testkdecore.testKAccel (self)
                dlg.show ()

        def testKApplication (self):
                dlg = testkdecore.testKApplication (self)
                dlg.show ()

        def testKCharsets (self):
                self.notImpl ()

        def testKCmdLineArgs (self):
                self.notImpl ()

        def testKCompletionBase (self):
                self.notImpl ()

        def testKConfig (self):
                self.notImpl ()

        def testKConfigBase (self):
                self.notImpl ()

        def testKCrash (self):
                self.notImpl ()

        def testKDCOPProperty (self):
                self.notImpl ()

        def testKDEStyle (self):
                self.notImpl ()

        def testKGlobal (self):
                self.notImpl ()

        def testKGlobalAccel (self):
                self.notImpl ()

        def testKGlobalAccel (self):
                self.notImpl ()

        def testKGlobalSettings (self):
                self.notImpl ()

        def testKIconTheme (self):
                self.notImpl ()

        def testKLocale (self):
                self.notImpl ()

        def testKProcess (self):
                self.notImpl ()

        def testKRandomSequence (self):
                self.notImpl ()

        def testKStyle (self):
                self.notImpl ()

        def testKURL (self):
                self.notImpl ()

        def testKURLDrag (self):
                self.notImpl ()

        def testKWin (self):
                self.notImpl ()

        def testKWinModule (self):
                self.notImpl ()

        def testNETRootInfo (self):
                self.notImpl ()

        def testNETWinInfo (self):
                self.notImpl ()

        def testKActionCollection (self):
                self.notImpl ()

        def testKCharSelect (self):
                self.notImpl ()

        def testKCharSelectTable (self):
                self.notImpl ()

        def testKColor (self):
                dlg = testkdeui.testKColor (self)
                dlg.show ()

        def testKCommandHistory (self):
                self.notImpl ()

        def testKDateValidator (self):
                self.notImpl ()

        def testKDCOPActionProxy (self):
                self.notImpl ()

        def testKDockTabCtl (self):
                self.notImpl ()

        def testKEdit (self):
                dlg = testkdeui.testKEdit (self)
                dlg.show ()

        def testKEditListBox (self):
                dlg = testkdeui.testKEditListBox (self)
                dlg.show ()

        def testKImageEffect (self):
                self.notImpl ()

        def testKLineEditDlg (self):
                dlg = testkdeui.testKLineEditDlg (self)
                dlg.show ()

        def testKListView (self):
                dlg = testkdeui.testKListView (self)
                dlg.show ()

        def testKMainWindow (self):
                dlg = testkdeui.testKMainWindow (self)
                dlg.show ()

        def testKIntSpinBox (self):
                self.notImpl ()

        def testKIntValidator (self):
                self.notImpl ()

        def testKFloatValidator (self):
                self.notImpl ()

        def testKPasswordDialog (self):
                dlg = testkdeui.testKPasswordDialog (self)
                dlg.show ()

        def testKThemeBase (self):
                self.notImpl ()

        def testKThemeStyle (self):
                self.notImpl ()

        def testKToolbar (self):
                self.notImpl ()

        def testKXMLGUIBuilder (self):
                self.notImpl ()

        def testKXMLGUIFactory (self):
                self.notImpl ()

        def notImpl (self):
                dlg = KMessageBox.sorry (self, "Testing for this class has not been implemented",
                        "Not Implemented")

#// A Human readable description of your program
description = "PyKD@ Test Application"

#// The version
version = "0.1"


aboutData = KAboutData ("testPyKDE", "KTestPyKDE",\
    version, description, KAboutData.License_GPL,\
    "(c) 2001, Jim bublitz")

aboutData.addAuthor ("Jim Bublitz", "TestPyKDE", "jbublitz@nwinternet.com")


KCmdLineArgs.init (sys.argv, "testPyKDE", description, version)

KCmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = KApplication ()
if (app.isRestored()):
        RESTORE(KLess)
else:
    #// no session management: just create one window
        ktest = KTestPyKDE (None, "testPyKDE")
        if len(sys.argv) > 1:
    #// read kcmdlineargs.h for the full unabridged instructions
    #// on using KCmdLineArgs, it's pretty confusing at first, but it works
                args = KCmdLineArgs.parsedArgs()
                print "Args:", args
                print str(QDir.currentDirPath ()) + "/"
                print sys.argv [0]

                url = str(QDir.currentDirPath()) + "/" + sys.argv [0];

                ktest.loadFile(KURL(url))
#        args->clear()

ktest.show()

app.exec_loop()
