#
#       Tests for kdecore module - Copyright 2001 Jim Bublitz <jbublitz@nwinternet.com>
#

from kdecore import KApplication, i18n, KAboutData, KAccel
from kdeui import KDialogBase, KEdit, KComboBox
from qt import QLabel, SIGNAL, SLOT, QObject, QPopupMenu, QStringList

FALSE = 0
TRUE = not FALSE

class testKAboutData (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, "testKAboutData Dlg", TRUE, "Test KAboutData",
                        KDialogBase.Close | KDialogBase.User1, KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", vbox)
                self.ked = KEdit (vbox)

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testKAboutData)

                self.abtData = KAboutData ("PyKDE", "testPyKDE", "0,1")
                self.abtData.addAuthor ("Mark Twain", "Write books", "clements@earthlink.com", "www.twain.com")
                self.abtData.addAuthor ("William Shakespeare", "The Play's the Thing", "will@avon-bank.demon.co.uk")
                self.abtData.addCredit ("Guido van Rossum", "Python", "guido@python.org")
                self.abtData.setTranslator ("i18n", "KLocale")

        def testKAboutData (self):
                self.ked.clear ()
                self.ked.insertLine ("Testing KAboutData ...")
                self.ked.insertLine ("")


                self.ked.insertLine ("     aboutAuthors ()")
                self.ked.insertLine ("==========================")
                self.ked.insertLine ("")

                result = self.abtData.authors ()
                print "authors:", result

                for item in result:
                        print "author:", item, item.name ()

                if result == []:
                        self.ked.insertLine ("<empty list>")
                else:   #item is a KAboutPerson object
                        for item in result:
                                self.ked.insertLine (str (item.name ()) + " " + str (item.task ()) + " "
                                        + str (item.emailAddress ()) + " " + str (item.webAddress ()))

                self.ked.insertLine ("")



                self.ked.insertLine ("     aboutCredits ()")
                self.ked.insertLine ("==========================")
                self.ked.insertLine ("")

                result = self.abtData.credits ()
                print result

                for item in result:
                        print "credit:", item, item.name ()

                if result == []:
                        self.ked.insertLine ("<empty list>")
                else:
                        for item in result:
                                self.ked.insertLine (str (item.name ()) + " " + str (item.task ()) + " "
                                        + str (item.emailAddress ()) + " " + str (item.webAddress ()))

                self.ked.insertLine ("")



                self.ked.insertLine ("     translators ()")
                self.ked.insertLine ("==========================")
                self.ked.insertLine ("")

                result = self.abtData.translators ()
                # empty is OK if there is no translation
                print "translator:", result

                for item in result:
                        print "translator:", item

                if result  == []:
                        self.ked.insertLine ("<empty list>")
                else:
                        self.ked.insertLine ("")
                        for item in result:
                                self.ked.insertLine (item.name ())

                self.ked.insertLine ("")


class testKAccel (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, "testKAccel Dlg", FALSE, "Test KAccel",
                        KDialogBase.Close | KDialogBase.User1, KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                self.setGeometry (100, 100, 500, 500)
                vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", vbox)
                self.ked = KEdit (vbox)

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testKAccel)
                self.connect (self, SIGNAL ("closeClicked ()"), self.testKAccelClose)

                # setup for testing KAccel

                p = QPopupMenu (self)

                self.accel = KAccel(self)
                self.ked.insertLine (i18n("Inserting Test 1 ..."))
                self.accel.insertItem( i18n("Test 1"), "Test 1", "Ctrl+A" );
                self.ked.insertLine (i18n("Inserting Test 2 ..."))
                self.accel.insertItem( i18n("Test 2"), "Test 2", "Ctrl+B" );

                self.ked.insertLine (i18n("Connecting Test 1 ..."))
                self.accel.connectItem("Test 1", self.test1)

                id = p.insertItem(i18n("Test 1"), self.test1)
                self.accel.changeMenuAccel(p, id, "Test 1")

                self.ked.insertLine (i18n("Adding item to menuBar ..."))
                self.parent ().menuBar().insertSeparator()
                self.mbID = self.parent ().menuBar().insertItem(i18n("&KAccel_Test"), p)
                self.parent ().menuBar().insertSeparator()
                self.ked.insertLine ("")
                self.ked.insertLine ("Ready to test ...")


        def testKAccel (self):
                self.ked.clear ()
                self.ked.insertLine ("Testing KAccel ...")
                self.ked.insertLine ("")

                map   = self.accel.keyDict ()

                keyList = map.keys ()
                for key in keyList:
                        tuple = map [key]
                        self.ked.insertLine (key + ":")

#               struct KKeyEntry {
#                public:
#                   int aCurrentKeyCode;
#                   int aDefaultKeyCode;
#                   int aConfigKeyCode;
#                   bool bConfigurable;
#                   bool bEnabled;
#                   int aAccelId;
#                   const QObject *receiver;
#                   const char *member;
#                   QString descr;
#                   int menuId;
#                   QPopupMenu *menu;
#               };
                        self.ked.insertLine ("   aCurrentKeyCode = " + str (tuple [0]))
                        self.ked.insertLine ("   aDefaultKeyCode = " + str (tuple [1]))
                        self.ked.insertLine ("   aConfigKeyCode  = " + str (tuple [2]))
                        if tuple [3]:
                                self.ked.insertLine ("   bConfigurable      = TRUE")
                        else:
                                self.ked.insertLine ("   bConfigurable      = FALSE")
                        if tuple [4]:
                                self.ked.insertLine ("   bEnabled            = TRUE")
                        else:
                                self.ked.insertLine ("   bEnabled            = FALSE")

                        self.ked.insertLine ("   aAccelId             = " + str (tuple [5]))

			if tuple [6] == None:
                                self.ked.insertLine ("   receiver              = None")
                        else:
                                self.ked.insertLine ("   receiver              = %r [%s]" %(tuple [6], tuple [6].name ()))
                        if tuple [7] == None:
                                self.ked.insertLine ("   member               = None")
                        else:
                                self.ked.insertLine ("   member               = " + str(tuple [7]))

                        self.ked.insertLine ("   descr                  = " + str (tuple [8]))

			self.ked.insertLine ("   menuId                = " + str (tuple [9]))
                        if tuple [10] == None:
                                self.ked.insertLine ("   menu                  = None")
                        else:
                                self.ked.insertLine ("   menu                  = %r" %tuple [10])
                        self.ked.insertLine ("")
                        self.ked.insertLine ("... Try pressing CTRL + A ...")
                        self.ked.insertLine ("")
                        self.ked.setCursorPosition (self.ked.numLines (), 0)


        def test1 (self):
                print "Test 1 selected"
                self.ked.insertLine ("")
                self.ked.insertLine (" *** Test 1 selected - CTRL + A pressed ***")
                self.ked.insertLine ("")
                self.ked.setCursorPosition (self.ked.numLines (), 0)


        def testKAccelClose (self):
                self.parent ().menuBar ().removeItem (self.mbID)


class testKApplication (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, "testKApplication Dlg", FALSE, "Test KApplication",
                        KDialogBase.Close | KDialogBase.User1, KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", vbox)
                self.ked = KEdit (vbox)
                self.cb  = KComboBox (vbox)
                self.cb.insertItem ("startServiceByName - QString")
                self.cb.insertItem ("startServiceByName - QStringList")
                self.cb.insertItem ("startServiceByDesktopPath - QString")
                self.cb.insertItem ("startServiceByDesktopPath - QStringList")
                self.cb.insertItem ("startServiceByDesktopName - QString")
                self.cb.insertItem ("startServiceByDesktopName - QStringList")
                self.cb.insertItem ("kdeinitExec")
                self.cb.insertItem ("kdeinitExecWait")

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testKApplication)

                self.ked.insertLine ("Testing KApplication ...")
                self.ked.insertLine ("")
                self.ked.insertLine ("Select method in combo box and press test ...")


        def testKApplication (self):
                svcName     = "Advanced Editor"
                appName     = "kwrite"
                applnkName  = '/opt/kde2/share/applnk/Editors/kwrite.desktop'
                appPath     = '/opt/kde2/bin/kwrite'
                fileName    = 'testfile.py'
                qsl         = QStringList (fileName)
                current     = str(self.cb.currentText ())

                self.ked.clear ()
                self.ked.insertLine ("Testing " + current)
                self.ked.insertLine ("")
                self.ked.insertLine ("Error test ...")
                self.ked.insertLine ("")

                if current == "startServiceByName - QString":
                        self.ked.insertLine ("KApplication.startServiceByName (" + appName + ", " + fileName + ")")
                        # the next line should return an error message in result [0]
                        result = KApplication.startServiceByName (appName, fileName)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                        self.ked.insertLine ("Launching kwrite ...")
                        self.ked.insertLine ("")
                        self.ked.insertLine ("KApplication.startServiceByName (" + svcName + ", " + fileName + ")")
                        result = KApplication.startServiceByName (svcName, fileName)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                elif current == "startServiceByName - QStringList":
                        self.ked.insertLine ("KApplication.startServiceByName (" + appName + ", <QStringList>)")
                        # the next line should return an error message in result [0]
                        result = KApplication.startServiceByName (appName, qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                        self.ked.insertLine ("Launching kwrite ...")
                        self.ked.insertLine ("")
                        self.ked.insertLine ("KApplication.startServiceByName (" + svcName + ", <QStringList>)")
                        result = KApplication.startServiceByName (svcName, qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                elif current == "startServiceByDesktopPath - QString":
                        self.ked.insertLine ("KApplication.startServiceByDesktopPath (" + appName + ", " + fileName + ")")
                        # the next line should return an error message in result [0]
                        result = KApplication.startServiceByDesktopPath (appName, fileName)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                        self.ked.insertLine ("Launching kwrite ...")
                        self.ked.insertLine ("")
                        self.ked.insertLine ("KApplication.startServiceByDesktopPath (" + applnkName + ", " + fileName + ")")
                        result = KApplication.startServiceByDesktopPath (applnkName, fileName)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                elif current == "startServiceByDesktopPath - QStringList":
                        self.ked.insertLine ("KApplication.startServiceByDesktopPath (" + appName + ", <QStringList>)")
                        # the next line should return an error message in result [0]
                        result = KApplication.startServiceByDesktopPath (appName, qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                        self.ked.insertLine ("Launching kwrite ...")
                        self.ked.insertLine ("")
                        self.ked.insertLine ("KApplication.startServiceByDesktopPath (" + applnkName + ", <QStringList>)")
                        result = KApplication.startServiceByDesktopPath (applnkName, qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                elif current ==  "startServiceByDesktopName - QString":
                        self.ked.insertLine ("KApplication.startServiceByDesktopName (" + applnkName + ", " + fileName + ")")
                        # the next line should return an error message in result [0]
                        result = KApplication.startServiceByDesktopName (applnkName, fileName)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                        self.ked.insertLine ("Launching kwrite ...")
                        self.ked.insertLine ("")
                        self.ked.insertLine ("KApplication.startServiceByDesktopName (" + appName + ", " + fileName + ")")
                        result = KApplication.startServiceByDesktopName (appName, fileName)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                elif current == "startServiceByDesktopName - QStringList":
                        self.ked.insertLine ("KApplication.startServiceByDesktopName (" + applnkName + ",  <QStringList>)")
                        # the next line should return an error message in result [0]
                        result = KApplication.startServiceByDesktopName (applnkName, qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                        self.ked.insertLine ("Launching kwrite ...")
                        self.ked.insertLine ("")
                        self.ked.insertLine ("KApplication.startServiceByDesktopName (" + appName + ", <QStringList>)")
                        result = KApplication.startServiceByDesktopName (appName, qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   dcopService = " + str (result [1]))
                        self.ked.insertLine ("   pid              = " + str (result [2]))
                        self.ked.insertLine ("   return val     = " + str (result [3]))
                        self.ked.insertLine ("")

                elif current == "kdeinitExec":
                        self.ked.insertLine ("KApplication.kdeinitExec (" + appName + "junk, <QStringList>)")
                        # the next line should return an error message in result [0]
                        result = KApplication.kdeinitExec (appName + 'junk', qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   pid              = " + str (result [1]))
                        self.ked.insertLine ("   return val     = " + str (result [2]))
                        self.ked.insertLine ("")

                        self.ked.insertLine ("Launching kwrite ...")
                        self.ked.insertLine ("")
                        self.ked.insertLine ("KApplication.kdeinitExec (" + appPath + ", <QStringList>)")
                        result = KApplication.kdeinitExec (appPath, qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   pid              = " + str (result [1]))
                        self.ked.insertLine ("   return val     = " + str (result [2]))
                        self.ked.insertLine ("")

                elif current == "kdeinitExecWait":
                        self.ked.insertLine ("KApplication.kdeinitExecWait (" + appName + "junk, <QStringList>)")
                        # the next line should return an error message in result [0]
                        result = KApplication.kdeinitExecWait (appName + 'junk', qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   pid              = " + str (result [1]))
                        self.ked.insertLine ("   return val     = " + str (result [2]))
                        self.ked.insertLine ("")

                        self.ked.insertLine ("Launching kwrite ...")
                        self.ked.insertLine ("")
                        self.ked.insertLine ("KApplication.kdeinitExecWait (" + appPath + ", <QStringList>)")
                        result = KApplication.kdeinitExecWait (appPath, qsl)
                        self.ked.insertLine ("   error            = " + str (result [0]))
                        self.ked.insertLine ("   pid              = " + str (result [1]))
                        self.ked.insertLine ("   return val     = " + str (result [2]))
                        self.ked.insertLine ("")



