/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kurldrag.h>

// WorKflow includes
#include "parameter.h"
#include "result.h"

// command includes
#include "getfilescommand.h"
#include "getfileswidget.h"

using namespace WorKflow;

GetFilesCommand::GetFilesCommand(Document* parent, WorKflow::CommandDescription* description)
  : Command(parent, description)
{
  GetFilesWidget* w = new GetFilesWidget(this);
  setWidget(w);
}

GetFilesCommand::~GetFilesCommand()
{

}

void GetFilesCommand::updateParameters()
{
  GetFilesWidget* w = static_cast<GetFilesWidget*>(widget());
  parameter("files")->setStaticValue(Value::stringList("org.kde.public.fileorfolder", w->urls()));
}

void GetFilesCommand::updateWidget()
{
  GetFilesWidget* w = static_cast<GetFilesWidget*>(widget());
  w->setUrls(value("files").asStringList());
}

bool GetFilesCommand::drop(QMimeSource* source)
{
  if (QUriDrag::canDecode(source)) {
    KURL::List urls;
    if (KURLDrag::decode(source, urls)) {
      GetFilesWidget* w = static_cast<GetFilesWidget*>(widget());
      w->setUrls(urls);
    } else
      return false;
  } else
    return false;
  return true;
}

#include "getfilescommand.moc"
