/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kio/job.h>
#include <klocale.h>

// command includes
#include "movefilescommand.h"
#include "copyfileswidget.h"

using namespace WorKflow;

MoveFilesCommand::MoveFilesCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  CopyFilesWidget* w = new CopyFilesWidget(this);
  setWidget(w);
}

MoveFilesCommand::~MoveFilesCommand()
{
}

void MoveFilesCommand::execute()
{
  KURL::List files(value("files").asStringList());
  KURL dest = value("destination").asStringList().first();

  m_prog = 0;

  emit progress(0, i18n("Getting file list"));

  KURL::List list(files);
  KIO::CopyJob* job = KIO::move(files, dest, false);

  connect(job, SIGNAL(moving(KIO::Job*, const KURL&, const KURL&)), this, SLOT(showProgress(KIO::Job*, const KURL&, const KURL&)));
  connect(job, SIGNAL(percent(KIO::Job*, unsigned long)), this, SLOT(setPercent(KIO::Job*, unsigned long)));

  waitFor(job, SIGNAL(result(KIO::Job*)));

  QStringList moved;
  for (KURL::List::ConstIterator i = files.begin(); i != files.end(); ++i) {
    KURL file = *i;
    KURL destfile(dest);
    destfile.addPath(file.fileName());

    moved << destfile.url();
  }

  setResult("moved", Value::stringList("org.kde.public.fileorfolder", moved));
}

void MoveFilesCommand::showProgress(KIO::Job*, const KURL& source, const KURL& dest)
{
  emit progress(m_prog, i18n("Moving file %1 to %2").arg(source.url()).arg(dest.url()));
}

void MoveFilesCommand::setPercent(KIO::Job*, unsigned long percent)
{
  m_prog = double(percent) / 100.0;
}

#include "movefilescommand.moc"
