/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qlabel.h>

// WorKflow includes
#include "combobox.h"
#include "slider.h"

// command includes
#include "convertimagewidget.h"

using namespace WorKflow;

ConvertImageWidget::ConvertImageWidget(Command* command)
  : ConvertImageWidgetBase(0)
{
  setCommand(command);
}

ConvertImageWidget::~ConvertImageWidget()
{
}

void ConvertImageWidget::setQualityState()
{
  bool enable = m_typeComboBox->value().enumKey() != "bmp";

  // disable quality slider for windows bitmap
  m_qualityLabel->setEnabled(enable);
  m_qualitySlider->setEnabled(enable);
  m_qualityDisplay->setEnabled(enable);
}

#include "convertimagewidget.moc"
