/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kprocess.h>
#include <kurl.h>
#include <klocale.h>

// command includes
#include "scaleimagecommand.h"
#include "scaleimagewidget.h"

using namespace WorKflow;

ScaleImageCommand::ScaleImageCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  ScaleImageWidget* w = new ScaleImageWidget(this);
  setWidget(w);
}

ScaleImageCommand::~ScaleImageCommand()
{
}

void ScaleImageCommand::execute()
{
  QStringList files = value("input").asStringList();

  QString mode = value("mode").enumKey();
  int size = value("size").nextNumber();

  int count = files.count();
  int num = 1;
  for (QStringList::ConstIterator i = files.begin(); i != files.end(); ++i, ++num) {
    KProcess proc;
    proc << "convert";
    KURL url(*i);

    if (url.isLocalFile()) {
      QString path = url.path();

      emit progress(double(num) / double(count), i18n("Scaling image %1").arg(*i));

      proc << "-resize";

      if (mode == "pixel")
        proc << QString::number(size);
      else
        proc << QString::number(size) + '%';

      proc << path << path;
      proc.start();

      waitFor(&proc, SIGNAL(processExited(KProcess*)));
    } else {
      // TODO: warn user? or download and upload afterwards?
    }
  }

  Command::execute();
}

#include "scaleimagecommand.moc"
