/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kprocess.h>
#include <kdebug.h>

// Qt includes
#include <qlineedit.h>
#include <qtextedit.h>
#include <qcheckbox.h>

// command includes
#include "shellexecutecommand.h"
#include "shellexecutewidget.h"

using namespace WorKflow;

ShellExecuteCommand::ShellExecuteCommand(Document* parent, CommandDescription* description)
  : Command(parent, description), m_finished(false)
{
  ShellExecuteWidget* w = new ShellExecuteWidget(this);
  setWidget(w);

  // for now, this has to be here :(
  connect(w->m_inputCheckBox, SIGNAL(toggled(bool)), this, SIGNAL(sizeChanged()));
}

ShellExecuteCommand::~ShellExecuteCommand()
{
}

void ShellExecuteCommand::execute()
{
  KProcess proc(this);

  // executable name
  proc << value("command").nextString();

  // arguments
  proc << value("arguments").asStringList();

  connect(&proc, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(slotStdout(KProcess*, char*, int)));
  connect(&proc, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(slotStderr(KProcess*, char*, int)));

  m_finished = false;
  m_stdout = "";
  m_stderr = "";

  proc.start(KProcess::NotifyOnExit, KProcess::All);

  QString input = value("input").nextString();
  proc.writeStdin(input.latin1(), input.length());
  proc.closeStdin();

  waitFor(&proc, SIGNAL(processExited(KProcess*)));

  setResult("output", Value::stringList("org.kde.public.text", QStringList::split("\n", m_stdout)));
  setResult("error", Value::stringList("org.kde.public.text", QStringList::split("\n", m_stderr)));
}

void ShellExecuteCommand::slotStdout(KProcess* /* proc */, char* buffer, int buflen)
{
  m_stdout += QString::fromLatin1(buffer, buflen);
}

void ShellExecuteCommand::slotStderr(KProcess* /* proc */, char* buffer, int buflen)
{
  m_stderr += QString::fromLatin1(buffer, buflen);
}

#include "shellexecutecommand.moc"
