/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qmap.h>

// STL includes
#include <algorithm>
  using std::reverse;

// command includes
#include "sortlistcommand.h"
#include "sortlistwidget.h"

using namespace WorKflow;

SortListCommand::SortListCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  SortListWidget* w = new SortListWidget(this);
  setWidget(w);
}

SortListCommand::~SortListCommand()
{
}

void SortListCommand::execute()
{
  QStringList items = value("input").asStringList();
  QStringList res;

  bool casesens = value("casesensitive").nextBoolean();
  bool rev = value("reverseorder").nextBoolean();

  QMap<QString, QString> map;
  for (QStringList::ConstIterator i = items.begin(); i != items.end(); ++i) {
    if (casesens)
      map.insert(*i, *i);
    else
      map.insert((*i).lower(), *i, false);
  }

  if (rev) {
    QMap<QString, QString>::ConstIterator i = map.end();
    while (i != map.begin()) {
      --i;
      res << i.data();
    }
  } else {
    for (QMap<QString, QString>::ConstIterator i = map.begin(); i != map.end(); ++i) {
      res << i.data();
    }
  }

  setResult("output", Value::stringList("org.kde.public.anything", res));
}

#include "sortlistcommand.moc"
