/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "parameter.h"

// command includes
#include "removesuffixcommand.h"
#include "removesuffixwidget.h"

using namespace WorKflow;

RemoveSuffixCommand::RemoveSuffixCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  RemoveSuffixWidget* w = new RemoveSuffixWidget(this);
  setWidget(w);
}

RemoveSuffixCommand::~RemoveSuffixCommand()
{
}

void RemoveSuffixCommand::execute()
{
  QStringList text = value("input").asStringList();
  QString suffix = value("string").nextString();

  int suffixlen = suffix.length();

  for (QStringList::Iterator i = text.begin(); i != text.end(); ++i)
    if ((*i).endsWith(suffix))
      (*i) = (*i).left((*i).length() - suffixlen);

  setResult("output", Value::stringList(parameter("input")->typeId(), text));
}

#include "removesuffixcommand.moc"
